/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class TaxaListUtils {
    private TaxaListUtils() {
    }

    public static TaxaList getCommonTaxa(TaxaList group1, TaxaList group2) {
        return TaxaListUtils.getCommonTaxa(new TaxaList[]{group1, group2});
    }

    public static TaxaList getCommonTaxa(TaxaList[] groups) {
        return TaxaListUtils.getCommonTaxa(groups, true);
    }

    public static TaxaList getCommonTaxa(TaxaList[] groups, boolean sorted) {
        if (groups == null || groups.length == 0) {
            return null;
        }
        if (groups.length == 1 && !sorted) {
            return groups[0];
        }
        LinkedHashSet<Taxon> intersectIds = new LinkedHashSet<Taxon>();
        for (Taxon current : groups[0]) {
            intersectIds.add(current);
        }
        for (int i = 1; i < groups.length; ++i) {
            ArrayList<Taxon> temp = new ArrayList<Taxon>();
            for (Taxon current : groups[i]) {
                temp.add(current);
            }
            intersectIds.retainAll(temp);
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        builder.addAll(intersectIds);
        if (sorted) {
            builder.sortTaxaAlphabetically();
        }
        return builder.build();
    }

    public static TaxaList getAllTaxa(TaxaList group1, TaxaList group2) {
        return TaxaListUtils.getAllTaxa(new TaxaList[]{group1, group2});
    }

    public static TaxaList getAllTaxa(TaxaList[] groups) {
        return TaxaListUtils.getAllTaxa(groups, true);
    }

    public static TaxaList getAllTaxa(TaxaList[] lists, boolean sorted) {
        if (lists == null || lists.length == 0) {
            return null;
        }
        if (lists.length == 1) {
            return lists[0];
        }
        ArrayList<Taxon> allIds = new ArrayList<Taxon>();
        for (Taxon current : lists[0]) {
            allIds.add(current);
        }
        for (int i = 1; i < lists.length; ++i) {
            int insertIndex = 0;
            for (Taxon current : lists[i]) {
                int index = allIds.indexOf(current);
                if (index == -1) {
                    allIds.add(insertIndex++, current);
                    continue;
                }
                insertIndex = Math.max(index + 1, insertIndex);
            }
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        builder.addAll((Collection<Taxon>)allIds);
        if (sorted) {
            builder.sortTaxaAlphabetically();
        }
        return builder.build();
    }
}

