/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixWithCounts;
import net.maizegenetics.util.GeneralAnnotation;

public class DistanceMatrixBuilder {
    public static final String MATRIX_TYPE = "Matrix_Type";
    public static final String MATRIX_ALGORITHM_VARIATION = "Matrix_Variation";
    public static final String CENTERED_IBS_SUMPK = "Centered_IBS.SumPk";
    public static final String IBS_DISTANCE_MATRIX_TYPE = "IBS_Distance_Matrix";
    public static final String IBS_DISTANCE_MATRIX_NUM_ALLELES = "IBS_Distance_Matrix.NumAlleles";
    public static final String IBS_DISTANCE_MATRIX_AVE_TOTAL_SITES = "IBS_Distance_Matrix.AverageTotalSites";
    public static final String IBS_DISTANCE_MATRIX_TRUE_IBS = "IBS_Distance_Matrix.TrueIBS";
    private final int myNumTaxa;
    private final TaxaList myTaxa;
    private final float[][] myMatrix;
    private GeneralAnnotation myAnnotation = null;
    private final TaxaListBuilder myTaxaBuilder;
    private int[][] myCounts = null;

    private DistanceMatrixBuilder(int numTaxa, TaxaList taxa) {
        this.myTaxa = taxa;
        this.myNumTaxa = numTaxa;
        this.myMatrix = new float[this.myNumTaxa][];
        for (int i = 0; i < this.myNumTaxa; ++i) {
            this.myMatrix[i] = new float[i + 1];
        }
        this.myTaxaBuilder = this.myTaxa == null ? new TaxaListBuilder() : null;
    }

    public static DistanceMatrixBuilder getInstance(TaxaList taxa) {
        return new DistanceMatrixBuilder(taxa.numberOfTaxa(), taxa);
    }

    public static DistanceMatrixBuilder getInstance(int numTaxa) {
        return new DistanceMatrixBuilder(numTaxa, null);
    }

    public void set(int x, int y, float value) {
        if (x > y) {
            this.myMatrix[x][y] = value;
        } else {
            this.myMatrix[y][x] = value;
        }
    }

    public void set(int x, int y, double value) {
        if (x > y) {
            this.myMatrix[x][y] = (float)value;
        } else {
            this.myMatrix[y][x] = (float)value;
        }
    }

    public void addTaxon(Taxon taxon) {
        if (this.myTaxaBuilder == null) {
            throw new IllegalStateException("DistanceMatrixBuilder: addTaxon: this builder was given Taxa List at creation.");
        }
        this.myTaxaBuilder.add(taxon);
    }

    public DistanceMatrixBuilder annotation(GeneralAnnotation annotation) {
        this.myAnnotation = annotation;
        return this;
    }

    public void setCount(int x, int y, int value) {
        if (this.myCounts == null) {
            this.myCounts = new int[this.myNumTaxa][];
            for (int i = 0; i < this.myNumTaxa; ++i) {
                this.myCounts[i] = new int[i + 1];
            }
        }
        if (x > y) {
            this.myCounts[x][y] = value;
        } else {
            this.myCounts[y][x] = value;
        }
    }

    public DistanceMatrix build() {
        TaxaList taxa = null;
        taxa = this.myTaxaBuilder == null ? this.myTaxa : this.myTaxaBuilder.build();
        if (this.myCounts == null) {
            return new DistanceMatrix(this.myMatrix, taxa, this.myAnnotation);
        }
        return new DistanceMatrixWithCounts(this.myMatrix, taxa, this.myAnnotation, this.myCounts);
    }
}

