/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.SimpleNode;
import net.maizegenetics.taxa.tree.SimpleTree;
import net.maizegenetics.taxa.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a$\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u001a \u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013\u001a\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u001c\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c\u001a \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u001a \u0010\u001d\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0013*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"MERGE_ROOT_NODE", "", "myLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "addChildren", "", "nodes", "", "Lnet/maizegenetics/taxa/tree/Node;", "node", "convertNames", "conversions", "", "Lnet/maizegenetics/taxa/tree/Tree;", "tree", "filename", "keepNode", "namesToKeep", "", "makeNode", "newick", "mergeTrees", "trees", "read", "removeBranchLengths", "subsetTree", "taxaList", "Lnet/maizegenetics/taxa/TaxaList;", "write", "includeBranchLengths", "", "writer", "Ljava/io/BufferedWriter;", "tassel"})
@JvmName(name="NewickUtils")
public final class NewickUtils {
    private static final Logger myLogger = Logger.getLogger((String)"net.maizegenetics.taxa.tree.NewickUtils");
    private static final String MERGE_ROOT_NODE = "MERGE_ROOT_NODE";

    @NotNull
    public static final Tree read(@NotNull String filename) {
        char it;
        char element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String newick2 = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)new File(filename), null, (int)1, null), (CharSequence)"", null, null, (int)0, null, (Function1)read.newick.1.INSTANCE, (int)30, null);
        CharSequence $this$count$iv = newick2;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            it = element$iv = charSequence.charAt(n);
            boolean bl = false;
            if (!(it == '(')) continue;
            ++count$iv;
        }
        $this$count$iv = newick2;
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            it = element$iv = charSequence.charAt(n);
            boolean bl = false;
            if (!(it == ')')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 != n3) {
            throw (Throwable)new IllegalArgumentException("NewickUtils: read: " + filename + ": number of open parenthesis doesn't match number of close parenthesis.");
        }
        if (StringsKt.last((CharSequence)newick2) != ';') {
            throw (Throwable)new IllegalArgumentException("NewickUtils: read: " + filename + ": doesn't end with semicolon.");
        }
        String string = newick2;
        int n4 = 0;
        int n5 = newick2.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n4, n5);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return new SimpleTree(NewickUtils.makeNode(string3));
    }

    private static final Node makeNode(String newick2) {
        double d;
        CharSequence charSequence;
        String nameBranchLength = StringsKt.substringAfterLast$default((String)newick2, (char)')', null, (int)2, null);
        String string = StringsKt.replace$default((String)StringsKt.substringBefore$default((String)nameBranchLength, (char)':', null, (int)2, null), (String)"'", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it2 = string;
        boolean bl3 = false;
        try {
            Double.parseDouble(it2);
            charSequence = "";
        }
        catch (NumberFormatException ne) {
            charSequence = StringsKt.replace$default((String)it2, (String)"_", (String)" ", (boolean)false, (int)4, null);
        }
        String name = charSequence;
        if (StringsKt.contains$default((CharSequence)nameBranchLength, (char)':', (boolean)false, (int)2, null)) {
            String string2 = StringsKt.substringAfter$default((String)nameBranchLength, (char)':', null, (int)2, null);
            boolean it2 = false;
            d = Double.parseDouble(string2);
        } else {
            d = 0.0;
        }
        double branchLength = d;
        SimpleNode result = new SimpleNode(name, branchLength);
        if (Intrinsics.areEqual((Object)nameBranchLength, (Object)newick2) ^ true) {
            int parenthesisCount = 0;
            StringBuilder currentStr = new StringBuilder();
            CharSequence $this$forEach$iv = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)newick2, (char)'(', null, (int)2, null), (char)')', null, (int)2, null);
            boolean $i$f$forEach = false;
            CharSequence charSequence2 = $this$forEach$iv;
            block7: for (int i = 0; i < charSequence2.length(); ++i) {
                char element$iv;
                char it3 = element$iv = charSequence2.charAt(i);
                boolean bl4 = false;
                switch (it3) {
                    case '(': {
                        int n = parenthesisCount;
                        parenthesisCount = n + 1;
                        currentStr.append(it3);
                        continue block7;
                    }
                    case ')': {
                        int n = parenthesisCount;
                        parenthesisCount = n + -1;
                        currentStr.append(it3);
                        continue block7;
                    }
                    case ',': {
                        if (parenthesisCount == 0) {
                            String string3 = currentStr.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"currentStr.toString()");
                            result.addChild(NewickUtils.makeNode(string3));
                            currentStr = new StringBuilder();
                            continue block7;
                        }
                        currentStr.append(it3);
                        continue block7;
                    }
                    default: {
                        currentStr.append(it3);
                    }
                }
            }
            charSequence = currentStr;
            boolean bl5 = false;
            if (charSequence.length() > 0) {
                String string4 = currentStr.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"currentStr.toString()");
                result.addChild(NewickUtils.makeNode(string4));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(@NotNull String filename, @NotNull Tree tree, boolean includeBranchLengths) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        try {
            Object object = new File(filename);
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileOutputStream((File)object3);
            bl3 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            boolean bl4 = false;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl5 = false;
                Node node = tree.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
                NewickUtils.write(node, writer, includeBranchLengths);
                Writer writer2 = writer.append(";\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw (Throwable)new IllegalStateException("NewickUtils: write: problem writing: " + filename + ".\n" + e.getMessage());
        }
    }

    public static /* synthetic */ void write$default(String string, Tree tree, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        NewickUtils.write(string, tree, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void write(Node node, BufferedWriter writer, boolean includeBranchLengths) {
        Object object;
        int n;
        if (!node.isLeaf()) {
            writer.append("(");
            int n2 = 0;
            n = node.getChildCount();
            while (n2 < n) {
                void i;
                if (i != false) {
                    writer.append(",");
                }
                Node node2 = node.getChild((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
                NewickUtils.write(node2, writer, includeBranchLengths);
                ++i;
            }
            writer.append(")");
        }
        if ((object = node.getIdentifier()) != null && (object = ((Taxon)object).getName()) != null) {
            Object i = object;
            n = 0;
            boolean bl = false;
            Object it = i;
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl3 = false;
            if (charSequence.length() > 0) {
                String name = StringsKt.replace$default((String)it, (char)' ', (char)'_', (boolean)false, (int)4, null);
                writer.append("'");
                writer.append(name);
                writer.append("'");
            }
        }
        if (includeBranchLengths && node.getBranchLength() != 0.0) {
            writer.append(":");
            String string = "%.7f";
            Object[] objectArray = new Object[]{node.getBranchLength()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            String lengthStr = string2;
            String string3 = StringUtils.stripEnd((String)lengthStr, (String)"0");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtils.stripEnd(lengthStr, \"0\")");
            lengthStr = string3;
            String string4 = StringUtils.stripEnd((String)lengthStr, (String)".");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtils.stripEnd(lengthStr, \".\")");
            lengthStr = string4;
            writer.append(lengthStr);
        }
    }

    @NotNull
    public static final Tree mergeTrees(@NotNull List<? extends Tree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        if (trees.size() < 2) {
            throw (Throwable)new IllegalArgumentException("NewickUtils: mergeTrees: must supply at least 2 trees.");
        }
        HashMap nameToNode = new HashMap();
        IdentityHashMap nodeToNode = new IdentityHashMap();
        Node rootNode = null;
        Iterable $this$forEach$iv = trees;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree tree = (Tree)element$iv;
            boolean bl = false;
            List<Node> nodes = NewickUtils.nodes(tree);
            Iterable $this$forEach$iv2 = nodes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String parentName;
                Node node = (Node)element$iv2;
                boolean bl2 = false;
                Taxon taxon = node.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)taxon, (String)"node.identifier");
                String nodeName = taxon.getName();
                Node existingNode = (Node)nameToNode.get(nodeName);
                Node existingParentNode = (Node)nodeToNode.get(node.getParent());
                Object object = existingParentNode;
                String existingParentName = object != null && (object = object.getIdentifier()) != null ? ((Taxon)object).getName() : null;
                Object object2 = node.getParent();
                String string = object2 != null && (object2 = object2.getIdentifier()) != null ? ((Taxon)object2).getName() : (parentName = null);
                if (nodeToNode.isEmpty()) {
                    rootNode = new SimpleNode(nodeName, node.getBranchLength());
                    ((Map)nodeToNode).put(node, rootNode);
                    String string2 = nodeName;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nodeName");
                    CharSequence charSequence = string2;
                    boolean bl3 = false;
                    if (!(charSequence.length() > 0)) continue;
                    ((Map)nameToNode).put(nodeName, rootNode);
                    continue;
                }
                if (existingNode != null) {
                    if (existingParentName != null && parentName != null && Intrinsics.areEqual((Object)existingParentName, (Object)parentName) ^ true) {
                        throw (Throwable)new IllegalArgumentException("NewickUtils: mergeTrees: node: " + nodeName + " has different parents (" + parentName + ", " + existingParentName + ") in different trees.");
                    }
                    if (existingNode.getBranchLength() != node.getBranchLength()) {
                        myLogger.warn((Object)("mergeTrees: nodes named: " + nodeName + " in different trees have different branch lengths."));
                    }
                    ((Map)nodeToNode).put(node, existingNode);
                    continue;
                }
                if (existingParentNode == null) {
                    Node node2;
                    if (nameToNode.get(MERGE_ROOT_NODE) != null) {
                        Object v = nameToNode.get(MERGE_ROOT_NODE);
                        Intrinsics.checkNotNull(v);
                        node2 = (Node)v;
                    } else {
                        SimpleNode temp = new SimpleNode("", 0.0);
                        ((Map)nameToNode).put(MERGE_ROOT_NODE, temp);
                        node2 = temp;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"if (nameToNode[MERGE_ROO\u2026   temp\n                }");
                    Node mergeRoot = node2;
                    Node node3 = rootNode;
                    if (node3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"rootNode");
                    }
                    if (Intrinsics.areEqual((Object)node3, (Object)mergeRoot) ^ true) {
                        mergeRoot.addChild(rootNode);
                    }
                    SimpleNode newChild = new SimpleNode(nodeName, node.getBranchLength());
                    ((Map)nodeToNode).put(node, newChild);
                    String string3 = nodeName;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nodeName");
                    CharSequence charSequence = string3;
                    boolean bl4 = false;
                    if (charSequence.length() > 0) {
                        ((Map)nameToNode).put(nodeName, newChild);
                    }
                    mergeRoot.addChild(newChild);
                    rootNode = mergeRoot;
                    continue;
                }
                SimpleNode newChild = new SimpleNode(nodeName, node.getBranchLength());
                ((Map)nodeToNode).put(node, newChild);
                String string4 = nodeName;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"nodeName");
                CharSequence charSequence = string4;
                boolean bl5 = false;
                if (charSequence.length() > 0) {
                    ((Map)nameToNode).put(nodeName, newChild);
                }
                existingParentNode.addChild(newChild);
            }
        }
        Node node = rootNode;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootNode");
        }
        return new SimpleTree(node);
    }

    @NotNull
    public static final List<Node> nodes(@NotNull Tree $this$nodes) {
        Intrinsics.checkNotNullParameter((Object)$this$nodes, (String)"$this$nodes");
        boolean bl = false;
        List result = new ArrayList();
        Node node = $this$nodes.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"this.root");
        result.add(node);
        Node node2 = $this$nodes.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"this.root");
        NewickUtils.addChildren(result, node2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addChildren(List<Node> nodes, Node node) {
        int n = 0;
        int n2 = node.getChildCount();
        while (n < n2) {
            void i;
            Node node2 = node.getChild((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            nodes.add(node2);
            Node node3 = node.getChild((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"node.getChild(i)");
            NewickUtils.addChildren(nodes, node3);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Tree subsetTree(@NotNull Tree tree, @NotNull TaxaList taxaList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)taxaList, (String)"taxaList");
        Iterable $this$map$iv = taxaList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Taxon taxon = (Taxon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            String string = v0.getName();
            collection.add(string);
        }
        List nameList = (List)destination$iv$iv;
        return NewickUtils.subsetTree(tree, nameList);
    }

    @NotNull
    public static final Tree subsetTree(@NotNull Tree tree, @NotNull List<String> namesToKeep) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter(namesToKeep, (String)"namesToKeep");
        Node node = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
        return new SimpleTree(NewickUtils.keepNode(node, namesToKeep));
    }

    /*
     * WARNING - void declaration
     */
    private static final Node keepNode(Node node, List<String> namesToKeep) {
        if (node.isLeaf()) {
            Object object = node.getIdentifier();
            if (object != null && (object = ((Taxon)object).getName()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it2 = object2;
                boolean bl3 = false;
                if (namesToKeep.contains(it2)) {
                    Taxon taxon = node.getIdentifier();
                    return new SimpleNode(taxon != null ? taxon.getName() : null, node.getBranchLength());
                }
            }
        } else {
            Node it;
            int n = 0;
            List childNodesToKeep = new ArrayList();
            n = 0;
            int n2 = node.getChildCount();
            while (n < n2) {
                void i;
                Node node2 = node.getChild((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
                if (NewickUtils.keepNode(node2, namesToKeep) != null) {
                    Node it2;
                    boolean bl = false;
                    boolean bl4 = false;
                    it = it2;
                    boolean bl5 = false;
                    childNodesToKeep.add(it);
                }
                ++i;
            }
            switch (childNodesToKeep.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    Node node3 = (Node)childNodesToKeep.get(0);
                    node3.setBranchLength(node3.getBranchLength() + node.getBranchLength());
                    return (Node)childNodesToKeep.get(0);
                }
            }
            Taxon taxon = node.getIdentifier();
            SimpleNode parent = new SimpleNode(taxon != null ? taxon.getName() : null, node.getBranchLength());
            Iterable $this$forEach$iv = childNodesToKeep;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Node)element$iv;
                boolean bl = false;
                parent.addChild(it);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    public static final Tree removeBranchLengths(@NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Node node = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
        return new SimpleTree(NewickUtils.removeBranchLengths(node));
    }

    /*
     * WARNING - void declaration
     */
    private static final Node removeBranchLengths(Node node) {
        Taxon taxon = node.getIdentifier();
        SimpleNode result = new SimpleNode(taxon != null ? taxon.getName() : null, 0.0);
        int n = 0;
        int n2 = node.getChildCount();
        while (n < n2) {
            void i;
            Node node2 = node.getChild((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            result.addChild(NewickUtils.removeBranchLengths(node2));
            ++i;
        }
        return result;
    }

    @NotNull
    public static final Tree convertNames(@NotNull Tree tree, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        boolean bl = false;
        Map conversions = new LinkedHashMap();
        File file = new File(filename);
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl2 = false;
        Object object = file;
        boolean bl3 = false;
        Object object2 = object;
        boolean bl4 = false;
        object2 = new FileInputStream((File)object2);
        bl4 = false;
        object = new InputStreamReader((InputStream)object2, charset);
        bl3 = false;
        (object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)).lines().forEach(new Consumer<String>(filename, conversions){
            final /* synthetic */ String $filename;
            final /* synthetic */ Map $conversions;

            public final void accept(String it) {
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                List temp = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\t"}, (boolean)false, (int)0, (int)6, null);
                if (temp.size() != 2) {
                    throw (Throwable)new IllegalArgumentException("NewickUtils: convertNames: each line of file: " + this.$filename + " should have two names separated by a tab.\nOffending line: " + it);
                }
                String string2 = (String)temp.get(0);
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = (String)temp.get(1);
                bl = false;
                String string4 = string2;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                this.$conversions.put(StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (char)'_', (char)' ', (boolean)false, (int)4, null), StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (char)'_', (char)' ', (boolean)false, (int)4, null));
            }
            {
                this.$filename = string;
                this.$conversions = map;
            }
        });
        Node node = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
        return new SimpleTree(NewickUtils.convertNames(node, conversions));
    }

    /*
     * WARNING - void declaration
     */
    private static final Node convertNames(Node node, Map<String, String> conversions) {
        Map<String, String> map = conversions;
        Taxon taxon = node.getIdentifier();
        String string = taxon != null ? taxon.getName() : null;
        int n = 0;
        String string2 = map.get(string);
        if (string2 == null) {
            Taxon taxon2 = node.getIdentifier();
            string2 = taxon2 != null ? taxon2.getName() : null;
        }
        String name = string2;
        SimpleNode result = new SimpleNode(name, 0.0);
        int n2 = 0;
        n = node.getChildCount();
        while (n2 < n) {
            void i;
            Node node2 = node.getChild((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            result.addChild(NewickUtils.convertNames(node2, conversions));
            ++i;
        }
        return result;
    }
}

