/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.tree.SplitUtils;

public class SplitSystem {
    private int labelCount;
    private int splitCount;
    private TaxaList idGroup;
    private boolean[][] splits;

    public SplitSystem(TaxaList idGroup, int size) {
        this.idGroup = idGroup;
        this.labelCount = idGroup.numberOfTaxa();
        this.splitCount = size;
        this.splits = new boolean[this.splitCount][this.labelCount];
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public boolean[][] getSplitVector() {
        return this.splits;
    }

    public boolean[] getSplit(int i) {
        return this.splits[i];
    }

    public TaxaList getIdGroup() {
        return this.idGroup;
    }

    public boolean hasSplit(boolean[] split) {
        for (int i = 0; i < this.splitCount; ++i) {
            if (!SplitUtils.isSame(split, this.splits[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (i = 0; i < this.labelCount; ++i) {
            pw.println(this.idGroup.get(i));
        }
        pw.println();
        for (i = 0; i < this.splitCount; ++i) {
            for (int j = 0; j < this.labelCount; ++j) {
                if (this.splits[i][j]) {
                    pw.print('*');
                    continue;
                }
                pw.print('.');
            }
            pw.println();
        }
        return sw.toString();
    }
}

