/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import net.maizegenetics.stats.math.MersenneTwisterFast;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeUtils;
import net.maizegenetics.taxa.tree.SplitSystem;
import net.maizegenetics.taxa.tree.SplitUtils;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.util.FormattedOutput;

public class TreeUtils {
    private static MersenneTwisterFast random = new MersenneTwisterFast();
    private static Node[] path;
    private static FormattedOutput format;
    private static double proportion;
    private static int minLength;
    private static boolean[] umbrella;
    private static int[] position;
    private static int numExternalNodes;
    private static int numInternalNodes;
    private static int numBranches;

    public static double getRobinsonFouldsDistance(Tree t1, Tree t2) {
        SplitSystem s1 = SplitUtils.getSplits(t1);
        return TreeUtils.getRobinsonFouldsDistance(s1, t2);
    }

    public static double getRobinsonFouldsDistance(SplitSystem s1, Tree t2) {
        TaxaList idGroup = s1.getIdGroup();
        SplitSystem s2 = SplitUtils.getSplits(idGroup, t2);
        if (s1.getLabelCount() != s2.getLabelCount()) {
            throw new IllegalArgumentException("Number of labels must be the same!");
        }
        int ns1 = s1.getSplitCount();
        int ns2 = s2.getSplitCount();
        int fn = 0;
        for (int i = 0; i < ns1; ++i) {
            if (s2.hasSplit(s1.getSplit(i))) continue;
            ++fn;
        }
        int fp = 0;
        for (int i = 0; i < ns2; ++i) {
            if (s1.hasSplit(s2.getSplit(i))) continue;
            ++fp;
        }
        return 0.5 * ((double)fp + (double)fn);
    }

    public static double getRobinsonFouldsRescaledDistance(Tree t1, Tree t2) {
        SplitSystem s1 = SplitUtils.getSplits(t1);
        return TreeUtils.getRobinsonFouldsRescaledDistance(s1, t2);
    }

    public static double getRobinsonFouldsRescaledDistance(SplitSystem s1, Tree t2) {
        return TreeUtils.getRobinsonFouldsDistance(s1, t2) / (double)s1.getSplitCount();
    }

    public static Node getRandomNode(Tree tree) {
        int index = random.nextInt(tree.getExternalNodeCount() + tree.getInternalNodeCount());
        if (index >= tree.getExternalNodeCount()) {
            return tree.getInternalNode(index - tree.getExternalNodeCount());
        }
        return tree.getExternalNode(index);
    }

    public static final Node getNodeByName(Tree tree, String name) {
        return TreeUtils.getNodeByName(tree.getRoot(), name);
    }

    public static final Node getNodeByName(Node root, String name) {
        if (root.getIdentifier().getName().equals(name)) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            Node result = TreeUtils.getNodeByName(root.getChild(i), name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void rotateByLeafCount(Tree tree) {
        TreeUtils.rotateByLeafCount(tree.getRoot());
    }

    public static final TaxaList getLeafIdGroup(Tree tree) {
        tree.createNodeList();
        TaxaListBuilder labelList = new TaxaListBuilder();
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            labelList.add(tree.getExternalNode(i).getIdentifier());
        }
        return labelList.build();
    }

    public static void printNH(Tree tree, PrintWriter out) throws IOException {
        TreeUtils.printNH(tree, out, true, true);
    }

    public static void printNH(Tree tree, PrintWriter out, boolean printLengths, boolean printInternalLabels) throws IOException {
        NodeUtils.printNH(out, tree.getRoot(), printLengths, printInternalLabels);
        out.println(";");
    }

    public static void reroot(Tree tree, Node node) {
        TreeUtils.reroot(node);
        tree.setRoot(node);
    }

    public static Node findMidpointNode(Tree tree) {
        Node midNode = null;
        double maxAvgDist = -1.0;
        for (int i = 0; i < tree.getInternalNodeCount(); ++i) {
            Node iNode = tree.getInternalNode(i);
            double[] d = NodeUtils.getPathLengthInfo(iNode);
            double avg = (d[0] + d[1]) / 2.0;
            if (!(maxAvgDist < avg)) continue;
            maxAvgDist = avg;
            midNode = iNode;
        }
        return midNode;
    }

    public static void computeAllDistances(Tree tree, int a, double[] dist, double[] idist, boolean countEdges, double epsilon) {
        tree.createNodeList();
        dist[a] = 0.0;
        Node node = tree.getExternalNode(a);
        TreeUtils.computeNodeDist(node, node.getParent(), dist, idist, countEdges, epsilon);
    }

    private static void computeNodeDist(Node origin, Node center, double[] dist, double[] idist, boolean countEdges, double epsilon) {
        int indexCenter = center.getNumber();
        int indexOrigin = origin.getNumber();
        double[] distCenter = center.isLeaf() ? dist : idist;
        double[] distOrigin = origin.isLeaf() ? dist : idist;
        double tmp = origin.getParent() == center ? origin.getBranchLength() : center.getBranchLength();
        double len = countEdges ? (tmp < epsilon ? 0.0 : 1.0) : tmp;
        distCenter[indexCenter] = distOrigin[indexOrigin] + len;
        if (!center.isLeaf()) {
            Node p;
            for (int i = 0; i < center.getChildCount(); ++i) {
                Node c = center.getChild(i);
                if (c == origin) continue;
                TreeUtils.computeNodeDist(center, c, dist, idist, countEdges, epsilon);
            }
            if (!center.isRoot() && (p = center.getParent()) != origin) {
                TreeUtils.computeNodeDist(center, p, dist, idist, countEdges, epsilon);
            }
        }
    }

    public static final double computeDistance(Tree tree, int a, int b) {
        tree.createNodeList();
        int maxLen = tree.getInternalNodeCount() + 1;
        if (path == null || path.length < maxLen) {
            path = new Node[maxLen];
        }
        int len = TreeUtils.findPath(tree, a, b);
        double dist = 0.0;
        for (int i = 0; i < len; ++i) {
            dist += path[i].getBranchLength();
        }
        return dist;
    }

    private static final int findPath(Tree tree, int a, int b) {
        for (int i = 0; i < path.length; ++i) {
            TreeUtils.path[i] = null;
        }
        Node node = tree.getExternalNode(a);
        int len = 0;
        TreeUtils.path[len] = node;
        ++len;
        while (!node.isRoot()) {
            TreeUtils.path[len] = node = node.getParent();
            ++len;
        }
        Node stopNode = null;
        node = tree.getExternalNode(b);
        while (!node.isRoot()) {
            int pos = TreeUtils.findInPath(node = node.getParent());
            if (pos == -1) continue;
            len = pos;
            stopNode = node;
            break;
        }
        TreeUtils.path[len] = node = tree.getExternalNode(b);
        ++len;
        for (node = node.getParent(); node != stopNode; node = node.getParent()) {
            TreeUtils.path[len] = node;
            ++len;
        }
        for (int i = len; i < path.length; ++i) {
            TreeUtils.path[i] = null;
        }
        return len;
    }

    private static final int findInPath(Node node) {
        for (int i = 0; i < path.length; ++i) {
            if (path[i] == node) {
                return i;
            }
            if (path[i] != null) continue;
            return -1;
        }
        return -1;
    }

    private static void rotateByLeafCount(Node node) {
        if (!node.isLeaf()) {
            if (NodeUtils.getLeafCount(node.getChild(0)) > NodeUtils.getLeafCount(node.getChild(1))) {
                Node temp = node.getChild(0);
                node.removeChild(0);
                node.addChild(temp);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeUtils.rotateByLeafCount(node.getChild(i));
            }
        }
    }

    public static void report(Tree tree, Writer out) throws IOException {
        TreeUtils.printASCII(tree, out);
        out.write("\n");
        TreeUtils.branchInfo(tree, out);
        out.write("\n");
        TreeUtils.heightInfo(tree, out);
    }

    private static void printASCII(Tree tree, Writer out) throws IOException {
        format = FormattedOutput.getInstance();
        tree.createNodeList();
        numExternalNodes = tree.getExternalNodeCount();
        numInternalNodes = tree.getInternalNodeCount();
        numBranches = numInternalNodes + numExternalNodes - 1;
        umbrella = new boolean[numExternalNodes];
        position = new int[numExternalNodes];
        minLength = Integer.toString(numBranches).length() + 1;
        int MAXCOLUMN = 40;
        Node root = tree.getRoot();
        if (root.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(root);
        }
        proportion = (double)MAXCOLUMN / root.getNodeHeight();
        for (int n = 0; n < numExternalNodes; ++n) {
            TreeUtils.umbrella[n] = false;
        }
        TreeUtils.position[0] = 1;
        for (int i = root.getChildCount() - 1; i > -1; --i) {
            TreeUtils.printNodeInASCII(out, root.getChild(i), 1, i, root.getChildCount());
            if (i == 0) continue;
            TreeUtils.putCharAtLevel(out, 0, '|');
            out.write("\n");
        }
    }

    private static void branchInfo(Tree tree, Writer out) throws IOException {
        int i;
        boolean showSE = false;
        for (i = 0; i < numExternalNodes && !showSE; ++i) {
            if (tree.getExternalNode(i).getBranchLengthSE() != 0.0) {
                showSE = true;
            }
            if (i >= numInternalNodes - 1 || tree.getInternalNode(i).getBranchLengthSE() == 0.0) continue;
            showSE = true;
        }
        format.displayIntegerWhite(out, numExternalNodes);
        out.write("   Length    ");
        if (showSE) {
            out.write("S.E.      ");
        }
        out.write("Label     ");
        if (numInternalNodes > 1) {
            format.displayIntegerWhite(out, numBranches);
            out.write("        Length    ");
            if (showSE) {
                out.write("S.E.      ");
            }
            out.write("Label");
        }
        out.write("\n");
        for (i = 0; i < numExternalNodes; ++i) {
            format.displayInteger(out, i + 1, numExternalNodes);
            out.write("   ");
            format.displayDecimal(out, tree.getExternalNode(i).getBranchLength(), 5);
            out.write("   ");
            if (showSE) {
                format.displayDecimal(out, tree.getExternalNode(i).getBranchLengthSE(), 5);
                out.write("   ");
            }
            format.displayLabel(out, tree.getExternalNode(i).getIdentifier().getName(), 10);
            if (i < numInternalNodes - 1) {
                format.multiplePrint(out, ' ', 5);
                format.displayInteger(out, i + 1 + numExternalNodes, numBranches);
                out.write("   ");
                format.displayDecimal(out, tree.getInternalNode(i).getBranchLength(), 5);
                out.write("   ");
                if (showSE) {
                    format.displayDecimal(out, tree.getInternalNode(i).getBranchLengthSE(), 5);
                    out.write("   ");
                }
                format.displayLabel(out, tree.getInternalNode(i).getIdentifier().getName(), 10);
            }
            out.write("\n");
        }
    }

    private static void heightInfo(Tree tree, Writer out) throws IOException {
        if (tree.getRoot().getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(tree.getRoot());
        }
        format.displayIntegerWhite(out, numExternalNodes);
        out.write("   Height    ");
        format.displayIntegerWhite(out, numBranches);
        out.write("        Height    ");
        out.write("\n");
        for (int i = 0; i < numExternalNodes; ++i) {
            format.displayInteger(out, i + 1, numExternalNodes);
            out.write("   ");
            format.displayDecimal(out, tree.getExternalNode(i).getNodeHeight(), 7);
            out.write("   ");
            if (i < numInternalNodes) {
                format.multiplePrint(out, ' ', 5);
                if (i == numInternalNodes - 1) {
                    out.write("R");
                    format.multiplePrint(out, ' ', Integer.toString(numBranches).length() - 1);
                } else {
                    format.displayInteger(out, i + 1 + numExternalNodes, numBranches);
                }
                out.write("   ");
                format.displayDecimal(out, tree.getInternalNode(i).getNodeHeight(), 7);
                out.write("   ");
            }
            out.write("\n");
        }
    }

    private static void printNodeInASCII(Writer out, Node node, int level, int m, int maxm) throws IOException {
        TreeUtils.position[level] = (int)(node.getBranchLength() * proportion);
        if (position[level] < minLength) {
            TreeUtils.position[level] = minLength;
        }
        if (node.isLeaf()) {
            if (m == maxm - 1) {
                TreeUtils.umbrella[level - 1] = true;
            }
            TreeUtils.printlnNodeWithNumberAndLabel(out, node, level);
            if (m == 0) {
                TreeUtils.umbrella[level - 1] = false;
            }
        } else {
            for (int n = node.getChildCount() - 1; n > -1; --n) {
                TreeUtils.printNodeInASCII(out, node.getChild(n), level + 1, n, node.getChildCount());
                if (m == maxm - 1 && n == node.getChildCount() / 2) {
                    TreeUtils.umbrella[level - 1] = true;
                }
                if (n != 0) {
                    if (n == node.getChildCount() / 2) {
                        TreeUtils.printlnNodeWithNumberAndLabel(out, node, level);
                    } else {
                        for (int i = 0; i < level + 1; ++i) {
                            if (umbrella[i]) {
                                TreeUtils.putCharAtLevel(out, i, '|');
                                continue;
                            }
                            TreeUtils.putCharAtLevel(out, i, ' ');
                        }
                        out.write("\n");
                    }
                }
                if (m != 0 || n != node.getChildCount() / 2) continue;
                TreeUtils.umbrella[level - 1] = false;
            }
        }
    }

    private static void printlnNodeWithNumberAndLabel(Writer out, Node node, int level) throws IOException {
        for (int i = 0; i < level - 1; ++i) {
            if (umbrella[i]) {
                TreeUtils.putCharAtLevel(out, i, '|');
                continue;
            }
            TreeUtils.putCharAtLevel(out, i, ' ');
        }
        TreeUtils.putCharAtLevel(out, level - 1, '+');
        int branchNumber = node.isLeaf() ? node.getNumber() + 1 : node.getNumber() + 1 + numExternalNodes;
        String numberAsString = Integer.toString(branchNumber);
        int numDashs = position[level] - numberAsString.length();
        for (int i = 0; i < numDashs; ++i) {
            out.write(45);
        }
        out.write(numberAsString);
        if (node.isLeaf()) {
            out.write(" " + node.getIdentifier() + "\n");
        } else {
            if (!node.getIdentifier().equals(Taxon.ANONYMOUS)) {
                out.write("(" + node.getIdentifier() + ")");
            }
            out.write("\n");
        }
    }

    private static void putCharAtLevel(Writer out, int level, char c) throws IOException {
        int n = position[level] - 1;
        for (int i = 0; i < n; ++i) {
            out.write(32);
        }
        out.write(c);
    }

    private static void reroot(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            return;
        }
        if (!node.getParent().isRoot()) {
            TreeUtils.reroot(node.getParent());
        }
        if (node.getParent().getChildCount() < 3) {
            return;
        }
        NodeUtils.exchangeInfo(node.getParent(), node);
        Node parent = node.getParent();
        NodeUtils.removeChild(parent, node);
        node.addChild(parent);
    }
}

