/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeFactory;
import net.maizegenetics.taxa.tree.NodeUtils;
import net.maizegenetics.taxa.tree.SimpleTree;

public class UPGMATree
extends SimpleTree {
    private int numClusters;
    private int besti;
    private int abi;
    private int bestj;
    private int abj;
    private int[] alias;
    private double[][] distance;
    private double[] height;
    private int[] oc;

    public UPGMATree(DistanceMatrix m) {
        if (m.getSize() < 2) {
            new IllegalArgumentException("LESS THAN 2 TAXA IN DISTANCE MATRIX");
        }
        if (!m.isSymmetric()) {
            new IllegalArgumentException("UNSYMMETRIC DISTANCE MATRIX");
        }
        this.init(m);
        while (true) {
            this.findNextPair();
            this.newBranchLengths();
            if (this.numClusters == 2) break;
            this.newCluster();
        }
        this.finish();
        this.createNodeList();
    }

    private double getDist(int a, int b) {
        return this.distance[this.alias[a]][this.alias[b]];
    }

    private void init(DistanceMatrix m) {
        int i;
        this.numClusters = m.getSize();
        this.distance = m.getClonedDistances();
        for (i = 0; i < this.numClusters; ++i) {
            Node tmp = NodeFactory.createNode();
            tmp.setIdentifier(m.getTaxon(i));
            this.getRoot().addChild(tmp);
        }
        this.alias = new int[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            this.alias[i] = i;
        }
        this.height = new double[this.numClusters];
        this.oc = new int[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            this.height[i] = 0.0;
            this.oc[i] = 1;
        }
    }

    private void finish() {
        this.distance = null;
    }

    private void findNextPair() {
        this.besti = 0;
        this.bestj = 1;
        double dmin = this.getDist(0, 1);
        for (int i = 0; i < this.numClusters - 1; ++i) {
            for (int j = i + 1; j < this.numClusters; ++j) {
                if (!(this.getDist(i, j) < dmin)) continue;
                dmin = this.getDist(i, j);
                this.besti = i;
                this.bestj = j;
            }
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    private void newBranchLengths() {
        double dij = this.getDist(this.besti, this.bestj);
        this.getRoot().getChild(this.besti).setBranchLength(dij / 2.0 - this.height[this.abi]);
        this.getRoot().getChild(this.bestj).setBranchLength(dij / 2.0 - this.height[this.abj]);
    }

    private void newCluster() {
        for (int k = 0; k < this.numClusters; ++k) {
            if (k == this.besti || k == this.bestj) continue;
            int ak = this.alias[k];
            double d = this.updatedDistance(this.besti, this.bestj, k);
            this.distance[this.abi][ak] = d;
            this.distance[ak][this.abi] = d;
        }
        this.distance[this.abi][this.abi] = 0.0;
        this.height[this.abi] = this.getDist(this.besti, this.bestj) / 2.0;
        int n = this.abi;
        this.oc[n] = this.oc[n] + this.oc[this.abj];
        NodeUtils.joinChilds(this.getRoot(), this.besti, this.bestj);
        for (int i = this.bestj; i < this.numClusters - 1; ++i) {
            this.alias[i] = this.alias[i + 1];
        }
        --this.numClusters;
    }

    private double updatedDistance(int i, int j, int k) {
        int ai = this.alias[i];
        int aj = this.alias[j];
        double ocsum = this.oc[ai] + this.oc[aj];
        return (double)this.oc[ai] / ocsum * this.getDist(k, i) + (double)this.oc[aj] / ocsum * this.getDist(k, j);
    }
}

