/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.maizegenetics.util.Graph;
import net.maizegenetics.util.Tuple;

public class DirectedGraph<T>
implements Graph<T> {
    private final HashSet<T> nodes;
    private final ImmutableSetMultimap<T, T> adj;
    private final ImmutableSetMultimap<T, T> pred;
    private final HashMap<Tuple<T, T>, Double> wts;

    public DirectedGraph(HashSet<T> nodes, ImmutableSetMultimap<T, T> adj, ImmutableSetMultimap<T, T> pred, HashMap<Tuple<T, T>, Double> wts) {
        this.nodes = nodes;
        this.adj = adj;
        this.wts = wts;
        this.pred = pred;
    }

    @Override
    public Iterator<T> nodesIter() {
        return this.nodes.iterator();
    }

    @Override
    public Collection<T> nodes() {
        return this.nodes;
    }

    @Override
    public int numberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public boolean hasNode(T n) {
        return this.nodes.contains(n);
    }

    @Override
    public boolean hasEdge(T u, T v) {
        return this.adj.containsEntry(u, v);
    }

    @Override
    public Collection<T> neighbors(T n) {
        return this.adj.get(n);
    }

    public Collection<T> successors(T n) {
        return this.adj.get(n);
    }

    public Collection<T> predecessors(T n) {
        return this.pred.get(n);
    }

    @Override
    public Collection<Map.Entry<T, T>> edges() {
        return this.adj.entries();
    }

    @Override
    public Iterator<Map.Entry<T, T>> edgesIter() {
        return this.adj.entries().iterator();
    }

    @Override
    public int degree(T n) {
        return this.inDegree(n) + this.outDegree(n);
    }

    public int inDegree(T n) {
        return this.pred.get(n).size();
    }

    public int outDegree(T n) {
        return this.adj.get(n).size();
    }

    @Override
    public int size() {
        return this.adj.size();
    }

    @Override
    public double size(boolean weighted) {
        if (weighted) {
            double total_size = 0.0;
            Iterator<Double> it = this.wts.values().iterator();
            while (it.hasNext()) {
                total_size += it.next().doubleValue();
            }
            return total_size;
        }
        return this.size();
    }
}

