/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.util.GeneralAnnotation;

public class GeneralAnnotationStorage
implements GeneralAnnotation {
    public static final GeneralAnnotationStorage EMPTY_ANNOTATION_STORAGE = new GeneralAnnotationStorage();
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int MAX_CACHE_SIZE = 1000000;
    private static final Map<Map.Entry<String, String>, Map.Entry<String, String>> CACHE = Collections.synchronizedMap(new LinkedHashMap<Map.Entry<String, String>, Map.Entry<String, String>>(1500000){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Map.Entry<String, String>, Map.Entry<String, String>> eldest) {
            return this.size() > 1000000;
        }
    });
    private final Map.Entry<String, String>[] myAnnotations;

    private static Map.Entry<String, String> getCanonicalAnnotation(String key, String value) {
        AbstractMap.SimpleImmutableEntry<String, String> temp = new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
        Map.Entry entry = CACHE.putIfAbsent(temp, temp);
        return entry == null ? temp : entry;
    }

    private GeneralAnnotationStorage(Builder builder) {
        this.myAnnotations = new Map.Entry[builder.myAnnotations.size()];
        for (int i = 0; i < builder.myAnnotations.size(); ++i) {
            this.myAnnotations[i] = (Map.Entry)builder.myAnnotations.get(i);
        }
    }

    private GeneralAnnotationStorage() {
        this.myAnnotations = new Map.Entry[0];
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Override
    public String[] getTextAnnotation(String annoName) {
        ArrayList<String> result = new ArrayList<String>(1);
        for (Map.Entry<String, String> me : this.myAnnotations) {
            if (!me.getKey().equals(annoName)) continue;
            result.add(me.getValue());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Map<String, String> getConcatenatedTextAnnotations() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> me : this.myAnnotations) {
            String value = (String)result.get(me.getKey());
            if (value == null) {
                result.put(me.getKey(), me.getValue());
                continue;
            }
            result.put(me.getKey(), value + "," + me.getValue());
        }
        return result;
    }

    @Override
    public double[] getQuantAnnotation(String annoName) {
        try {
            ArrayList<Double> result = new ArrayList<Double>(1);
            for (Map.Entry<String, String> me : this.myAnnotations) {
                if (!me.getKey().equals(annoName)) continue;
                result.add(Double.parseDouble(me.getValue()));
            }
            if (result.isEmpty()) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] d = new double[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                d[i] = (Double)result.get(i);
            }
            return d;
        }
        catch (Exception e) {
            return EMPTY_DOUBLE_ARRAY;
        }
    }

    @Override
    public double getAverageAnnotation(String annoName) {
        double[] values = this.getQuantAnnotation(annoName);
        if (values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return values[0];
        }
        double result = 0.0;
        for (double current : values) {
            result += current;
        }
        return result / (double)values.length;
    }

    @Override
    public boolean isAnnotatedWithValue(String annoName, String annoValue) {
        for (Map.Entry<String, String> me : this.myAnnotations) {
            if (!me.getKey().equals(annoName) || !me.getValue().equals(annoValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map.Entry<String, String>[] getAllAnnotationEntries() {
        return Arrays.copyOf(this.myAnnotations, this.myAnnotations.length);
    }

    @Override
    public Set<String> getAnnotationKeys() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> me : this.myAnnotations) {
            result.add(me.getKey());
        }
        return result;
    }

    @Override
    public SetMultimap<String, String> getAnnotationAsMap() {
        ImmutableSetMultimap.Builder result = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (Map.Entry<String, String> en : this.myAnnotations) {
            result.put((Object)en.getKey(), (Object)en.getValue());
        }
        return result.build();
    }

    @Override
    public int numAnnotations() {
        return this.myAnnotations.length;
    }

    public static class Builder {
        private final List<Map.Entry<String, String>> myAnnotations = new ArrayList<Map.Entry<String, String>>(0);

        private Builder() {
        }

        public Builder addAnnotation(String key, String value) {
            this.myAnnotations.add(GeneralAnnotationStorage.getCanonicalAnnotation(key, value));
            return this;
        }

        public Builder addAnnotation(String key, Number value) {
            this.myAnnotations.add(GeneralAnnotationStorage.getCanonicalAnnotation(key, value.toString()));
            return this;
        }

        public Builder addAnnotations(GeneralAnnotation existing) {
            if (existing == null) {
                return this;
            }
            this.myAnnotations.addAll(Arrays.asList(existing.getAllAnnotationEntries()));
            return this;
        }

        public GeneralAnnotationStorage build() {
            if (this.myAnnotations.isEmpty()) {
                return EMPTY_ANNOTATION_STORAGE;
            }
            Collections.sort(this.myAnnotations, (s1, s2) -> {
                int keyComp = ((String)s1.getKey()).compareTo((String)s2.getKey());
                if (keyComp != 0) {
                    return keyComp;
                }
                return ((String)s1.getValue()).compareTo((String)s2.getValue());
            });
            return new GeneralAnnotationStorage(this);
        }
    }
}

