/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.maizegenetics.util.DirectedGraph;
import net.maizegenetics.util.Graph;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.UndirectedGraph;

public class GraphBuilder<T> {
    private final HashSet<T> nodes;
    private final ImmutableSetMultimap.Builder<T, T> adj;
    private final HashMap<Tuple<T, T>, Double> wts;
    private final Graph.GraphType type;

    public GraphBuilder(Graph.GraphType type) {
        this.type = type;
        this.nodes = new HashSet();
        this.adj = new ImmutableSetMultimap.Builder();
        this.wts = new HashMap();
    }

    public Graph build() {
        if (this.type == Graph.GraphType.UNDIRECTED) {
            return new UndirectedGraph<T>(this.nodes, this.adj.build(), this.wts);
        }
        ImmutableSetMultimap successors = this.adj.build();
        ImmutableSetMultimap.Builder pred = new ImmutableSetMultimap.Builder();
        for (Map.Entry item : successors.entries()) {
            pred.put(item.getValue(), item.getKey());
        }
        return new DirectedGraph<T>(this.nodes, successors, pred.build(), this.wts);
    }

    public GraphBuilder addNode(T n) {
        this.nodes.add(n);
        return this;
    }

    public GraphBuilder addEdge(T u, T v) {
        return this.addEdge(u, v, 1.0);
    }

    public GraphBuilder addEdge(T u, T v, double wt) {
        if (!this.nodes.contains(u)) {
            this.nodes.add(u);
        }
        if (!this.nodes.contains(v)) {
            this.nodes.add(v);
        }
        this.adj.put(u, v);
        this.wts.put(new Tuple<T, T>(u, v), wt);
        if (this.type == Graph.GraphType.UNDIRECTED) {
            this.adj.put(v, u);
            this.wts.put(new Tuple<T, T>(v, u), wt);
        }
        return this;
    }
}

