/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.File;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMTPClient {
    private MimeMessage message;

    public SMTPClient(String host, String[] toAddresses) {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", host);
        Session session = Session.getDefaultInstance((Properties)properties);
        this.message = new MimeMessage(session);
        for (int i = 0; i < toAddresses.length; ++i) {
            try {
                this.message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddresses[i]));
                this.message.setFrom((Address)new InternetAddress(toAddresses[0]));
                continue;
            }
            catch (AddressException ae) {
                ae.printStackTrace();
                continue;
            }
            catch (MessagingException me) {
                me.printStackTrace();
            }
        }
    }

    public void sendMessageWithAttachment(String subject, String msg, String fileAttachment) throws MessagingException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(msg);
        this.message.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        File aFileAttachment = new File(fileAttachment);
        if (aFileAttachment.canRead()) {
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(fileAttachment);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(aFileAttachment.getName());
            multipart.addBodyPart((BodyPart)messageBodyPart);
        } else {
            messageBodyPart.setText(msg + "\n\nCould not attach file:\n" + fileAttachment);
        }
        this.message.setContent((Multipart)multipart);
        Transport.send((Message)this.message);
    }

    public void sendMessage(String subject, String msg) throws MessagingException {
        this.message.setSubject(subject);
        this.message.setText(msg);
        Transport.send((Message)this.message);
    }
}

