/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixMultiple;
import net.maizegenetics.util.SuperByteMatrixSingle;
import net.maizegenetics.util.SuperByteMatrixSingleValue;
import net.maizegenetics.util.SuperByteMatrixTranspose;

public class SuperByteMatrixBuilder {
    private static final int TRANSPOSE_BLOCK_SIZE = 64;

    private SuperByteMatrixBuilder() {
    }

    public static SuperByteMatrix getInstance(int numRows, int numColumns) {
        long numElements = (long)numRows * (long)numColumns;
        if (numElements > 0x7FFFFFF5L) {
            return new SuperByteMatrixMultiple(numRows, numColumns);
        }
        return new SuperByteMatrixSingle(numRows, numColumns);
    }

    public static SuperByteMatrix getInstanceSingleValue(int numRows, int numColumns, byte value) {
        return new SuperByteMatrixSingleValue(numRows, numColumns, value);
    }

    public static SuperByteMatrix getInstanceCopy(SuperByteMatrix matrix) {
        int numRows = matrix.getNumRows();
        int numColumns = matrix.getNumColumns();
        if (matrix instanceof SuperByteMatrixSingle || matrix instanceof SuperByteMatrixMultiple) {
            SuperByteMatrix result = SuperByteMatrixBuilder.getInstance(numRows, numColumns);
            for (int r = 0; r < numRows; ++r) {
                for (int c = 0; c < numColumns; ++c) {
                    result.set(r, c, matrix.get(r, c));
                }
            }
            return result;
        }
        if (matrix instanceof SuperByteMatrixTranspose) {
            SuperByteMatrix result = SuperByteMatrixBuilder.getInstanceTranspose(numRows, numColumns);
            for (int c = 0; c < numColumns; ++c) {
                for (int r = 0; r < numRows; ++r) {
                    result.set(r, c, matrix.get(r, c));
                }
            }
            return result;
        }
        throw new IllegalArgumentException("SuperByteMatrixBuilder: getInstanceCopy: Don't Know how to Copy: " + matrix.getClass().getName());
    }

    public static SuperByteMatrix getInstanceTranspose(int numRows, int numColumns) {
        return new SuperByteMatrixTranspose(numRows, numColumns);
    }

    public static SuperByteMatrix getInstanceTranspose(SuperByteMatrix matrix) {
        SuperByteMatrix result;
        int numRows = matrix.getNumRows();
        int numColumns = matrix.getNumColumns();
        int numThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numThreads);
        if (matrix instanceof SuperByteMatrixSingle || matrix instanceof SuperByteMatrixMultiple) {
            result = SuperByteMatrixBuilder.getInstanceTranspose(numRows, numColumns);
            int rowBlockSize = 64;
            for (int rowOffset = 0; rowOffset < numRows; rowOffset += 64) {
                if (numRows - rowOffset < 64) {
                    rowBlockSize = numRows - rowOffset;
                }
                pool.execute(new TransposeColumnToRowProcess(matrix, result, numColumns, rowBlockSize, rowOffset));
            }
            try {
                pool.shutdown();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("SuperByteMatrixBuilder: getInstanceTranspose: processing threads timed out.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (matrix instanceof SuperByteMatrixTranspose) {
            result = SuperByteMatrixBuilder.getInstance(numRows, numColumns);
            int columnBlockSize = 64;
            for (int columnOffset = 0; columnOffset < numColumns; columnOffset += 64) {
                if (numColumns - columnOffset < 64) {
                    columnBlockSize = numColumns - columnOffset;
                }
                pool.execute(new TransposeRowToColumnProcess(matrix, result, numRows, columnBlockSize, columnOffset));
            }
            try {
                pool.shutdown();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("SuperByteMatrixBuilder: getInstanceTranspose: processing threads timed out.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("SuperByteMatrixBuilder: getInstanceTranspose: Don't Know how to Transpose: " + matrix.getClass().getName());
        }
        return result;
    }

    private static class TransposeColumnToRowProcess
    implements Runnable {
        private final int myRowBlockSize;
        private final int myRowOffset;
        private final SuperByteMatrix mySourceMatrix;
        private final SuperByteMatrix myDestMatrix;
        private final int myNumColumns;

        public TransposeColumnToRowProcess(SuperByteMatrix srcMatrix, SuperByteMatrix destMatrix, int numColumns, int rowBlockSize, int rowOffset) {
            this.myRowBlockSize = rowBlockSize;
            this.myRowOffset = rowOffset;
            this.mySourceMatrix = srcMatrix;
            this.myDestMatrix = destMatrix;
            this.myNumColumns = numColumns;
        }

        @Override
        public void run() {
            byte[][] temp = new byte[this.myRowBlockSize][64];
            int columnBlockSize = 64;
            for (int columnOffset = 0; columnOffset < this.myNumColumns; columnOffset += 64) {
                if (this.myNumColumns - columnOffset < 64) {
                    columnBlockSize = this.myNumColumns - columnOffset;
                }
                for (int r = 0; r < this.myRowBlockSize; ++r) {
                    for (int c = 0; c < columnBlockSize; ++c) {
                        temp[r][c] = this.mySourceMatrix.get(r + this.myRowOffset, c + columnOffset);
                    }
                }
                for (int c = 0; c < columnBlockSize; ++c) {
                    for (int r = 0; r < this.myRowBlockSize; ++r) {
                        this.myDestMatrix.set(r + this.myRowOffset, c + columnOffset, temp[r][c]);
                    }
                }
            }
        }
    }

    private static class TransposeRowToColumnProcess
    implements Runnable {
        private final int myColumnBlockSize;
        private final int myColumnOffset;
        private final SuperByteMatrix mySourceMatrix;
        private final SuperByteMatrix myDestMatrix;
        private final int myNumRows;

        public TransposeRowToColumnProcess(SuperByteMatrix srcMatrix, SuperByteMatrix destMatrix, int numRows, int columnBlockSize, int columnOffset) {
            this.myColumnBlockSize = columnBlockSize;
            this.myColumnOffset = columnOffset;
            this.mySourceMatrix = srcMatrix;
            this.myDestMatrix = destMatrix;
            this.myNumRows = numRows;
        }

        @Override
        public void run() {
            byte[][] temp = new byte[64][this.myColumnBlockSize];
            int rowBlockSize = 64;
            for (int rowOffset = 0; rowOffset < this.myNumRows; rowOffset += 64) {
                if (this.myNumRows - rowOffset < 64) {
                    rowBlockSize = this.myNumRows - rowOffset;
                }
                for (int c = 0; c < this.myColumnBlockSize; ++c) {
                    for (int r = 0; r < rowBlockSize; ++r) {
                        temp[r][c] = this.mySourceMatrix.get(r + rowOffset, c + this.myColumnOffset);
                    }
                }
                for (int r = 0; r < rowBlockSize; ++r) {
                    for (int c = 0; c < this.myColumnBlockSize; ++c) {
                        this.myDestMatrix.set(r + rowOffset, c + this.myColumnOffset, temp[r][c]);
                    }
                }
            }
        }
    }
}

