/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.util.SuperByteMatrix;

public class SuperByteMatrixMultiple
implements SuperByteMatrix {
    private final byte[][] myData;
    private final int myNumRows;
    private final int myNumColumns;
    private final int myNumRowsPerSingleDimArray;
    private final long myNumElements;
    private final int myNumElementsPerSingleDimArray;

    SuperByteMatrixMultiple(int rows, int columns) {
        this.myNumRows = rows;
        this.myNumColumns = columns;
        this.myNumElements = (long)this.myNumRows * (long)this.myNumColumns;
        this.myNumRowsPerSingleDimArray = Integer.MAX_VALUE / this.myNumColumns;
        this.myNumElementsPerSingleDimArray = this.myNumRowsPerSingleDimArray * this.myNumColumns;
        int numSingleDimArrays = (int)(this.myNumElements / (long)this.myNumElementsPerSingleDimArray);
        int numRemaining = (int)(this.myNumElements % (long)this.myNumElementsPerSingleDimArray);
        if (numRemaining != 0) {
            this.myData = new byte[numSingleDimArrays + 1][];
            for (int i = 0; i < numSingleDimArrays; ++i) {
                this.myData[i] = new byte[this.myNumElementsPerSingleDimArray];
            }
            this.myData[numSingleDimArrays] = new byte[numRemaining];
        } else {
            this.myData = new byte[numSingleDimArrays][];
            for (int i = 0; i < numSingleDimArrays; ++i) {
                this.myData[i] = new byte[this.myNumElementsPerSingleDimArray];
            }
        }
    }

    @Override
    public void set(int row, int column, byte value) {
        this.myData[this.getFirstIndex((int)row)][this.getSecondIndex((int)row, (int)column)] = value;
    }

    @Override
    public void setAll(byte value) {
        int numSingleDimArrays = this.myData.length;
        for (int i = 0; i < numSingleDimArrays; ++i) {
            Arrays.fill(this.myData[i], value);
        }
    }

    @Override
    public byte get(int row, int column) {
        return this.myData[this.getFirstIndex(row)][this.getSecondIndex(row, column)];
    }

    @Override
    public byte[] getAllColumns(int row) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixMultiple: getAllColumns: row: " + row);
        }
        int start = this.getSecondIndex(row, 0);
        byte[] result = new byte[this.myNumColumns];
        System.arraycopy(this.myData[this.getFirstIndex(row)], start, result, 0, this.myNumColumns);
        return result;
    }

    @Override
    public byte[] getColumnRange(int row, int start, int end) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixMultiple: getColumnRange: row: " + row);
        }
        if (start < 0 || start >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixMultiple: getColumnRange: start: " + start);
        }
        if (end < 0 || end >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixMultiple: getColumnRange: end: " + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("SuperByteMatrixMultiple: getColumnRange: end: " + end + " less than start: " + start);
        }
        int startIndex = this.getSecondIndex(row, start);
        int numElements = end - start;
        byte[] result = new byte[numElements];
        System.arraycopy(this.myData[this.getFirstIndex(row)], startIndex, result, 0, numElements);
        return result;
    }

    @Override
    public byte[] getAllRows(int column) {
        if (column < 0 || column >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixMultiple: getAllRows: column: " + column);
        }
        byte[] result = new byte[this.myNumRows];
        for (int row = 0; row < this.myNumRows; ++row) {
            result[row] = this.get(row, column);
        }
        return result;
    }

    private int getFirstIndex(int row) {
        return row / this.myNumRowsPerSingleDimArray;
    }

    private int getSecondIndex(int row, int column) {
        return row % this.myNumRowsPerSingleDimArray * this.myNumColumns + column;
    }

    @Override
    public int getNumRows() {
        return this.myNumRows;
    }

    @Override
    public int getNumColumns() {
        return this.myNumColumns;
    }

    @Override
    public boolean isColumnInnerLoop() {
        return true;
    }

    @Override
    public void reorderRows(int[] newIndices) {
        if (newIndices.length != this.myNumRows) {
            throw new IllegalArgumentException("SuperByteMatrixMultiple: reorderRows: index array size: " + newIndices.length + " doesn't equal num rows in matrix: " + this.myNumRows);
        }
        int[] tempIndices = new int[newIndices.length];
        System.arraycopy(newIndices, 0, tempIndices, 0, this.myNumRows);
        int currentRow = 0;
        byte[] temp = new byte[this.myNumColumns];
        while (currentRow < this.myNumRows) {
            while (currentRow < this.myNumRows && (tempIndices[currentRow] == currentRow || tempIndices[currentRow] == -1)) {
                tempIndices[currentRow] = -1;
                ++currentRow;
            }
            if (currentRow >= this.myNumRows) continue;
            System.arraycopy(this.myData[this.getFirstIndex(currentRow)], this.getSecondIndex(currentRow, 0), temp, 0, this.myNumColumns);
            int srcRow = tempIndices[currentRow];
            int destRow = currentRow;
            while (srcRow != currentRow) {
                System.arraycopy(this.myData[this.getFirstIndex(srcRow)], this.getSecondIndex(srcRow, 0), this.myData[this.getFirstIndex(destRow)], this.getSecondIndex(destRow, 0), this.myNumColumns);
                tempIndices[destRow] = -1;
                destRow = srcRow;
                srcRow = tempIndices[destRow];
            }
            System.arraycopy(temp, 0, this.myData[this.getFirstIndex(destRow)], this.getSecondIndex(destRow, 0), this.myNumColumns);
            tempIndices[destRow] = -1;
        }
    }

    @Override
    public void reorderColumns(int[] newIndices) {
        if (newIndices.length != this.myNumColumns) {
            throw new IllegalArgumentException("SuperByteMatrixMultiple: reorderColumns: index array size: " + newIndices.length + " doesn't equal num columns in matrix: " + this.myNumColumns);
        }
        int[] tempIndices = new int[newIndices.length];
        System.arraycopy(newIndices, 0, tempIndices, 0, this.myNumColumns);
        int currentRow = 0;
        byte[] temp = new byte[this.myNumRows];
        while (currentRow < this.myNumColumns) {
            int r;
            while (currentRow < this.myNumColumns && (tempIndices[currentRow] == currentRow || tempIndices[currentRow] == -1)) {
                tempIndices[currentRow] = -1;
                ++currentRow;
            }
            if (currentRow >= this.myNumColumns) continue;
            for (int r2 = 0; r2 < this.myNumRows; ++r2) {
                temp[r2] = this.get(r2, currentRow);
            }
            int srcColumn = tempIndices[currentRow];
            int destColumn = currentRow;
            while (srcColumn != currentRow) {
                for (r = 0; r < this.myNumRows; ++r) {
                    this.set(r, destColumn, this.get(r, srcColumn));
                }
                tempIndices[destColumn] = -1;
                destColumn = srcColumn;
                srcColumn = tempIndices[destColumn];
            }
            for (r = 0; r < this.myNumRows; ++r) {
                this.set(r, destColumn, temp[r]);
            }
            tempIndices[destColumn] = -1;
        }
    }

    @Override
    public void setHetsTo(byte value) {
        for (byte[] current : this.myData) {
            for (int i = 0; i < current.length; ++i) {
                if ((current[i] >>> 4 & 0xF) == (current[i] & 0xF)) continue;
                current[i] = value;
            }
        }
    }

    @Override
    public void arraycopy(int row, byte[] src, int startColumn) {
        System.arraycopy(src, 0, this.myData[this.getFirstIndex(row)], this.getSecondIndex(row, startColumn), src.length);
    }

    @Override
    public Stream<Byte> stream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Stream<Byte> stream(int row) {
        long start = (long)row * (long)this.myNumColumns;
        return StreamSupport.stream(new SuperByteMatrixMultipleSpliterator(start, start + (long)this.myNumColumns), true);
    }

    public Spliterator<Byte> spliterator() {
        return new SuperByteMatrixMultipleSpliterator(0L, this.myNumElements);
    }

    class SuperByteMatrixMultipleSpliterator<T extends Byte>
    implements Spliterator<Byte> {
        private long myCurrentIndex;
        private final long myFence;

        SuperByteMatrixMultipleSpliterator(long currentIndex, long fence) {
            this.myCurrentIndex = currentIndex;
            this.myFence = fence;
        }

        private int firstIndex(long index) {
            return (int)(index / (long)SuperByteMatrixMultiple.this.myNumElementsPerSingleDimArray);
        }

        private int secondIndex(long index) {
            return (int)(index % (long)SuperByteMatrixMultiple.this.myNumElementsPerSingleDimArray);
        }

        @Override
        public void forEachRemaining(Consumer<? super Byte> action) {
            int firstIndex = this.firstIndex(this.myCurrentIndex);
            int secondIndex = this.secondIndex(this.myCurrentIndex);
            int fenceFirst = this.firstIndex(this.myFence);
            int fenceSecond = this.secondIndex(this.myFence);
            if (firstIndex == fenceFirst) {
                for (int i = secondIndex; i < fenceSecond; ++i) {
                    action.accept((Byte)SuperByteMatrixMultiple.this.myData[firstIndex][i]);
                }
            } else {
                int i;
                for (i = secondIndex; i < SuperByteMatrixMultiple.this.myNumElementsPerSingleDimArray; ++i) {
                    action.accept((Byte)SuperByteMatrixMultiple.this.myData[firstIndex][i]);
                }
                for (i = firstIndex + 1; i < fenceFirst; ++i) {
                    for (int j = 0; j < SuperByteMatrixMultiple.this.myNumElementsPerSingleDimArray; ++j) {
                        action.accept((Byte)SuperByteMatrixMultiple.this.myData[i][j]);
                    }
                }
                for (i = 0; i < fenceSecond; ++i) {
                    action.accept((Byte)SuperByteMatrixMultiple.this.myData[fenceFirst][i]);
                }
            }
            this.myCurrentIndex = this.myFence;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Byte> action) {
            if (this.myCurrentIndex < this.myFence) {
                action.accept((Byte)SuperByteMatrixMultiple.this.myData[this.firstIndex(this.myCurrentIndex)][this.secondIndex(this.myCurrentIndex)]);
                ++this.myCurrentIndex;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Byte> trySplit() {
            long lo = this.myCurrentIndex;
            long mid = lo + this.myFence >>> 1;
            if (lo < mid) {
                this.myCurrentIndex = mid;
                return new SuperByteMatrixMultipleSpliterator<T>(lo, mid);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentIndex;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }
}

