/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.stream.Stream;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

public class SuperByteMatrixTranspose
implements SuperByteMatrix {
    private final SuperByteMatrix myMatrix;

    SuperByteMatrixTranspose(int rows, int columns) {
        this.myMatrix = SuperByteMatrixBuilder.getInstance(columns, rows);
    }

    @Override
    public int getNumRows() {
        return this.myMatrix.getNumColumns();
    }

    @Override
    public int getNumColumns() {
        return this.myMatrix.getNumRows();
    }

    @Override
    public void set(int row, int column, byte value) {
        this.myMatrix.set(column, row, value);
    }

    @Override
    public void setAll(byte value) {
        this.myMatrix.setAll(value);
    }

    @Override
    public byte get(int row, int column) {
        return this.myMatrix.get(column, row);
    }

    @Override
    public byte[] getAllColumns(int row) {
        return this.myMatrix.getAllRows(row);
    }

    @Override
    public byte[] getColumnRange(int row, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.get(row, i);
        }
        return result;
    }

    @Override
    public byte[] getAllRows(int column) {
        return this.myMatrix.getAllColumns(column);
    }

    @Override
    public boolean isColumnInnerLoop() {
        return false;
    }

    @Override
    public void reorderRows(int[] newIndices) {
        this.myMatrix.reorderColumns(newIndices);
    }

    @Override
    public void reorderColumns(int[] newIndices) {
        this.myMatrix.reorderRows(newIndices);
    }

    @Override
    public void setHetsTo(byte value) {
        this.myMatrix.setHetsTo(value);
    }

    @Override
    public void arraycopy(int row, byte[] src, int startColumn) {
        for (int i = 0; i < src.length; ++i) {
            this.set(row, startColumn + i, src[i]);
        }
    }

    @Override
    public Stream<Byte> stream() {
        return this.myMatrix.stream();
    }

    @Override
    public Stream<Byte> stream(int row) {
        return this.myMatrix.stream(row);
    }
}

