/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util.db;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.maizegenetics.util.db.DefaultDBTuple;
import net.maizegenetics.util.db.Pair;
import net.maizegenetics.util.db.TransformerService;

public interface DBTuple
extends Collection<Pair<String, ? extends Object>> {
    default public <T> Optional<T> val(String name) {
        return this.val(name, Object.class);
    }

    public <T> Optional<T> val(int var1);

    public <T> Optional<T> val(int var1, Class<T> var2);

    default public long asLong(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Long.class)).orElse(0L);
    }

    default public float asFloat(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Float.class)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public double asDouble(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Double.class)).orElse(0.0);
    }

    default public BigDecimal asBigDecimal(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, BigDecimal.class)).orElse(null);
    }

    default public short asShort(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Short.class)).orElse((short)0);
    }

    default public byte asByte(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Byte.class)).orElse((byte)0);
    }

    default public boolean asBoolean(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Boolean.class)).orElse(false);
    }

    default public char asChar(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Character.class)).orElse(Character.valueOf('\u0000')).charValue();
    }

    default public int asInt(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Integer.class)).orElse(0);
    }

    default public int asInt(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Integer.class)).orElse(0);
    }

    default public float asFloat(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Float.class)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public double asDouble(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Double.class)).orElse(0.0);
    }

    default public BigDecimal asBigDecimal(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, BigDecimal.class)).orElse(null);
    }

    default public long asLong(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Long.class)).orElse(0L);
    }

    default public short asShort(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Short.class)).orElse((short)0);
    }

    default public byte asByte(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Byte.class)).orElse((byte)0);
    }

    default public boolean asBoolean(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Boolean.class)).orElse(false);
    }

    default public char asChar(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Character.class)).orElse(Character.valueOf('\u0000')).charValue();
    }

    default public <T> Optional<T> val(String name, Class<T> type) {
        for (Pair stringPair : this) {
            if (!name.equalsIgnoreCase((String)stringPair.getCar())) continue;
            return Optional.ofNullable(TransformerService.convert(stringPair.getCdr(), type));
        }
        return Optional.empty();
    }

    default public DBTuple subTuple(String ... subset) {
        Collection result = this.stream().filter(pair -> {
            for (String s : subset) {
                if (!s.equals(pair.getCar())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        return this.createFrom(result);
    }

    default public DBTuple merge(DBTuple second) {
        ArrayList<Pair<String, ? extends Object>> mergedCollection = new ArrayList<Pair<String, ? extends Object>>(this);
        mergedCollection.addAll(this);
        second.forEach(item -> {
            if (!mergedCollection.contains(item)) {
                mergedCollection.add((Pair<String, ? extends Object>)item);
            }
        });
        return this.createFrom(mergedCollection);
    }

    default public DBTuple set(Pair<String, ?> ... columns) {
        DefaultDBTuple newTuple = new DefaultDBTuple(columns);
        return newTuple.merge(this);
    }

    default public DBTuple reduce(String suffix) {
        List<Pair<String, ?>> results = this.stream().filter(column -> ((String)column.getCar()).toLowerCase().startsWith(suffix.toLowerCase())).collect(Collectors.toList());
        return new DefaultDBTuple(results);
    }

    default public boolean hasVal(String name) {
        return this.val(name).isPresent();
    }

    public DBTuple createFrom(Collection<Pair<String, ? extends Object>> var1);
}

