/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util.db;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.db.DBTuple;
import net.maizegenetics.util.db.Pair;
import net.maizegenetics.util.db.TransformerService;

public class DefaultDBTuple
extends AbstractList<Pair<String, ? extends Object>>
implements DBTuple {
    Pair<String, ?>[] list;

    public DefaultDBTuple(Pair<String, ?> ... list) {
        this.list = list;
    }

    public DefaultDBTuple(Collection<Pair<String, ?>> values) {
        this.list = new Pair[values.size()];
        int cnt = 0;
        for (Pair<String, ?> value : values) {
            this.list[cnt++] = value;
        }
    }

    public static DBTuple tuple(Pair<String, ?> ... list) {
        return new DefaultDBTuple(list);
    }

    @Override
    public <T> Optional<T> val(String name) {
        return this.val(name, Object.class);
    }

    @Override
    public <T> Optional<T> val(int index) {
        assert (index > -1 && index < this.list.length);
        return this.val(index, Object.class);
    }

    @Override
    public <T> Optional<T> val(int index, Class<T> type) {
        assert (index > -1 && index < this.list.length);
        return Optional.ofNullable(this.list[index].getCdr());
    }

    @Override
    public long asLong(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Long.class)).orElse(0L);
    }

    @Override
    public float asFloat(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Float.class)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public double asDouble(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Double.class)).orElse(0.0);
    }

    @Override
    public BigDecimal asBigDecimal(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, BigDecimal.class)).orElse(null);
    }

    @Override
    public short asShort(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Short.class)).orElse((short)0);
    }

    @Override
    public byte asByte(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Byte.class)).orElse((byte)0);
    }

    @Override
    public boolean asBoolean(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Boolean.class)).orElse(false);
    }

    @Override
    public char asChar(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Character.class)).orElse(Character.valueOf('\u0000')).charValue();
    }

    @Override
    public int asInt(String name) {
        return this.val(name).map(val -> TransformerService.convert(val, Integer.class)).orElse(0);
    }

    @Override
    public int asInt(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Integer.class)).orElse(0);
    }

    @Override
    public float asFloat(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Float.class)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public double asDouble(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Double.class)).orElse(0.0);
    }

    @Override
    public BigDecimal asBigDecimal(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, BigDecimal.class)).orElse(null);
    }

    @Override
    public long asLong(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Long.class)).orElse(0L);
    }

    @Override
    public short asShort(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Short.class)).orElse((short)0);
    }

    @Override
    public byte asByte(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Byte.class)).orElse((byte)0);
    }

    @Override
    public boolean asBoolean(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Boolean.class)).orElse(false);
    }

    @Override
    public char asChar(int index) {
        return this.val(index).map(val -> TransformerService.convert(val, Character.class)).orElse(Character.valueOf('\u0000')).charValue();
    }

    @Override
    public <T> Optional<T> val(String name, Class<T> type) {
        for (Pair<String, ?> stringPair : this.list) {
            if (!name.equalsIgnoreCase(stringPair.getCar())) continue;
            return Optional.ofNullable(TransformerService.convert(stringPair.getCdr(), type));
        }
        return Optional.empty();
    }

    @Override
    public DBTuple createFrom(Collection<Pair<String, ? extends Object>> values) {
        return new DefaultDBTuple(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultDBTuple pairs = (DefaultDBTuple)o;
        return Arrays.equals(this.list, pairs.list);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.list != null ? Arrays.hashCode(this.list) : 0);
        return result;
    }

    @Override
    public Pair<String, Object> get(int index) {
        return this.list[index];
    }

    @Override
    public int size() {
        return this.list.length;
    }

    public static Pair<String, ?> tCons(String name, Object value) {
        return Pair.cons(name, value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        this.forEach(pair -> builder.append(pair.toString()).append(','));
        return builder.deleteCharAt(builder.length() - 1).append(')').toString();
    }
}

