/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import net.maizegenetics.util.db.DBTuple;
import net.maizegenetics.util.db.DataAccessException;
import net.maizegenetics.util.db.DefaultDBTuple;
import net.maizegenetics.util.db.LambdaTuplesContext;
import net.maizegenetics.util.db.Pair;
import net.maizegenetics.util.db.ResultSetIterator;
import net.maizegenetics.util.db.ResultSetProcessor;
import net.maizegenetics.util.db.SQLAction;

public class SQL {
    private static Map<Class<?>, Integer> MAPPINGS = new HashMap();
    private static Map<String, Pair<String, Integer>[]> META_DATA_CACHE = new HashMap<String, Pair<String, Integer>[]>();

    public static void select(Connection connection, String sql, ResultSetProcessor processor, Object ... params) {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int cnt = 0;
            for (Object param : params) {
                ps.setObject(++cnt, param);
            }
            try (ResultSet rs = ps.executeQuery();){
                long rowCnt = 0L;
                while (rs.next()) {
                    processor.process(rs, rowCnt++);
                }
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public static void execDDL(Connection connection, String sql) {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.execute();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int execDML(Connection connection, String sql, Object ... values) {
        System.out.println(sql);
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int cnt = 0;
            for (Object param : values) {
                ps.setObject(++cnt, param);
            }
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBTuple rowAsTuple(String sql, ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            Object[] columns = null;
            if (!META_DATA_CACHE.containsKey(sql)) {
                Map<String, Pair<String, Integer>[]> map = META_DATA_CACHE;
                synchronized (map) {
                    META_DATA_CACHE.put(sql, SQL.getColumns(metaData));
                }
            }
            columns = META_DATA_CACHE.get(sql);
            Collection result = StreamSupport.stream(Spliterators.spliterator(columns, 0), false).map(o -> {
                Pair column = (Pair)o;
                try {
                    return Pair.cons(column.getCar(), rs.getObject((String)column.getCar()));
                }
                catch (SQLException e) {
                    throw new DataAccessException(e);
                }
            }).collect(Collectors.toList());
            return new DefaultDBTuple(result);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private static Pair<String, Integer>[] getColumns(ResultSetMetaData rs) {
        int columnCount = 0;
        try {
            columnCount = rs.getColumnCount();
            Pair[] columns = new Pair[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                StringBuilder builder = new StringBuilder();
                builder.append(rs.getColumnName(i + 1));
                Integer type = rs.getColumnType(i + 1);
                columns[i] = Pair.cons(builder.toString(), type);
            }
            return columns;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T exec(SQLAction<T> action) {
        DataSource dataSource = LambdaTuplesContext.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException("Please set the datasource in " + LambdaTuplesContext.class.getName());
        }
        try (Connection connection = dataSource.getConnection();){
            T t = action.exec(connection);
            return t;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public static Stream<DBTuple> stream(Connection connection, String sql, Object ... parms) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ResultSetIterator(connection, sql), 0), false);
    }

    static {
        MAPPINGS.put(String.class, 12);
        MAPPINGS.put(Integer.class, 2);
    }
}

