/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util.db;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.util.db.Pair;
import net.maizegenetics.util.db.Transformations;
import net.maizegenetics.util.db.TypeTransformer;

public class TransformerService {
    static Map<Pair<Class<?>, Class<?>>, TypeTransformer<?, ?>> CONVERSION_REGISTRY;

    static Map<Pair<Class<?>, Class<?>>, TypeTransformer<?, ?>> getConversionRegistry() {
        if (CONVERSION_REGISTRY == null) {
            CONVERSION_REGISTRY = new HashMap();
        }
        return CONVERSION_REGISTRY;
    }

    public static <T, K> void registerConversion(Class<T> source, Class<K> target, TypeTransformer<T, K> transformer) {
        TransformerService.getConversionRegistry().put(Pair.cons(source, target), transformer);
    }

    static TypeTransformer resolveTransformer(final boolean isNull, final Class<?> source, final Class<?> target) {
        TypeTransformer<?, ?> typeTransformer = TransformerService.findWideningTransformer(source, target);
        if (typeTransformer == null) {
            return new TypeTransformer(){

                public Object transform(Object instance) {
                    if (target.isPrimitive()) {
                        try {
                            return target.getField("TYPE").get(null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (isNull) {
                        return null;
                    }
                    throw new IllegalArgumentException("No Type Transformer registered for " + source.getName() + "->" + target.getName());
                }
            };
        }
        return typeTransformer;
    }

    private static TypeTransformer<?, ?> findWideningTransformer(Class<?> source, Class<?> target) {
        TypeTransformer<?, ?> typeTransformer = TransformerService.getConversionRegistry().get(Pair.cons(source, target));
        if (typeTransformer != null) {
            return typeTransformer;
        }
        Pair transformerKey = TransformerService.getConversionRegistry().keySet().stream().filter(key -> {
            boolean sourceAssignable = ((Class)key.getCar()).isAssignableFrom(source);
            boolean targetAssignable = ((Class)key.getCdr()).isAssignableFrom(target);
            boolean fits = sourceAssignable && targetAssignable;
            return fits;
        }).findFirst().orElse(null);
        return TransformerService.getConversionRegistry().get(transformerKey);
    }

    public static <T> T convert(Object instance, Class<T> target) {
        boolean isNull;
        boolean bl = isNull = instance == null;
        if (!isNull && (target.equals(instance.getClass()) || target.isAssignableFrom(instance.getClass()))) {
            return (T)instance;
        }
        return (T)TransformerService.resolveTransformer(isNull, isNull ? null : instance.getClass(), target).transform(instance);
    }

    static {
        TransformerService.registerConversion(String.class, Long.class, Long::valueOf);
        TransformerService.registerConversion(String.class, Long.TYPE, Long::valueOf);
        TransformerService.registerConversion(String.class, Integer.class, Integer::valueOf);
        TransformerService.registerConversion(String.class, Integer.TYPE, Integer::valueOf);
        TransformerService.registerConversion(String.class, Byte.class, Byte::valueOf);
        TransformerService.registerConversion(String.class, Byte.TYPE, Byte::valueOf);
        TransformerService.registerConversion(String.class, Short.class, Short::valueOf);
        TransformerService.registerConversion(String.class, Short.TYPE, Short::valueOf);
        TransformerService.registerConversion(String.class, Boolean.class, Transformations::toBoolean);
        TransformerService.registerConversion(String.class, Boolean.TYPE, Transformations::toBoolean);
        TransformerService.registerConversion(String.class, Float.class, Float::valueOf);
        TransformerService.registerConversion(String.class, Float.TYPE, Float::valueOf);
        TransformerService.registerConversion(String.class, Double.class, Double::valueOf);
        TransformerService.registerConversion(String.class, Double.TYPE, Double::valueOf);
        TransformerService.registerConversion(String.class, Character.class, instance -> Character.valueOf(instance != null ? instance.charAt(0) : (char)'\u0000'));
        TransformerService.registerConversion(String.class, Character.TYPE, instance -> Character.valueOf(instance != null ? instance.charAt(0) : (char)'\u0000'));
        TransformerService.registerConversion(String.class, Double.TYPE, Double::valueOf);
        TransformerService.registerConversion(String.class, BigDecimal.class, BigDecimal::new);
        TransformerService.registerConversion(Number.class, Long.class, instance -> Transformations.toNumber(instance, Long.class));
        TransformerService.registerConversion(Number.class, Long.TYPE, instance -> Transformations.toNumber(instance, Long.class));
        TransformerService.registerConversion(Number.class, Integer.class, instance -> Transformations.toNumber(instance, Integer.class));
        TransformerService.registerConversion(Number.class, Integer.TYPE, instance -> Transformations.toNumber(instance, Integer.class));
        TransformerService.registerConversion(Number.class, Byte.class, instance -> Transformations.toNumber(instance, Byte.class));
        TransformerService.registerConversion(Number.class, Byte.TYPE, instance -> Transformations.toNumber(instance, Byte.class));
        TransformerService.registerConversion(Number.class, Short.class, instance -> Transformations.toNumber(instance, Short.class));
        TransformerService.registerConversion(Number.class, Short.TYPE, instance -> Transformations.toNumber(instance, Short.class));
        TransformerService.registerConversion(Number.class, Boolean.class, Transformations::toBoolean);
        TransformerService.registerConversion(Number.class, Boolean.TYPE, Transformations::toBoolean);
        TransformerService.registerConversion(Number.class, Float.class, instance -> Transformations.toNumber(instance, Float.class));
        TransformerService.registerConversion(Number.class, Float.TYPE, instance -> Transformations.toNumber(instance, Float.class));
        TransformerService.registerConversion(Number.class, Double.class, instance -> Transformations.toNumber(instance, Double.class));
        TransformerService.registerConversion(Number.class, Double.TYPE, instance -> Transformations.toNumber(instance, Double.class));
        TransformerService.registerConversion(Number.class, BigDecimal.class, Transformations::toBigDecimal);
        TransformerService.registerConversion(Object.class, String.class, Object::toString);
        TransformerService.registerConversion(Character.class, Boolean.class, Transformations::toBoolean);
        TransformerService.registerConversion(Number.class, Boolean.class, Transformations::toBoolean);
    }
}

