/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis;

import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016RB\u0010\u0007\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t \n*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/maizegenetics/analysis/ListPluginParameters;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "jarFiles", "Lnet/maizegenetics/plugindef/PluginParameter;", "", "kotlin.jvm.PlatformType", "classes", "", "", "jarFile", "getButtonName", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "value", "processData", "Lnet/maizegenetics/plugindef/DataSet;", "input", "Companion", "tassel"})
public final class ListPluginParameters
extends AbstractPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private PluginParameter<List<?>> jarFiles;

    public ListPluginParameters(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        this.jarFiles = new PluginParameter.Builder<List>("jarFiles", CollectionsKt.listOf((Object)"phg.jar"), List.class).description("List of jar files.").build();
        Logger.getLogger((String)"net.maizegenetics").setLevel(Level.OFF);
        Logger.getLogger((String)"net.maizegenetics.plugindef").setLevel(Level.INFO);
    }

    public /* synthetic */ ListPluginParameters(Frame frame, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(frame, bl);
    }

    @Override
    @Nullable
    public DataSet processData(@Nullable DataSet input) {
        List temp = new ArrayList();
        for (String current : this.jarFiles()) {
            Set<String> classes = this.classes(current);
            for (String current2 : classes) {
                if (!Plugin.isPlugin(current2)) continue;
                temp.add(current2);
            }
        }
        Plugin.PARAMETER_PROPERTIES[] pARAMETER_PROPERTIESArray = new Plugin.PARAMETER_PROPERTIES[]{Plugin.PARAMETER_PROPERTIES.Plugin, Plugin.PARAMETER_PROPERTIES.Parameter, Plugin.PARAMETER_PROPERTIES.Required, Plugin.PARAMETER_PROPERTIES.Default};
        TableReportBuilder result = TableReportBuilder.getInstance("PluginParameters", (Object[])pARAMETER_PROPERTIESArray);
        CollectionsKt.sort((List)temp);
        for (String current : temp) {
            String pluginName = Utils.getBasename(current);
            Plugin plugin = Plugin.getPluginInstance(current, null);
            if (plugin == null) continue;
            Map<String, Map<Plugin.PARAMETER_PROPERTIES, String>> currentPluginParameters = ((AbstractPlugin)plugin).usageParameters();
            for (String parameterName : currentPluginParameters.keySet()) {
                Map<Plugin.PARAMETER_PROPERTIES, String> parameterProperties;
                Intrinsics.checkNotNull(currentPluginParameters.get(parameterName));
                Object[] objectArray = new String[]{pluginName, parameterName, parameterProperties.get((Object)Plugin.PARAMETER_PROPERTIES.Required), parameterProperties.get((Object)Plugin.PARAMETER_PROPERTIES.Default)};
                result.add(objectArray);
            }
        }
        return DataSet.getDataSet(result.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Set<String> classes(String jarFile) {
        void $this$toTypedArray$iv;
        String classpath = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)classpath, (String)"classpath");
        Object object = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        string = new Regex(string);
        int n = 0;
        object = string.split((CharSequence)object, n);
        int $i$f$toTypedArray = 0;
        void thisCollection$iv222 = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv222.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] paths = stringArray;
        String tasselPath = null;
        $i$f$toTypedArray = 0;
        int thisCollection$iv222 = paths.length;
        while ($i$f$toTypedArray < thisCollection$iv222) {
            File file;
            String path = paths[$i$f$toTypedArray];
            ++$i$f$toTypedArray;
            String $this$trim$iv = path;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) || !(file = new File(path)).exists() || !StringsKt.endsWith$default((String)(tasselPath = file.getAbsolutePath()), (String)jarFile, (boolean)false, (int)2, null)) continue;
        }
        Set classes = new LinkedHashSet();
        try {
            Closeable thisCollection$iv222 = new ZipFile(tasselPath);
            Throwable throwable = null;
            try {
                ZipFile zFile = (ZipFile)thisCollection$iv222;
                boolean bl = false;
                Enumeration<? extends ZipEntry> entries = zFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                    String string3 = string2;
                    string2 = File.separator;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
                    String name = StringsKt.replace$default((String)string3, (String)string2, (String)".", (boolean)false, (int)4, null);
                    if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"$", (boolean)false, (int)2, null)) continue;
                    String string4 = name.substring(0, StringsKt.lastIndexOf$default((CharSequence)name, (String)".class", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    name = string4;
                    classes.add(name);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)thisCollection$iv222, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    @NotNull
    public final List<String> jarFiles() {
        List<String> list = this.jarFiles.value();
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        }
        return list;
    }

    @NotNull
    public final ListPluginParameters jarFiles(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.jarFiles = new PluginParameter<List<String>>((PluginParameter<List<String>>)this.jarFiles, value);
        return this;
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "List Plugins";
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "List Plugins";
    }

    public ListPluginParameters() {
        this(null, false, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final TableReport forPHG() {
        return Companion.forPHG();
    }

    @JvmStatic
    @NotNull
    public static final TableReport forTASSEL() {
        return Companion.forTASSEL();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lnet/maizegenetics/analysis/ListPluginParameters$Companion;", "", "()V", "forPHG", "Lnet/maizegenetics/util/TableReport;", "forTASSEL", "tassel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TableReport forPHG() {
            Object object = new ListPluginParameters(null, false, 3, null).performFunction(null).getData(0).getData();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.util.TableReport");
            }
            return (TableReport)object;
        }

        @JvmStatic
        @NotNull
        public final TableReport forTASSEL() {
            Object[] objectArray = new String[]{"sTASSEL.jar"};
            Object object = new ListPluginParameters(null, false, 3, null).jarFiles(CollectionsKt.arrayListOf((Object[])objectArray)).performFunction(null).getData(0).getData();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.util.TableReport");
            }
            return (TableReport)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

