/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SolveByOrthogonalizing;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;

public class EqtlAssociationPlugin
extends AbstractPlugin {
    private GenotypeTable.GENOTYPE_TABLE_COMPONENT[] GENOTYPE_COMP = new GenotypeTable.GENOTYPE_TABLE_COMPONENT[]{GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability, GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability};
    private Datum myDatum;
    private GenotypePhenotype myGenoPheno;
    private GenotypeTable myGenotype;
    private Phenotype myPhenotype;
    private TableReportBuilder myReportBuilder;
    private SolveByOrthogonalizing orthogonalSolver;
    private List<String> phenotypeNames;
    private double[] minR2;
    private FDistribution[] Fdist;
    private int numberOfObservations;
    private PluginParameter<Double> maxp = new PluginParameter.Builder<Double>("MaxPValue", 0.001, Double.class).guiName("MaxPValue").description("The maximum p-value that will be output by the analysis.").build();
    private PluginParameter<Boolean> addOnly = new PluginParameter.Builder<Boolean>("addOnly", false, Boolean.class).description("Should an additive only model be fit? If true, an additive model will be fit. If false, an additive + dominance model will be fit. Default = false.").guiName("Additive Only Model").build();
    private PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT> myGenotypeTable = new PluginParameter.Builder<GenotypeTable.GENOTYPE_TABLE_COMPONENT>("genotypeComponent", GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, GenotypeTable.GENOTYPE_TABLE_COMPONENT.class).genotypeTable().range((Comparable<T>[])this.GENOTYPE_COMP).description("If the genotype table contains more than one type of genotype data, choose the type to use for the analysis.").build();
    private PluginParameter<Boolean> saveAsFile = new PluginParameter.Builder<Boolean>("writeToFile", false, Boolean.class).description("Should the results be saved to a file rather than stored in memory? It true, the results will be written to a file as each SNP is analyzed in order to reduce memory requirementsand the results will NOT be saved to the data tree. Default = false.").guiName("Write to file").build();
    private PluginParameter<String> reportFilename = new PluginParameter.Builder<String>("outputFile", null, String.class).outFile().dependentOnParameter(this.saveAsFile).description("The name of the file to which these results will be saved.").guiName("Output File").build();

    public EqtlAssociationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        long start = System.currentTimeMillis();
        List<Datum> datumList = input.getDataOfType(GenotypePhenotype.class);
        if (datumList.size() != 1) {
            throw new IllegalArgumentException("Exactly one data set with genotypes and phenotypes must be selected.");
        }
        this.myDatum = datumList.get(0);
        this.myGenoPheno = (GenotypePhenotype)this.myDatum.getData();
        this.myGenotype = this.myGenoPheno.genotypeTable();
        this.myPhenotype = this.myGenoPheno.phenotype();
        this.numberOfObservations = this.myPhenotype.numberOfObservations();
        this.testMissingDataInTheBaseModel();
        this.initializeOutput();
        this.initializeOrthogonalizer();
        int nsites = this.myGenotype.numberOfSites();
        this.Fdist = new FDistribution[2];
        this.Fdist[0] = new FDistribution(1.0, (double)(this.numberOfObservations - 1 - this.orthogonalSolver.baseDf()));
        this.Fdist[1] = new FDistribution(2.0, (double)(this.numberOfObservations - 2 - this.orthogonalSolver.baseDf()));
        this.calculateR2Fromp();
        System.out.printf("starting site loop at %d.\n", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype) {
            if (this.addOnly.value().booleanValue()) {
                IntStream.range(0, nsites).mapToObj(s -> this.orthogonalSolver.solveForR((Position)this.myGenotype.positions().get(s), this.additiveSite(s))).forEach(this::updateOutputWithPvalues);
            } else {
                IntStream.range(0, nsites).mapToObj(s -> {
                    List<double[]> covars = this.additiveDominanceSite(s);
                    return this.orthogonalSolver.solveForR((Position)this.myGenotype.positions().get(s), covars.get(0), covars.get(1));
                }).forEach(this::updateOutputWithPvalues);
            }
        } else if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability) {
            for (int s2 = 0; s2 < nsites; ++s2) {
                SolveByOrthogonalizing.Marker markerTest = this.orthogonalSolver.solveForR((Position)this.myGenotype.positions().get(s2), this.referenceProbabilitiesForSite(s2));
                this.updateOutputWithPvalues(markerTest);
            }
        } else if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability) {
            throw new UnsupportedOperationException("Fast association analysis of allele probabilities is not supported.");
        }
        System.out.printf("site loop finished after %d ms\n", System.currentTimeMillis() - start);
        if (!this.saveAsFile.value().booleanValue()) {
            String name = "FastAssociation_" + this.myDatum.getName();
            String comment = "Fast association output";
            Datum outDatum = new Datum(name, this.myReportBuilder.build(), comment);
            return new DataSet(outDatum, (Plugin)this);
        }
        this.myReportBuilder.build();
        return null;
    }

    private void initializeOutput() {
        Object[] columnNames = new String[]{"Trait", "Marker", "Chr", "Pos", "df", "r2", "p"};
        String name = "EqtlReport_" + this.myDatum.getName();
        this.myReportBuilder = this.saveAsFile.value() != false ? TableReportBuilder.getInstance(name, columnNames, this.reportFilename.value()) : TableReportBuilder.getInstance(name, columnNames);
    }

    private void updateOutputWithPvalues(SolveByOrthogonalizing.Marker markerResult) {
        double[] rvalues = markerResult.vector1();
        int npheno = rvalues.length;
        Position pos = markerResult.position();
        if (markerResult.df > 0) {
            double minrsq = this.minR2[markerResult.df - 1];
            int errdf = this.numberOfObservations - this.orthogonalSolver.baseDf() - markerResult.df;
            IntStream.range(0, npheno).sequential().filter(i -> rvalues[i] >= minrsq).forEach(i -> this.addToReport(new Object[]{this.phenotypeNames.get(i), pos.getSNPID(), pos.getChromosome().getName(), pos.getPosition(), markerResult.degreesOfFreedom(), rvalues[i], this.pvalue(rvalues[i], markerResult.df, errdf)}));
        }
    }

    private double pvalue(double rvalue, int markerdf, int errordf) {
        double p;
        double F = rvalue / (1.0 - rvalue) * (double)errordf / (double)markerdf;
        try {
            p = LinearModelUtils.Ftest(F, markerdf, errordf);
        }
        catch (Exception e) {
            p = Double.NaN;
        }
        return p;
    }

    private void addToReport(Object[] row) {
        this.myReportBuilder.add(row);
    }

    private void initializeOrthogonalizer() {
        List<PhenotypeAttribute> phenotypeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        List<PhenotypeAttribute> covariateList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        List<PhenotypeAttribute> factorList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        ArrayList<ModelEffect> baseModel = new ArrayList<ModelEffect>();
        for (PhenotypeAttribute pa2 : factorList) {
            CategoricalAttribute ca = (CategoricalAttribute)pa2;
            baseModel.add(new FactorModelEffect(ca.allIntValues(), true, ca.name()));
        }
        for (PhenotypeAttribute pa2 : covariateList) {
            NumericAttribute na = (NumericAttribute)pa2;
            CovariateModelEffect cme = new CovariateModelEffect(AssociationUtils.convertFloatArrayToDouble(na.floatValues()), na.name());
            baseModel.add(cme);
        }
        List<double[]> dataList = phenotypeList.stream().map(pa -> (float[])pa.allValues()).map(a -> AssociationUtils.convertFloatArrayToDouble(a)).collect(Collectors.toList());
        this.phenotypeNames = phenotypeList.stream().map(PhenotypeAttribute::name).collect(Collectors.toList());
        this.orthogonalSolver = SolveByOrthogonalizing.getInstanceFromModel(baseModel, dataList);
    }

    private void testMissingDataInTheBaseModel() {
        for (PhenotypeAttribute attr : this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor)) {
            if (attr.missing().cardinality() <= 0L) continue;
            String msg = "There is missing data in the factor " + attr.name();
            throw new IllegalArgumentException(msg);
        }
        for (PhenotypeAttribute attr : this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate)) {
            if (attr.missing().cardinality() <= 0L) continue;
            String msg = "There is missing data in the covariate " + attr.name();
            throw new IllegalArgumentException(msg);
        }
        for (PhenotypeAttribute attr : this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data)) {
            if (attr.missing().cardinality() <= 0L) continue;
            String msg = "There is missing data in the phenotype " + attr.name();
            throw new IllegalArgumentException(msg);
        }
    }

    private double[] referenceProbabilitiesForSite(int site) {
        double[] probs = AssociationUtils.convertFloatArrayToDouble(this.myGenoPheno.referenceProb(site));
        return this.replaceNansWithMean(probs);
    }

    private double[] additiveSite(int site) {
        int nobs = this.myGenoPheno.phenotype().numberOfObservations();
        byte major = this.myGenotype.majorAllele(site);
        byte NN = -1;
        double[] code = IntStream.range(0, nobs).mapToDouble(t -> {
            byte geno = this.myGenoPheno.genotype(t, site);
            if (geno == NN) {
                return Double.NaN;
            }
            byte[] alleles = GenotypeTableUtils.getDiploidValues(geno);
            double val = 0.0;
            if (alleles[0] == major) {
                val += 0.5;
            }
            if (alleles[1] == major) {
                val += 0.5;
            }
            return val;
        }).toArray();
        return this.replaceNansWithMean(code);
    }

    private double[] replaceNansWithMean(double[] array) {
        int n = array.length;
        double sum = 0.0;
        double count = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(array[i])) continue;
            sum += array[i];
            count += 1.0;
        }
        double mean = sum / count;
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(array[i])) continue;
            array[i] = mean;
        }
        return array;
    }

    private List<double[]> additiveDominanceSite(int site) {
        int ntaxa = this.myGenoPheno.numberOfObservations();
        ArrayList<double[]> result = new ArrayList<double[]>();
        result.add(this.additiveSite(site));
        double[] dom = new double[ntaxa];
        for (int t = 0; t < ntaxa; ++t) {
            if (!this.myGenoPheno.isHeterozygous(t, site)) continue;
            dom[t] = 1.0;
        }
        result.add(dom);
        return result;
    }

    private void calculateR2Fromp() {
        double F;
        this.minR2 = new double[2];
        double p = 1.0 - this.maxp.value();
        int basedf = this.orthogonalSolver.baseDf();
        try {
            F = this.Fdist[0].inverseCumulativeProbability(p);
            this.minR2[0] = F / ((double)(this.numberOfObservations - 1 - basedf) + F);
        }
        catch (OutOfRangeException e) {
            e.printStackTrace();
            this.minR2[0] = Double.NaN;
        }
        try {
            F = this.Fdist[1].inverseCumulativeProbability(p);
            this.minR2[1] = 2.0 * F / ((double)(this.numberOfObservations - 2 - basedf) + 2.0 * F);
        }
        catch (OutOfRangeException e) {
            e.printStackTrace();
            this.minR2[1] = Double.NaN;
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = EqtlAssociationPlugin.class.getResource("/net/maizegenetics/analysis/images/speed.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Fast Association";
    }

    @Override
    public String getToolTipText() {
        return "Use a fixed effect linear model to test variants quickly.";
    }

    public TableReport runPlugin(DataSet input) {
        return (TableReport)this.performFunction(input).getData(0).getData();
    }

    public Double maxPValue() {
        return this.maxp.value();
    }

    public EqtlAssociationPlugin maxPValue(Double value) {
        this.maxp = new PluginParameter<Double>(this.maxp, value);
        return this;
    }

    public Boolean additiveOnlyModel() {
        return this.addOnly.value();
    }

    public EqtlAssociationPlugin additiveOnlyModel(Boolean value) {
        this.addOnly = new PluginParameter<Boolean>(this.addOnly, value);
        return this;
    }

    public GenotypeTable.GENOTYPE_TABLE_COMPONENT genotypeComponent() {
        return this.myGenotypeTable.value();
    }

    public EqtlAssociationPlugin genotypeComponent(GenotypeTable.GENOTYPE_TABLE_COMPONENT value) {
        this.myGenotypeTable = new PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT>(this.myGenotypeTable, value);
        return this;
    }

    public Boolean writeToFile() {
        return this.saveAsFile.value();
    }

    public EqtlAssociationPlugin writeToFile(Boolean value) {
        this.saveAsFile = new PluginParameter<Boolean>(this.saveAsFile, value);
        return this;
    }

    public String outputFile() {
        return this.reportFilename.value();
    }

    public EqtlAssociationPlugin outputFile(String value) {
        this.reportFilename = new PluginParameter<String>(this.reportFilename, value);
        return this;
    }

    @Override
    public String getCitation() {
        String citation = "Shabalin, AA. (2012) Matrix eQTL: ultra fast eQTL analysis via large matrix operations. Bioinformatics 28:1353-1358";
        return citation;
    }
}

