/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.RegRidgeEmmaDoubleMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class RidgeRegressionEmmaPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RidgeRegressionEmmaPlugin.class);

    public RidgeRegressionEmmaPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> datasets = input.getDataOfType(GenotypePhenotype.class);
            if (datasets.size() < 1) {
                String msg = "No datasets of an appropriate type were selected for the GS analysis.";
                myLogger.error((Object)msg);
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg, "GS Error", 0);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            LinkedList<Datum> results = new LinkedList<Datum>();
            for (Datum dataset : datasets) {
                try {
                    LinkedList<Datum> aResult = null;
                    aResult = this.processData(dataset);
                    if (aResult == null) continue;
                    results.addAll(aResult);
                    this.fireDataSetReturned(new DataSet(aResult, (Plugin)this));
                }
                catch (Exception e) {
                    StringBuilder msg = new StringBuilder("Error in GS processing " + dataset.getName());
                    msg.append(". ").append(e.getMessage());
                    myLogger.error((Object)msg.toString());
                    e.printStackTrace();
                    if (!this.isInteractive()) continue;
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg.toString(), "GS Error", 0);
                }
            }
            DataSet dataSet = new DataSet(results, (Plugin)this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public LinkedList<Datum> processData(Datum dataset) {
        LinkedList<Datum> theResults = new LinkedList<Datum>();
        GenotypePhenotype myGenoPheno = (GenotypePhenotype)dataset.getData();
        GenotypeTable myGenotype = myGenoPheno.genotypeTable();
        Phenotype myPhenotype = myGenoPheno.phenotype();
        if (!myGenotype.hasReferenceProbablity()) {
            throw new IllegalArgumentException("Incorrect data type. A numeric genotype was not found.");
        }
        int numberOfMarkers = myGenotype.numberOfSites();
        List<PhenotypeAttribute> dataAttributeList = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        List<PhenotypeAttribute> factorAttributeList = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        List<PhenotypeAttribute> covariateAttributeList = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        TaxaAttribute myTaxaAttribute = myPhenotype.taxaAttribute();
        for (PhenotypeAttribute attr : dataAttributeList) {
            DoubleMatrix fixedEffects;
            int numberOfCovariates;
            NumericAttribute dataAttribute = (NumericAttribute)attr;
            double[] phenotypeData = AssociationUtils.convertFloatArrayToDouble(dataAttribute.floatValues());
            int nObs = phenotypeData.length;
            DoubleMatrix phenotype = DoubleMatrixFactory.DEFAULT.make(nObs, 1, phenotypeData);
            int numberOfFactors = factorAttributeList.size();
            int numberOfEffects = numberOfFactors + (numberOfCovariates = covariateAttributeList.size()) + 1;
            if (numberOfEffects > 1) {
                int i;
                DoubleMatrix[][] effects = new DoubleMatrix[1][numberOfEffects];
                effects[0][0] = DoubleMatrixFactory.DEFAULT.make(nObs, 1, 1.0);
                for (i = 0; i < numberOfFactors; ++i) {
                    CategoricalAttribute fa = (CategoricalAttribute)factorAttributeList.get(i);
                    FactorModelEffect fme = new FactorModelEffect(fa.allIntValues(), true);
                    effects[0][i + 1] = fme.getX();
                }
                for (i = 0; i < numberOfCovariates; ++i) {
                    NumericAttribute na = (NumericAttribute)covariateAttributeList.get(i);
                    double[] values = AssociationUtils.convertFloatArrayToDouble(na.floatValues());
                    effects[0][i + numberOfFactors + 1] = DoubleMatrixFactory.DEFAULT.make(nObs, 1, values);
                }
                fixedEffects = DoubleMatrixFactory.DEFAULT.compose(effects);
            } else {
                fixedEffects = DoubleMatrixFactory.DEFAULT.make(nObs, 1, 1.0);
            }
            DoubleMatrix genotype = DoubleMatrixFactory.DEFAULT.make(nObs, numberOfMarkers);
            String[] markerNames = new String[numberOfMarkers];
            for (int m = 0; m < numberOfMarkers; ++m) {
                for (int i = 0; i < nObs; ++i) {
                    genotype.set(i, m, myGenotype.referenceProbability(i, m));
                }
                markerNames[m] = myGenotype.siteName(m);
            }
            RegRidgeEmmaDoubleMatrix ridgeRegression = new RegRidgeEmmaDoubleMatrix(phenotype, fixedEffects, genotype);
            ridgeRegression.solve();
            float[] gebv = AssociationUtils.convertDoubleArrayToFloat(ridgeRegression.getBlups());
            String phenoName = attr.name();
            ArrayList<PhenotypeAttribute> attributeList = new ArrayList<PhenotypeAttribute>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            attributeList.add(myTaxaAttribute);
            typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            attributeList.add(new NumericAttribute(phenoName + "_GEBV", gebv, new OpenBitSet(nObs)));
            typeList.add(Phenotype.ATTRIBUTE_TYPE.data);
            Phenotype gebvPheno = new PhenotypeBuilder().assignName("GEBV_" + phenoName).fromAttributeList(attributeList, typeList).build().get(0);
            String datumName = "GEBVs_" + phenoName + "_" + dataset.getName();
            StringBuilder comment = new StringBuilder("Ridge Regression from ");
            comment.append(dataset.getName()).append(":\n");
            comment.append("Genomic Estimated Breeding Values (GEBVs)\n");
            comment.append("trait = ").append(phenoName).append("\n");
            comment.append(nObs).append(" lines");
            theResults.add(new Datum(datumName, gebvPheno, comment.toString()));
            double[] markerBlups = ridgeRegression.getMrkBlups();
            Object[][] blupTable = new Object[numberOfMarkers][2];
            for (int i = 0; i < numberOfMarkers; ++i) {
                blupTable[i][0] = markerNames[i];
                blupTable[i][1] = new Double(markerBlups[i]);
            }
            SimpleTableReport str = new SimpleTableReport("Marker BLUPs for " + dataset.getName(), new String[]{"Marker", phenoName + "_BLUP"}, blupTable);
            datumName = dataset.getName() + "_marker BLUPs_" + phenoName;
            comment = new StringBuilder("Ridge Regression from ");
            comment.append(dataset.getName()).append(":\n");
            comment.append("Marker BLUPs\n");
            comment.append("trait = ").append(phenoName).append("\n");
            comment.append(numberOfMarkers).append(" markers");
            theResults.add(new Datum(datumName, str, comment.toString()));
        }
        return theResults;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = RidgeRegressionEmmaPlugin.class.getResource("/net/maizegenetics/analysis/images/LinearAssociation.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Genomic Selection";
    }

    @Override
    public String getToolTipText() {
        return "Predict Phenotypes using Ridge Regression for Genomic Selection";
    }
}

