/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

class PlotOptionsDialog
extends JDialog {
    boolean isCanceled = true;
    private JPanel mainPanel = new JPanel();
    private JButton okayButton = new JButton();
    private JButton cancelButton = new JButton();
    private JComboBox traitList;
    private GridBagLayout gridBagLayout2 = new GridBagLayout();

    public PlotOptionsDialog(Frame f, String[] traits) {
        super(f, "Manhattan Plot Options", true);
        String[] dropDownList = new String[traits.length + 1];
        dropDownList[0] = "Select trait";
        for (int i = 1; i < dropDownList.length; ++i) {
            dropDownList[i] = traits[i - 1];
        }
        this.traitList = new JComboBox<String>(dropDownList);
        try {
            this.initUI();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void initUI() throws Exception {
        this.mainPanel.setMinimumSize(new Dimension(300, 80));
        this.mainPanel.setPreferredSize(new Dimension(300, 80));
        this.mainPanel.setLayout(this.gridBagLayout2);
        GridBagConstraints c = new GridBagConstraints();
        this.traitList.setSelectedIndex(0);
        this.traitList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsDialog.this.traitSelector_actionPerformed(e);
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.gridwidth = 2;
        this.mainPanel.add((Component)this.traitList, c);
        this.okayButton.setMaximumSize(new Dimension(63, 27));
        this.okayButton.setMinimumSize(new Dimension(63, 27));
        this.okayButton.setText("Okay");
        this.okayButton.setEnabled(false);
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsDialog.this.okayButton_actionPerformed(e);
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.okayButton, c);
        this.cancelButton.setMaximumSize(new Dimension(63, 27));
        this.cancelButton.setMinimumSize(new Dimension(63, 27));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsDialog.this.cancelButton_actionPerformed(e);
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        this.mainPanel.add((Component)this.cancelButton, c);
        this.add((Component)this.mainPanel, "Center");
    }

    private void okayButton_actionPerformed(ActionEvent e) {
        this.isCanceled = false;
        this.setVisible(false);
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
    }

    private void traitSelector_actionPerformed(ActionEvent e) {
        if (this.traitList.getSelectedIndex() != 0) {
            this.okayButton.setEnabled(true);
        } else {
            this.okayButton.setEnabled(false);
        }
    }

    public String getTrait() {
        return (String)this.traitList.getSelectedItem();
    }

    public int getTraitIndex() {
        return this.traitList.getSelectedIndex();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(600, 600);
    }
}

