/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import net.maizegenetics.util.TableReport;
import org.jfree.data.xy.DefaultTableXYDataset;

public class TableReportXYDataset
extends DefaultTableXYDataset {
    double[][] theData;
    String[] seriesNames;
    String xName;
    int numberYAxes = 1;

    public TableReportXYDataset(TableReport theTable, int seriesX, int seriesY) {
        this.numberYAxes = 1;
        this.setTableReport(theTable, seriesX, seriesY, -1);
    }

    public TableReportXYDataset(TableReport theTable, int seriesX, int seriesY1, int seriesY2) {
        this.numberYAxes = 2;
        this.setTableReport(theTable, seriesX, seriesY1, seriesY2);
    }

    public int getItemCount(int parm1) {
        return this.theData.length;
    }

    public Number getX(int series, int item) {
        Double x = new Double(this.theData[item][0]);
        return x;
    }

    public int getSeriesCount() {
        return this.numberYAxes;
    }

    public Number getY(int series, int item) {
        Double y = new Double(this.theData[item][1 + series]);
        return y;
    }

    public String getSeriesName(int series) {
        return this.seriesNames[series];
    }

    public String getSeriesKey(int series) {
        return this.seriesNames[series];
    }

    public String getXName() {
        return this.xName;
    }

    public boolean setTableReport(TableReport theTable, int seriesX, int seriesY1, int seriesY2) {
        int countGood = 0;
        double[][] tempData = new double[(int)theTable.getRowCount()][this.numberYAxes + 1];
        int i = 0;
        while ((long)i < theTable.getRowCount()) {
            Object[] theRawData = theTable.getRow(i);
            try {
                tempData[countGood][0] = Double.valueOf(theRawData[seriesX].toString());
                tempData[countGood][1] = Double.valueOf(theRawData[seriesY1].toString());
                if (Double.isNaN(tempData[countGood][0]) || Double.isNaN(tempData[countGood][1])) {
                    throw new NumberFormatException();
                }
                if (this.numberYAxes == 2) {
                    tempData[countGood][2] = Double.valueOf(theRawData[seriesY2].toString());
                    if (Double.isNaN(tempData[countGood][2])) {
                        throw new NumberFormatException();
                    }
                }
                ++countGood;
            }
            catch (NumberFormatException ex) {
                System.out.println("throw new NumberFormatException();");
            }
            ++i;
        }
        this.theData = new double[countGood][this.numberYAxes + 1];
        for (i = 0; i < countGood; ++i) {
            for (int j = 0; j < this.theData[0].length; ++j) {
                this.theData[i][j] = tempData[i][j];
            }
        }
        this.seriesNames = new String[this.numberYAxes];
        Object[] theNames = theTable.getTableColumnNames();
        this.xName = (String)theNames[seriesX];
        this.seriesNames[0] = (String)theNames[seriesY1];
        if (this.numberYAxes == 2) {
            this.seriesNames[1] = (String)theNames[seriesY2];
        }
        return true;
    }
}

