/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.HDF5Utils;
import org.apache.log4j.Logger;

public class BuildUnfinishedHDF5GenotypesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(BuildUnfinishedHDF5GenotypesPlugin.class);
    String dataSetDescrip;
    String date;
    private PluginParameter<String> inputGenotypes = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input file").required(true).inFile().description("Input, unfinished HDF5 genotype (*.h5) file to be fininalized").build();
    private PluginParameter<String> outputGenotypes = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output file").required(false).outFile().description("Output, finished HDF5 genotype (*.h5) file which can be opened with the TASSEL5 GUI. __DATE__ is replaced with a _yyyyMMdd date stamp.").build();
    private PluginParameter<String> dataSetName = new PluginParameter.Builder<String>("name", null, String.class).guiName("Data set name").required(false).description("(Optional) Short data set name to be added as an root level annotation under \"dataSetName\"").build();
    private PluginParameter<String> dataSetDescription = new PluginParameter.Builder<String>("desc", null, String.class).guiName("Data set description").required(false).description("(Optional) Short data set description to be added as an root level annotation under \"dataSetDescription\"").build();

    public BuildUnfinishedHDF5GenotypesPlugin() {
        super(null, false);
    }

    public BuildUnfinishedHDF5GenotypesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        this.date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String outfile = this.outputFile();
        this.outputFile(outfile.replace("__DATE__", "_" + this.date));
    }

    @Override
    public DataSet processData(DataSet input) {
        String message = this.buildUnfinishedHDF5Genotypes();
        if (message != null) {
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(message);
        }
        this.fireProgress(100);
        return null;
    }

    private String buildUnfinishedHDF5Genotypes() {
        GenotypeTableBuilder genoTable;
        if (this.outputFile() == null) {
            myLogger.info((Object)("\n\nBuildUnfinishedHDF5GenotypesPlugin:\nFinalizing the following HDF5 genotype file:\n   " + this.inputFile() + "\n\n"));
        } else {
            myLogger.info((Object)("\n\nBuildUnfinishedHDF5GenotypesPlugin: Copying the HDF5 genotypes from the file:\n   " + this.inputFile() + "\nand finalizing them in this output file:\n   " + this.outputFile() + "\n\n"));
        }
        if (this.dataSetDescription() != null) {
            this.dataSetDescrip = this.parseDataSetDescription(this.dataSetDescription());
        }
        if (this.outputFile() == null) {
            genoTable = GenotypeTableBuilder.getBuilder(this.inputFile());
        } else {
            String message = this.copyInputFile();
            if (message != null) {
                return message;
            }
            genoTable = GenotypeTableBuilder.getBuilder(this.outputFile());
        }
        if (this.dataSetName() != null) {
            genoTable.dataSetName(this.parseDataSetName(this.dataSetName()));
        }
        if (this.dataSetDescription() != null) {
            genoTable.dataSetDescription(this.dataSetDescrip);
        }
        genoTable.build();
        myLogger.info((Object)"\n\nFinished finalizing HDF5 genotypes file\n\n");
        return null;
    }

    private String parseDataSetName(String dataSetName) {
        return dataSetName.replace("__DATE__", "_" + this.date);
    }

    private String parseDataSetDescription(String dataSetDescrip) {
        IHDF5Reader h5Reader = HDF5Factory.openForReading((String)this.inputFile());
        int nSNPs = HDF5Utils.getHDF5PositionNumber(h5Reader);
        TaxaList tL = new TaxaListBuilder().buildFromHDF5Genotypes(h5Reader);
        int nTaxa = tL.numberOfTaxa();
        h5Reader.close();
        return dataSetDescrip.replace("__SNPS__", "" + nSNPs).replace("__TAXA__", "" + nTaxa).replace("__DATE__", this.date);
    }

    private String copyInputFile() {
        try {
            Files.copy(new File(this.inputFile()).toPath(), new File(this.outputFile()).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            myLogger.error((Object)("Could not copy file: " + e.getMessage()));
            return "\n\nERROR: Could not copy input file to output file: " + e.getMessage() + "\n\n";
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Split chromosomes from HDF5 genotype file";
    }

    @Override
    public String getToolTipText() {
        return "Split chromosomes from HDF5 genotype file";
    }

    public String inputFile() {
        return this.inputGenotypes.value();
    }

    public BuildUnfinishedHDF5GenotypesPlugin inputFile(String value) {
        this.inputGenotypes = new PluginParameter<String>(this.inputGenotypes, value);
        return this;
    }

    public String outputFile() {
        return this.outputGenotypes.value();
    }

    public BuildUnfinishedHDF5GenotypesPlugin outputFile(String value) {
        this.outputGenotypes = new PluginParameter<String>(this.outputGenotypes, value);
        return this;
    }

    public String dataSetName() {
        return this.dataSetName.value();
    }

    public BuildUnfinishedHDF5GenotypesPlugin dataSetName(String value) {
        this.dataSetName = new PluginParameter<String>(this.dataSetName, value);
        return this;
    }

    public String dataSetDescription() {
        return this.dataSetDescription.value();
    }

    public BuildUnfinishedHDF5GenotypesPlugin dataSetDescription(String value) {
        this.dataSetDescription = new PluginParameter<String>(this.dataSetDescription, value);
        return this;
    }
}

