/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;

public class CombineDataSetsPlugin
extends AbstractPlugin {
    private final Map<Plugin, DataSet> myDataSets = new LinkedHashMap<Plugin, DataSet>();
    private final Map<Plugin, DataSet> myOnceDataSets = new LinkedHashMap<Plugin, DataSet>();

    public CombineDataSetsPlugin() {
        super(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet dataSet) {
        try {
            ArrayList<DataSet> dataSets;
            Map<Plugin, DataSet> map = this.myDataSets;
            synchronized (map) {
                block8: {
                    if (!this.myDataSets.containsValue(null) && !this.myOnceDataSets.containsValue(null)) break block8;
                    DataSet dataSet2 = null;
                    return dataSet2;
                }
                dataSets = new ArrayList<DataSet>();
                dataSets.addAll(this.myDataSets.values());
                dataSets.addAll(this.myOnceDataSets.values());
                this.reset();
            }
            DataSet result = DataSet.getDataSet(dataSets, this);
            this.fireDataSetReturned(result);
            DataSet dataSet3 = result;
            return dataSet3;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public void reset() {
        Set<Plugin> keys = this.myDataSets.keySet();
        Iterator<Plugin> itr = keys.iterator();
        while (itr.hasNext()) {
            this.myDataSets.put(itr.next(), null);
        }
    }

    @Override
    public String getToolTipText() {
        return "Combine Datasets";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Combine";
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet input = (DataSet)event.getSource();
        Plugin creator = input.getCreator();
        if (this.myOnceDataSets.containsKey(creator)) {
            DataSet value = this.myOnceDataSets.get(creator);
            if (value != null) {
                throw new IllegalStateException("CombineDataSetsPlugin: dataSetReturned: this plugin should only return data once: " + creator);
            }
            this.myOnceDataSets.put(creator, input);
        } else if (this.myDataSets.containsKey(creator)) {
            DataSet value = this.myDataSets.get(creator);
            if (value != null) {
                throw new IllegalStateException("CombineDataSetsPlugin: dataSetReturned: this plugin should only return data once per iteration: " + creator);
            }
            this.myDataSets.put(creator, input);
        } else {
            throw new IllegalStateException("CombineDataSetsPlugin: dataSetReturned: can not receive data from unknown plugin: " + creator);
        }
        this.performFunction(null);
    }

    public void receiveDataSetOnceFrom(Plugin plugin) {
        super.receiveInput(plugin);
        this.myOnceDataSets.put(plugin, null);
    }

    public void receiveDataSetFrom(Plugin plugin) {
        super.receiveInput(plugin);
        this.myDataSets.put(plugin, null);
    }

    @Override
    public void receiveInput(Plugin input) {
        this.receiveDataSetFrom(input);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (DataSet current : this.myDataSets.values()) {
            if (current == null) continue;
            str.append(current.toString());
        }
        return str.toString();
    }
}

