/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ExportMultiplePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ExportMultiplePlugin.class);
    private FileLoadPlugin.TasselFileType[] myFileTypes = null;
    private String[] mySaveFiles = null;
    private final ExportPlugin myExportPlugin;

    public ExportMultiplePlugin(Frame parentFrame) {
        super(parentFrame, false);
        this.myExportPlugin = new ExportPlugin(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        List data = input.getDataSet();
        int numSaveFiles = 0;
        if (this.mySaveFiles != null) {
            numSaveFiles = this.mySaveFiles.length;
        }
        if (numSaveFiles != 0 && numSaveFiles != 1 && numSaveFiles != data.size()) {
            throw new IllegalStateException("ExportMultiplePlugin: performFunction: number of save files should be either 0, 1 or number of input data sets.");
        }
        if (this.myFileTypes != null && this.myFileTypes.length != 0 && this.myFileTypes.length != 1 && this.myFileTypes.length != data.size()) {
            throw new IllegalStateException("ExportMultiplePlugin: performFunction: number of files types should be either 0, 1 or number of input data sets.");
        }
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            Datum datum = (Datum)data.get(i);
            DataSet current = new DataSet(datum, input.getCreator());
            if (numSaveFiles == 0) {
                this.myExportPlugin.saveFile(datum.getName());
            } else if (numSaveFiles == 1) {
                String temp;
                if (data.size() == 1) {
                    temp = this.mySaveFiles[0];
                } else {
                    String directory;
                    String filename = Utils.getFilename(this.mySaveFiles[0]);
                    temp = filename.replaceFirst("\\.", i + 1 + ".");
                    if (temp.length() == filename.length()) {
                        temp = filename + (i + 1);
                    }
                    if (!(directory = Utils.getDirectory(this.mySaveFiles[0])).equals(".")) {
                        File dir = new File(directory);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        temp = directory + "/" + temp;
                    }
                }
                this.myExportPlugin.saveFile(temp);
            } else {
                this.myExportPlugin.saveFile(this.mySaveFiles[i]);
            }
            if (this.myFileTypes == null || this.myFileTypes.length == 0) {
                this.myExportPlugin.fileType(null);
            } else if (this.myFileTypes.length == 1) {
                this.myExportPlugin.fileType(this.myFileTypes[0]);
            } else {
                this.myExportPlugin.fileType(this.myFileTypes[i]);
            }
            this.myExportPlugin.performFunction(current);
        }
        this.fireProgress(100);
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Export Multiple";
    }

    @Override
    public String getToolTipText() {
        return "Export multiple data sets to files.";
    }

    public String[] getSaveFiles() {
        return this.mySaveFiles;
    }

    public void setSaveFiles(String[] saveFiles) {
        this.mySaveFiles = saveFiles;
    }

    public void setAlignmentFileTypes(FileLoadPlugin.TasselFileType[] types) {
        this.myFileTypes = types;
    }

    public void setAlignmentFileType(FileLoadPlugin.TasselFileType type) {
        this.myFileTypes = new FileLoadPlugin.TasselFileType[]{type};
    }

    public void setIncludeAnnotations(boolean include) {
        this.myExportPlugin.includeTaxaAnnotations(include);
    }

    public void setIncludeDepth(boolean include) {
        this.myExportPlugin.keepDepth(include);
    }
}

