/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.avro.ExportAvro;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListTableReport;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.io.FilterJSONUtils;
import net.maizegenetics.dna.snp.io.FlapjackUtils;
import net.maizegenetics.dna.snp.io.JSONUtils;
import net.maizegenetics.dna.snp.io.SiteScoresIO;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListTableReport;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixUtils;
import net.maizegenetics.taxa.distance.WriteDistanceMatrix;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.taxa.tree.SimpleTree;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ExportPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ExportPlugin.class);
    private PluginParameter<String> mySaveFile = new PluginParameter.Builder<String>("saveAs", null, String.class).description("Save file as...").outFile().required(true).build();
    private PluginParameter<FileLoadPlugin.TasselFileType> myFileType = new PluginParameter.Builder<FileLoadPlugin.TasselFileType>("format", null, FileLoadPlugin.TasselFileType.class).description("Export file format (Default format depends on data being exported)").required(true).objectListSingleSelect().range((Comparable<T>[])FileLoadPlugin.TasselFileType.values()).build();
    private PluginParameter<Boolean> myKeepDepth = new PluginParameter.Builder<Boolean>("keepDepth", true, Boolean.class).description("Whether to keep depth if format supports depth.").dependentOnParameter(this.myFileType, (Object[])new FileLoadPlugin.TasselFileType[]{FileLoadPlugin.TasselFileType.VCF, FileLoadPlugin.TasselFileType.HDF5}).build();
    private PluginParameter<Boolean> myIncludeTaxaAnnotations = new PluginParameter.Builder<Boolean>("includeTaxaAnnotations", true, Boolean.class).description("Whether to include taxa annotations if format supports taxa annotations.").dependentOnParameter(this.myFileType, (Object[])new FileLoadPlugin.TasselFileType[]{FileLoadPlugin.TasselFileType.VCF, FileLoadPlugin.TasselFileType.HDF5, FileLoadPlugin.TasselFileType.Hapmap, FileLoadPlugin.TasselFileType.HapmapDiploid, FileLoadPlugin.TasselFileType.HapmapLIX}).build();
    private PluginParameter<Boolean> myIncludeBranchLengths = new PluginParameter.Builder<Boolean>("includeBranchLengths", true, Boolean.class).description("Whether to include branch lengths for Newick formatted files.").dependentOnParameter(this.myFileType, (Object[])new FileLoadPlugin.TasselFileType[]{FileLoadPlugin.TasselFileType.Newick}).build();

    public ExportPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input.getSize() != 1) {
            throw new IllegalArgumentException("Please select only one item.");
        }
        Object data = input.getData(0).getData();
        if (data instanceof GenotypeTable) {
            GenotypeTable genotype = (GenotypeTable)data;
            ArrayList<FileLoadPlugin.TasselFileType> temp = new ArrayList<FileLoadPlugin.TasselFileType>();
            if (genotype.hasGenotype()) {
                temp.add(FileLoadPlugin.TasselFileType.Hapmap);
                temp.add(FileLoadPlugin.TasselFileType.HapmapDiploid);
                temp.add(FileLoadPlugin.TasselFileType.HDF5);
                temp.add(FileLoadPlugin.TasselFileType.VCF);
                temp.add(FileLoadPlugin.TasselFileType.Plink);
                temp.add(FileLoadPlugin.TasselFileType.Flapjack);
                temp.add(FileLoadPlugin.TasselFileType.Phylip_Seq);
                temp.add(FileLoadPlugin.TasselFileType.Phylip_Inter);
                temp.add(FileLoadPlugin.TasselFileType.Table);
            }
            if (genotype.hasDepth()) {
                temp.add(FileLoadPlugin.TasselFileType.Depth);
            }
            if (genotype.hasReferenceProbablity()) {
                temp.add(FileLoadPlugin.TasselFileType.ReferenceProbability);
            }
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, temp);
        } else if (data instanceof Phenotype) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.Phenotype, FileLoadPlugin.TasselFileType.PlinkPhenotype));
        } else if (data instanceof FilterList) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.Filter));
        } else if (data instanceof DistanceMatrix) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.SqrMatrix, FileLoadPlugin.TasselFileType.SqrMatrixBin, FileLoadPlugin.TasselFileType.SqrMatrixRaw, FileLoadPlugin.TasselFileType.SqrMatrixDARwinDIS));
        } else if (data instanceof TaxaList) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.TaxaList, FileLoadPlugin.TasselFileType.Table));
        } else if (data instanceof TaxaListTableReport) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.TaxaList, FileLoadPlugin.TasselFileType.Table));
        } else if (data instanceof PositionList) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.PositionList, FileLoadPlugin.TasselFileType.Table));
        } else if (data instanceof PositionListTableReport) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.PositionList, FileLoadPlugin.TasselFileType.Table));
        } else if (data instanceof TableReport) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.Table));
        } else if (data instanceof SimpleTree) {
            this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, Arrays.asList(FileLoadPlugin.TasselFileType.Newick, FileLoadPlugin.TasselFileType.Report));
        } else {
            throw new IllegalStateException("Don't know how to export data type: " + data.getClass().getName());
        }
        if (!this.isInteractive() && this.myFileType.isEmpty() && this.myFileType.hasPossibleValues()) {
            this.fileType(this.myFileType.possibleValues().get(0));
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        String filename = null;
        Object data = input.getData(0).getData();
        if (data instanceof GenotypeTable) {
            filename = this.performFunctionForAlignment((GenotypeTable)data);
        } else if (data instanceof Phenotype) {
            filename = this.performFunctionForPhenotype((Phenotype)data);
        } else if (data instanceof FilterList) {
            filename = this.performFunctionForFilter((FilterList)data);
        } else if (data instanceof DistanceMatrix) {
            filename = this.performFunctionForDistanceMatrix((DistanceMatrix)data);
        } else if (data instanceof TaxaList) {
            filename = this.performFunctionForTaxaList((TaxaList)data);
        } else if (data instanceof TaxaListTableReport) {
            filename = this.performFunctionForTaxaList(((TaxaListTableReport)data).getTaxaList());
        } else if (data instanceof PositionList) {
            filename = this.performFunctionForPositionList((PositionList)data);
        } else if (data instanceof PositionListTableReport) {
            filename = this.performFunctionForPositionList(((PositionListTableReport)data).getPositionList());
        } else if (data instanceof TableReport) {
            filename = this.performFunctionForTableReport((TableReport)data);
        } else if (data instanceof SimpleTree) {
            filename = this.performFunctionForSimpleTree((SimpleTree)data);
        } else {
            throw new IllegalStateException("Don't know how to export data type: " + data.getClass().getName());
        }
        if (filename != null) {
            myLogger.info((Object)("performFunction: wrote dataset: " + input.getData(0).getName() + " to file: " + filename));
        }
        return null;
    }

    public String performFunctionForDistanceMatrix(DistanceMatrix input) {
        if (this.fileType() == FileLoadPlugin.TasselFileType.SqrMatrix) {
            String filename = Utils.addSuffixIfNeeded(this.saveFile(), ".txt", new String[]{".txt", ".txt.gz"});
            WriteDistanceMatrix.saveDelimitedDistanceMatrix(input, filename);
            return filename;
        }
        if (this.fileType() == FileLoadPlugin.TasselFileType.SqrMatrixRaw) {
            String[] grmFiles = DistanceMatrixUtils.getGRMFilenames(this.saveFile());
            WriteDistanceMatrix.saveRawMultiBlupMatrix(input, grmFiles[0], grmFiles[3]);
            return grmFiles[3];
        }
        if (this.fileType() == FileLoadPlugin.TasselFileType.SqrMatrixBin) {
            String[] grmFiles = DistanceMatrixUtils.getGRMFilenames(this.saveFile());
            WriteDistanceMatrix.saveBinMultiBlupMatrix(input, grmFiles[0], grmFiles[1], grmFiles[2]);
            return grmFiles[1];
        }
        if (this.fileType() == FileLoadPlugin.TasselFileType.SqrMatrixDARwinDIS) {
            String filename = Utils.addSuffixIfNeeded(this.saveFile(), ".dis");
            WriteDistanceMatrix.saveDARwinMatrix(input, filename);
            return filename;
        }
        throw new IllegalArgumentException("ExportPlugin: performFunctionForDistanceMatrix: Unknown file type: " + (Object)((Object)this.fileType()));
    }

    public String performFunctionForTableReport(TableReport input) {
        File theFile = new File(Utils.addSuffixIfNeeded(this.saveFile(), ".txt"));
        TableReportUtils.saveDelimitedTableReport(input, "\t", theFile);
        return theFile.getAbsolutePath();
    }

    public String performFunctionForFilter(FilterList filter) {
        return FilterJSONUtils.exportFilterToJSON(filter, this.saveFile());
    }

    public String performFunctionForPhenotype(Phenotype input) {
        String filename = Utils.addSuffixIfNeeded(this.saveFile(), ".txt");
        if (this.fileType() == FileLoadPlugin.TasselFileType.Phenotype) {
            PhenotypeUtils.write(input, filename);
        } else if (this.fileType() == FileLoadPlugin.TasselFileType.PlinkPhenotype) {
            PhenotypeUtils.writePlink(input, filename);
        }
        return new File(filename).getAbsolutePath();
    }

    public String performFunctionForAlignment(GenotypeTable inputAlignment) {
        String resultFile;
        block52: {
            resultFile = this.saveFile();
            if (this.fileType() == FileLoadPlugin.TasselFileType.ReferenceProbability) {
                resultFile = SiteScoresIO.writeReferenceProbability(inputAlignment, resultFile);
            } else if (this.fileType() == FileLoadPlugin.TasselFileType.Depth) {
                resultFile = SiteScoresIO.writeDepth(inputAlignment, resultFile);
            } else if (this.fileType() == FileLoadPlugin.TasselFileType.Hapmap) {
                resultFile = ExportUtils.writeToHapmap(inputAlignment, false, this.saveFile(), '\t', this.includeTaxaAnnotations(), this);
            } else if (this.fileType() == FileLoadPlugin.TasselFileType.HapmapDiploid) {
                resultFile = ExportUtils.writeToHapmap(inputAlignment, true, this.saveFile(), '\t', this.includeTaxaAnnotations(), this);
            } else if (this.fileType() == FileLoadPlugin.TasselFileType.Plink) {
                resultFile = ExportUtils.writeToPlink(inputAlignment, this.saveFile(), '\t');
            } else if (this.fileType() == FileLoadPlugin.TasselFileType.Flapjack) {
                resultFile = FlapjackUtils.writeToFlapjack(inputAlignment, this.saveFile(), '\t');
            } else {
                if (this.fileType() == FileLoadPlugin.TasselFileType.Phylip_Seq) {
                    resultFile = Utils.addSuffixIfNeeded(this.saveFile(), ".phy");
                    try (PrintWriter out = new PrintWriter(new FileWriter(resultFile));){
                        ExportUtils.printSequential(inputAlignment, out);
                        break block52;
                    }
                    catch (Exception e) {
                        myLogger.debug((Object)e.getMessage(), (Throwable)e);
                        throw new IllegalStateException("ExportPlugin: performFunction: Problem writing file: " + resultFile);
                    }
                }
                if (this.fileType() == FileLoadPlugin.TasselFileType.Phylip_Inter) {
                    resultFile = Utils.addSuffixIfNeeded(this.saveFile(), ".phy");
                    try (PrintWriter out = new PrintWriter(new FileWriter(resultFile));){
                        ExportUtils.printInterleaved(inputAlignment, out);
                        break block52;
                    }
                    catch (Exception e) {
                        myLogger.debug((Object)e.getMessage(), (Throwable)e);
                        throw new IllegalStateException("ExportPlugin: performFunction: Problem writing file: " + resultFile);
                    }
                }
                if (this.fileType() == FileLoadPlugin.TasselFileType.Table) {
                    resultFile = ExportUtils.saveDelimitedAlignment(inputAlignment, "\t", this.saveFile());
                } else if (this.fileType() == FileLoadPlugin.TasselFileType.Serial) {
                    resultFile = ExportUtils.writeAlignmentToSerialGZ(inputAlignment, this.saveFile());
                } else if (this.fileType() == FileLoadPlugin.TasselFileType.HDF5) {
                    resultFile = ExportUtils.writeGenotypeHDF5(inputAlignment, this.saveFile(), this.keepDepth());
                } else if (this.fileType() == FileLoadPlugin.TasselFileType.VCF) {
                    resultFile = ExportUtils.writeToVCF(inputAlignment, this.saveFile(), this.keepDepth(), this);
                } else if (this.fileType() == FileLoadPlugin.TasselFileType.Avro) {
                    resultFile = ExportAvro.write(inputAlignment, this.saveFile());
                } else {
                    throw new IllegalStateException("ExportPlugin: performFunction: Unknown Genotype File Format: " + (Object)((Object)this.fileType()));
                }
            }
        }
        return resultFile;
    }

    public String performFunctionForSimpleTree(SimpleTree input) {
        String resultFile = null;
        if (this.fileType() == FileLoadPlugin.TasselFileType.Newick) {
            resultFile = Utils.addSuffixIfNeeded(this.saveFile(), ".nwk");
            NewickUtils.write(resultFile, input, (boolean)this.includeBranchLengths());
        } else {
            resultFile = Utils.addSuffixIfNeeded(this.saveFile(), ".txt");
            try (PrintWriter writer = new PrintWriter(resultFile);){
                input.report(writer);
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("ExportPlugin: performFunctionForReport: Problem writing file: " + resultFile);
            }
        }
        return resultFile;
    }

    public String performFunctionForTaxaList(TaxaList input) {
        if (this.fileType() == FileLoadPlugin.TasselFileType.TaxaList) {
            return JSONUtils.exportTaxaListToJSON(input, this.saveFile());
        }
        if (this.fileType() == FileLoadPlugin.TasselFileType.Table) {
            File theFile = new File(Utils.addSuffixIfNeeded(this.saveFile(), ".txt"));
            TableReportUtils.saveDelimitedTableReport(new TaxaListTableReport(input), "\t", theFile);
            return theFile.getAbsolutePath();
        }
        throw new IllegalStateException("ExportPlugin: performFunctionForTaxaList: Can't export TaxaList as: " + (Object)((Object)this.fileType()));
    }

    public String performFunctionForPositionList(PositionList input) {
        if (this.fileType() == FileLoadPlugin.TasselFileType.PositionList) {
            return JSONUtils.exportPositionListToJSON(input, this.saveFile());
        }
        if (this.fileType() == FileLoadPlugin.TasselFileType.Table) {
            File theFile = new File(Utils.addSuffixIfNeeded(this.saveFile(), ".txt"));
            TableReportUtils.saveDelimitedTableReport(new PositionListTableReport(input), "\t", theFile);
            return theFile.getAbsolutePath();
        }
        throw new IllegalStateException("ExportPlugin: performFunctionForPositionList: Can't export PositionList as: " + (Object)((Object)this.fileType()));
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = ExportPlugin.class.getResource("/net/maizegenetics/analysis/images/Export16.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Save As...";
    }

    @Override
    public String getToolTipText() {
        return "Save data to files.";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/Export/Export";
    }

    public String saveFile() {
        return this.mySaveFile.value();
    }

    public ExportPlugin saveFile(String value) {
        this.mySaveFile = new PluginParameter<String>(this.mySaveFile, value);
        return this;
    }

    @Deprecated
    public ExportPlugin setSaveFile(String saveFile) {
        this.mySaveFile = new PluginParameter<String>(this.mySaveFile, saveFile);
        return this;
    }

    public FileLoadPlugin.TasselFileType fileType() {
        return this.myFileType.value();
    }

    public ExportPlugin fileType(FileLoadPlugin.TasselFileType value) {
        this.myFileType = new PluginParameter<FileLoadPlugin.TasselFileType>(this.myFileType, value);
        return this;
    }

    @Deprecated
    public ExportPlugin setAlignmentFileType(FileLoadPlugin.TasselFileType type) {
        this.fileType(type);
        return this;
    }

    public Boolean keepDepth() {
        return this.myKeepDepth.value();
    }

    public ExportPlugin keepDepth(Boolean value) {
        this.myKeepDepth = new PluginParameter<Boolean>(this.myKeepDepth, value);
        return this;
    }

    public Boolean includeTaxaAnnotations() {
        return this.myIncludeTaxaAnnotations.value();
    }

    public ExportPlugin includeTaxaAnnotations(Boolean value) {
        this.myIncludeTaxaAnnotations = new PluginParameter<Boolean>(this.myIncludeTaxaAnnotations, value);
        return this;
    }

    public Boolean includeBranchLengths() {
        return this.myIncludeBranchLengths.value();
    }

    public ExportPlugin includeBranchLengths(Boolean value) {
        this.myIncludeBranchLengths = new PluginParameter<Boolean>(this.myIncludeBranchLengths, value);
        return this;
    }
}

