/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.ColumnMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lnet/maizegenetics/analysis/data/GenotypeToAdditiveValuesPlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "getButtonName", "", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "processData", "Lnet/maizegenetics/plugindef/DataSet;", "input", "runPlugin", "Lnet/maizegenetics/util/ColumnMatrix;", "genotype", "Lnet/maizegenetics/dna/snp/GenotypeTable;", "tassel"})
public final class GenotypeToAdditiveValuesPlugin
extends AbstractPlugin {
    public GenotypeToAdditiveValuesPlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    @NotNull
    public DataSet processData(@Nullable DataSet input) {
        List<Datum> temp;
        DataSet dataSet = input;
        List<Datum> list = temp = dataSet == null ? null : dataSet.getDataOfType(GenotypeTable.class);
        if (!(list == null ? false : list.size() == 1)) {
            throw new IllegalArgumentException("GenotypeToAdditiveValuesPlugin: processData: must input a genotype");
        }
        Object object = temp.get(0).getData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.dna.snp.GenotypeTable");
        }
        GenotypeTable genotype = (GenotypeTable)object;
        ColumnMatrix.Builder result = new ColumnMatrix.Builder(genotype.numberOfTaxa(), genotype.numberOfSites());
        int n = 0;
        int n2 = genotype.numberOfSites();
        while (n < n2) {
            int site = n++;
            byte[] siteGenotypes = genotype.genotypeAllTaxa(site);
            int[][] alleleCounts = AlleleFreqCache.allelesSortedByFrequencyNucleotide(siteGenotypes);
            byte majorAllele = AlleleFreqCache.majorAllele(alleleCounts);
            int n3 = 0;
            int n4 = genotype.numberOfTaxa();
            while (n3 < n4) {
                byte by;
                int taxon = n3++;
                byte value = 0;
                byte[] alleles = GenotypeTableUtils.getDiploidValues(siteGenotypes[taxon]);
                if (alleles[0] != majorAllele) {
                    by = value;
                    value = (byte)(by + 1);
                }
                if (alleles[1] != majorAllele) {
                    by = value;
                    value = (byte)(by + 1);
                }
                result.set(taxon, site, value);
            }
        }
        return new DataSet(new Datum(Intrinsics.stringPlus((String)temp.get(0).getName(), (Object)" Additive Values"), result.build(), null), (Plugin)this);
    }

    @NotNull
    public final ColumnMatrix runPlugin(@NotNull GenotypeTable genotype) {
        Intrinsics.checkNotNullParameter((Object)genotype, (String)"genotype");
        Object object = this.performFunction(DataSet.getDataSet(genotype)).getDataOfType(ColumnMatrix.class).get(0).getData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.util.ColumnMatrix");
        }
        return (ColumnMatrix)object;
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Convert Genotype to Additive Values";
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Convert Genotype to Additive Values";
    }
}

