/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class HDF5SummaryPlugin
extends AbstractPlugin {
    private Logger logger = Logger.getLogger(HDF5SummaryPlugin.class);
    private H5FileType myFileType = H5FileType.UNKNOWN;
    GenotypeTable genos = null;
    TagsByTaxa tbt = null;
    TOPMInterface topm = null;
    IHDF5Reader h5reader = null;
    BufferedWriter outputWriter = null;
    private PluginParameter<String> inputFile = new PluginParameter.Builder<String>("input", null, String.class).description("TASSEL HDF5 file to get summary data from").guiName("HDF5 file").required(true).inFile().build();
    private PluginParameter<String> outputFile = new PluginParameter.Builder<String>("output", null, String.class).description("File to write summary data to").guiName("Output file").required(true).outFile().build();
    private PluginParameter<Boolean> taxaCount = new PluginParameter.Builder<Boolean>("taxaCount", false, Boolean.class).description("Output number of taxa in file").guiName("Output count of taxa?").build();
    private PluginParameter<Boolean> taxaNames = new PluginParameter.Builder<Boolean>("taxaNames", false, Boolean.class).description("Output names of all taxa in file").guiName("Output taxa names").build();
    private PluginParameter<Boolean> siteCount = new PluginParameter.Builder<Boolean>("siteCount", false, Boolean.class).description("Output number of sites in file").guiName("Output site count").build();
    private PluginParameter<Boolean> siteNames = new PluginParameter.Builder<Boolean>("siteNames", false, Boolean.class).description("Output names of all sites in file").guiName("Output site names").build();
    private PluginParameter<Boolean> tagCount = new PluginParameter.Builder<Boolean>("tagCount", false, Boolean.class).description("Output number of sequence tags in file").guiName("Output tag count").build();
    private PluginParameter<Boolean> tagSeqs = new PluginParameter.Builder<Boolean>("tagNames", false, Boolean.class).description("Output sequence of all tags in file").guiName("Output tag sequences").build();
    private PluginParameter<Boolean> hasDepth = new PluginParameter.Builder<Boolean>("hasDepth", false, Boolean.class).description("Output whether file contains read depth information").guiName("Output if has read depth").build();
    private PluginParameter<Boolean> printAll = new PluginParameter.Builder<Boolean>("all", false, Boolean.class).description("Output all available information (overrides other options)").guiName("Output all available information").build();
    private PluginParameter<Boolean> rawData = new PluginParameter.Builder<Boolean>("rawData", false, Boolean.class).description("Include only the raw output (no metadata or descriptions)").guiName("Output only raw data").build();

    public HDF5SummaryPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.h5reader = HDF5Factory.openForReading((String)this.inputFile());
        this.determineFileType();
        this.setUpDataStructures();
        try {
            this.outputWriter = Utils.getBufferedWriter(this.outputFile());
            if (!this.rawData().booleanValue()) {
                this.writeFileData();
            }
            if (this.siteCount().booleanValue() || this.printAll().booleanValue()) {
                this.writeSiteCount();
            }
            if (this.taxaCount().booleanValue() || this.printAll().booleanValue()) {
                this.writeTaxaCount();
            }
            if (this.tagCount().booleanValue() || this.printAll().booleanValue()) {
                this.writeTagCount();
            }
            if (this.hasDepth().booleanValue() || this.printAll().booleanValue()) {
                this.writeHasDepth();
            }
            if (this.siteNames().booleanValue() || this.printAll().booleanValue()) {
                this.writeSiteNames();
            }
            if (this.taxaNames().booleanValue() || this.printAll().booleanValue()) {
                this.writeTaxaNames();
            }
            if (this.tagSeqs().booleanValue() || this.printAll().booleanValue()) {
                this.writeTagSequences();
            }
            this.outputWriter.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("Error writing report to " + this.outputFile() + ":\n" + e.getStackTrace()));
        }
        return null;
    }

    private void determineFileType() {
        this.myFileType = HDF5Utils.doesGenotypeModuleExist(this.h5reader) ? H5FileType.GENOTYPE : (HDF5Utils.doTagsByTaxaExist(this.h5reader) ? H5FileType.TBT : (HDF5Utils.doTagsExist(this.h5reader) && !HDF5Utils.doTagsByTaxaExist(this.h5reader) ? H5FileType.TOPM : H5FileType.UNKNOWN));
    }

    private void setUpDataStructures() {
        switch (this.myFileType) {
            case GENOTYPE: {
                this.genos = ImportUtils.readGuessFormat(this.inputFile());
                break;
            }
            case TBT: {
                break;
            }
            case TOPM: {
                this.topm = TOPMUtils.readTOPM(this.inputFile());
                break;
            }
        }
    }

    private void writeFileData() throws IOException {
        File infile = new File(this.inputFile());
        String path = infile.getCanonicalFile().getAbsolutePath();
        String output = "### Summary data for TASSEL HDF5 file " + infile.getName() + " (" + path + ")###\n";
        switch (this.myFileType) {
            case GENOTYPE: {
                output = output + "File type:\tGenotypeTable";
                if (HDF5Utils.isTASSEL4HDF5Format(this.h5reader)) {
                    output = output + " (TASSEL 4 formatted)";
                }
                output = output + "\n";
                break;
            }
            case TOPM: {
                output = output + "File type:\tTagsOnPhysicalMap\n";
                break;
            }
            case TBT: {
                output = output + "File type:\tTagsByTaxa\n";
                break;
            }
            default: {
                output = output + "File type:\tUnknown\n";
            }
        }
        this.outputWriter.append(output);
    }

    private void writeSiteCount() throws IOException {
        String nsites;
        switch (this.myFileType) {
            case GENOTYPE: {
                nsites = "" + this.genos.numberOfSites();
                break;
            }
            default: {
                nsites = "n/a";
            }
        }
        String output = this.rawData() != false ? nsites + "\n" : "numberOfSites:\t" + nsites + "\n";
        this.outputWriter.append(output);
    }

    private void writeTaxaCount() throws IOException {
        String ntaxa;
        switch (this.myFileType) {
            case GENOTYPE: 
            case TBT: {
                ntaxa = "" + HDF5Utils.getHDF5TaxaNumTaxa(this.h5reader);
                break;
            }
            default: {
                ntaxa = "n/a";
            }
        }
        String output = this.rawData() != false ? ntaxa + "\n" : "numberOfTaxa:\t" + ntaxa + "\n";
        this.outputWriter.append(output);
    }

    private void writeTagCount() throws IOException {
        String ntags;
        switch (this.myFileType) {
            case TBT: 
            case TOPM: {
                ntags = "" + HDF5Utils.getHDF5TagCount(this.h5reader);
                break;
            }
            default: {
                ntags = "n/a";
            }
        }
        String output = this.rawData() != false ? ntags + "\n" : "numberOfTags:\t" + ntags + "\n";
        this.outputWriter.append(output);
    }

    private void writeHasDepth() throws IOException {
        String isDepth;
        switch (this.myFileType) {
            case GENOTYPE: {
                isDepth = "" + HDF5Utils.doesGenotypeDepthExist(this.h5reader);
                break;
            }
            case TOPM: {
                isDepth = "n/a";
                break;
            }
            case TBT: {
                isDepth = "true";
                break;
            }
            default: {
                isDepth = "unknown";
            }
        }
        String output = this.rawData() != false ? isDepth + "\n" : "hasDepth:\t" + isDepth + "\n";
        this.outputWriter.append(output);
    }

    private void writeSiteNames() throws IOException {
        StringBuilder sites = new StringBuilder();
        if (!this.rawData().booleanValue()) {
            sites.append("###Site Names###\n");
        }
        switch (this.myFileType) {
            case GENOTYPE: {
                for (int i = 0; i < this.genos.numberOfSites(); ++i) {
                    sites.append(this.genos.siteName(i) + "\n");
                }
                break;
            }
            default: {
                sites.append("(not applicable for this file type)\n");
            }
        }
        this.outputWriter.append(sites.toString());
    }

    private void writeTaxaNames() throws IOException {
        StringBuilder taxa = new StringBuilder();
        if (!this.rawData().booleanValue()) {
            taxa.append("###Taxa Names###\n");
        }
        switch (this.myFileType) {
            case GENOTYPE: 
            case TBT: {
                List<String> myTaxaList = HDF5Utils.getAllTaxaNames(this.h5reader);
                for (String t : myTaxaList) {
                    taxa.append(t + "\n");
                }
                break;
            }
            default: {
                taxa.append("(not applicable for this file type)\n");
            }
        }
        this.outputWriter.append(taxa.toString());
    }

    private void writeTagSequences() throws IOException {
        StringBuilder tags = new StringBuilder();
        if (!this.rawData().booleanValue()) {
            tags.append("###Tag Sequences###\n");
        }
        switch (this.myFileType) {
            case TBT: 
            case TOPM: {
                long[][] myTags = HDF5Utils.getTags(this.h5reader);
                for (int i = 0; i < myTags.length; ++i) {
                    tags.append(BaseEncoder.getSequenceFromLong(myTags[i]) + "\n");
                }
                break;
            }
            default: {
                tags.append("(not applicable for this file type)\n");
            }
        }
        this.outputWriter.append(tags.toString());
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a TASSEL-generated HDF5 file and prints out a set of summary data depending on which command-line flags are passed to it. It is meant to allow quick retrieval of certain basic data (taxa names, site count, etc.) that are not easily available without operations that could take considerable time (e.g., a genotype summary report). This plugin currently supports Genotype, TOPM (tags on physical map), andTBT (tags by taxa) files. (Note that the implementation of TOPM and TBT formats in HDF5 is still ongoing, so this plugin may not work on them.)\n";
    }

    public HDF5SummaryPlugin inputFile(String filename) {
        this.inputFile = new PluginParameter<String>(this.inputFile, filename);
        return this;
    }

    public HDF5SummaryPlugin outputFile(String filename) {
        this.outputFile = new PluginParameter<String>(this.outputFile, filename);
        return this;
    }

    public HDF5SummaryPlugin printAll(Boolean value) {
        this.printAll = new PluginParameter<Boolean>(this.printAll, value);
        return this;
    }

    public HDF5SummaryPlugin taxaCount(Boolean value) {
        this.taxaCount = new PluginParameter<Boolean>(this.taxaCount, value);
        return this;
    }

    public HDF5SummaryPlugin taxaNames(Boolean value) {
        this.taxaNames = new PluginParameter<Boolean>(this.taxaNames, value);
        return this;
    }

    public HDF5SummaryPlugin siteCount(Boolean value) {
        this.siteCount = new PluginParameter<Boolean>(this.siteCount, value);
        return this;
    }

    public HDF5SummaryPlugin siteNames(Boolean value) {
        this.siteNames = new PluginParameter<Boolean>(this.siteNames, value);
        return this;
    }

    public HDF5SummaryPlugin hasDepth(Boolean value) {
        this.hasDepth = new PluginParameter<Boolean>(this.hasDepth, value);
        return this;
    }

    public HDF5SummaryPlugin rawData(Boolean value) {
        this.rawData = new PluginParameter<Boolean>(this.rawData, value);
        return this;
    }

    public String inputFile() {
        return this.inputFile.value();
    }

    public String outputFile() {
        return this.outputFile.value();
    }

    public Boolean printAll() {
        return this.printAll.value();
    }

    public Boolean taxaCount() {
        return this.taxaCount.value();
    }

    public Boolean taxaNames() {
        return this.taxaNames.value();
    }

    public Boolean siteCount() {
        return this.siteCount.value();
    }

    public Boolean siteNames() {
        return this.siteNames.value();
    }

    public Boolean tagCount() {
        return this.tagCount.value();
    }

    public Boolean tagSeqs() {
        return this.tagSeqs.value();
    }

    public Boolean hasDepth() {
        return this.hasDepth.value();
    }

    public Boolean rawData() {
        return this.rawData.value();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "HDF5 Summary";
    }

    @Override
    public String getToolTipText() {
        return "HDF5 Summary";
    }

    private static enum H5FileType {
        GENOTYPE,
        TOPM,
        TBT,
        UNKNOWN;

    }
}

