/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.MaskMatrixBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class MaskGenotypePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MaskGenotypePlugin.class);
    private PluginParameter<Double> myPercentageMasked = new PluginParameter.Builder<Double>("percentageMasked", 0.01, Double.class).range((Range<Comparable<Double>>)Range.openClosed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("Percentage of genotypes (not already unknown) to mask.").build();
    private PluginParameter<Integer> myMinDepth = new PluginParameter.Builder<Integer>("minDepth", 0, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).description("Minimum depth required before masking.").build();

    public MaskGenotypePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> data = input.getDataOfType(GenotypeTable.class);
        if (data.size() != 1) {
            throw new IllegalArgumentException("MaskGenotypePlugin: preProcessParameters: must input 1 GenotypeTable.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        Datum inputDatum = input.getDataOfType(GenotypeTable.class).get(0);
        GenotypeTable original = (GenotypeTable)inputDatum.getData();
        if (this.minDepth() > 0 && !original.hasDepth()) {
            throw new IllegalArgumentException("MaskGenotypePlugin: processData: input doesn't have depth information and you set minimum depth to " + this.minDepth());
        }
        MaskMatrixBuilder builder = MaskMatrixBuilder.getInstance(original.numberOfTaxa(), original.numberOfSites(), true);
        long numGenotypesEligibleToMask = this.markEligibleGenotypes(builder, original);
        if (numGenotypesEligibleToMask == 0L) {
            DialogUtils.showWarning("No Genotypes match your criteria to be masked.", this.getParentFrame());
        }
        long numberActuallyMasked = builder.reduceMaskTo(this.percentageMasked());
        myLogger.info((Object)("Number of Genotypes Masked: " + numberActuallyMasked));
        GenotypeTable result = GenotypeTableBuilder.getInstance(original, builder.build());
        Datum genotype = new Datum(inputDatum.getName() + "_Masked", result, null);
        return new DataSet(genotype, (Plugin)this);
    }

    private long markEligibleGenotypes(MaskMatrixBuilder builder, GenotypeTable orig) {
        if (orig.genotypeMatrix().isSiteOptimized()) {
            return this.siteMarkEligibleGenotypes(builder, orig);
        }
        return this.taxaMarkEligibleGenotypes(builder, orig);
    }

    private long siteMarkEligibleGenotypes(MaskMatrixBuilder builder, GenotypeTable orig) {
        GenotypeCallTable origCalls = orig.genotypeMatrix();
        int numTaxa = origCalls.numberOfTaxa();
        int numSites = origCalls.numberOfSites();
        myLogger.info((Object)("Number of taxa: " + numTaxa));
        myLogger.info((Object)("Number of sites: " + numSites));
        myLogger.info((Object)("Number of genotypes: " + (long)numTaxa * (long)numSites));
        long numGenotypesEligibleToMask = 0L;
        if (this.minDepth() > 0) {
            AlleleDepth depth = orig.depth();
            for (int s = 0; s < numSites; ++s) {
                byte[] genotypes = origCalls.genotypeForAllTaxa(s);
                for (int t = 0; t < numTaxa; ++t) {
                    if (genotypes[t] == -1) continue;
                    byte[] alleles = GenotypeTableUtils.getDiploidValues(genotypes[t]);
                    int currentDepth = 0;
                    if (alleles[0] < 6) {
                        currentDepth = depth.value(t, s, AlleleDepth.ALLELE_DEPTH_TYPES[alleles[0]]);
                    }
                    if (alleles[1] < 6) {
                        currentDepth += depth.value(t, s, AlleleDepth.ALLELE_DEPTH_TYPES[alleles[1]]);
                    }
                    if (currentDepth < this.minDepth()) continue;
                    builder.set(t, s);
                    ++numGenotypesEligibleToMask;
                }
            }
        } else {
            for (int s = 0; s < numSites; ++s) {
                byte[] genotypes = origCalls.genotypeForAllTaxa(s);
                for (int t = 0; t < numTaxa; ++t) {
                    if (genotypes[t] == -1) continue;
                    builder.set(t, s);
                    ++numGenotypesEligibleToMask;
                }
            }
        }
        myLogger.info((Object)("Number of genotypes eligible to mask: " + numGenotypesEligibleToMask));
        return numGenotypesEligibleToMask;
    }

    private long taxaMarkEligibleGenotypes(MaskMatrixBuilder builder, GenotypeTable orig) {
        GenotypeCallTable origCalls = orig.genotypeMatrix();
        int numTaxa = origCalls.numberOfTaxa();
        int numSites = origCalls.numberOfSites();
        myLogger.info((Object)("Number of taxa: " + numTaxa));
        myLogger.info((Object)("Number of sites: " + numSites));
        myLogger.info((Object)("Number of genotypes: " + (long)numTaxa * (long)numSites));
        long numGenotypesEligibleToMask = 0L;
        if (this.minDepth() > 0) {
            AlleleDepth depth = orig.depth();
            for (int t = 0; t < numTaxa; ++t) {
                byte[] genotypes = origCalls.genotypeForAllSites(t);
                for (int s = 0; s < numSites; ++s) {
                    if (genotypes[s] == -1) continue;
                    byte[] alleles = GenotypeTableUtils.getDiploidValues(genotypes[s]);
                    int currentDepth = 0;
                    if (alleles[0] < 6) {
                        currentDepth = depth.value(t, s, AlleleDepth.ALLELE_DEPTH_TYPES[alleles[0]]);
                    }
                    if (alleles[1] < 6) {
                        currentDepth += depth.value(t, s, AlleleDepth.ALLELE_DEPTH_TYPES[alleles[1]]);
                    }
                    if (currentDepth < this.minDepth()) continue;
                    builder.set(t, s);
                    ++numGenotypesEligibleToMask;
                }
            }
        } else {
            for (int t = 0; t < numTaxa; ++t) {
                byte[] genotypes = origCalls.genotypeForAllSites(t);
                for (int s = 0; s < numSites; ++s) {
                    if (genotypes[s] == -1) continue;
                    builder.set(t, s);
                    ++numGenotypesEligibleToMask;
                }
            }
        }
        myLogger.info((Object)("Number of genotypes eligible to mask: " + numGenotypesEligibleToMask));
        return numGenotypesEligibleToMask;
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public Double percentageMasked() {
        return this.myPercentageMasked.value();
    }

    public MaskGenotypePlugin percentageMasked(Double value) {
        this.myPercentageMasked = new PluginParameter<Double>(this.myPercentageMasked, value);
        return this;
    }

    public Integer minDepth() {
        return this.myMinDepth.value();
    }

    public MaskGenotypePlugin minDepth(Integer value) {
        this.myMinDepth = new PluginParameter<Integer>(this.myMinDepth, value);
        return this;
    }

    @Override
    public String getToolTipText() {
        return "Mask Genotype";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MaskGenotypePlugin.class.getResource("/net/maizegenetics/analysis/images/mask.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Mask Genotype";
    }
}

