/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\tH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0007\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/maizegenetics/analysis/data/MeanR2FromLDPlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "intervalFile", "Lnet/maizegenetics/plugindef/PluginParameter;", "", "kotlin.jvm.PlatformType", "ldResultFile", "myLogger", "Lorg/apache/log4j/Logger;", "output", "getButtonName", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "value", "intervalMap", "Lcom/google/common/collect/RangeMap;", "Lnet/maizegenetics/dna/map/Position;", "Lnet/maizegenetics/analysis/data/MeanR2FromLDPlugin$AccumulateR2;", "processData", "Lnet/maizegenetics/plugindef/DataSet;", "input", "AccumulateR2", "tassel"})
public final class MeanR2FromLDPlugin
extends AbstractPlugin {
    private final Logger myLogger;
    private PluginParameter<String> intervalFile;
    private PluginParameter<String> ldResultFile;
    private PluginParameter<String> output;

    public MeanR2FromLDPlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        this.myLogger = Logger.getLogger(MeanR2FromLDPlugin.class);
        this.intervalFile = new PluginParameter.Builder<String>("intervals", null, String.class).description("Interval File.").inFile().required(true).build();
        this.ldResultFile = new PluginParameter.Builder<String>("ldResultFile", null, String.class).description("LD Output File.").inFile().required(true).build();
        this.output = new PluginParameter.Builder<String>("output", null, String.class).description("Output Mean R2 Summary.").outFile().required(true).build();
    }

    public /* synthetic */ MeanR2FromLDPlugin(Frame frame, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(frame, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DataSet processData(@Nullable DataSet input) {
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        RangeMap<Position, AccumulateR2> intervalMap = this.intervalMap(this.intervalFile());
        Closeable closeable = Utils.getBufferedReader(this.ldResultFile());
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"getBufferedReader(ldResultFile())");
        Iterable $this$map$iv = CollectionsKt.drop((Iterable)TextStreamsKt.readLines((Reader)closeable), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"\t"};
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)Position.of((String)it.get(0), Integer.parseInt((String)it.get(1))), (Object)Double.parseDouble((String)it.get(13))));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !Double.isNaN(((Number)it.getSecond()).doubleValue());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccumulateR2 accumulateR2;
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            if ((AccumulateR2)intervalMap.get((Comparable)it2.getFirst()) == null) continue;
            boolean bl3 = false;
            accumulateR2.setR2Total(accumulateR2.getR2Total() + ((Number)it2.getSecond()).doubleValue());
            int n = accumulateR2.getR2Count();
            accumulateR2.setR2Count(n + 1);
        }
        closeable = Utils.getBufferedWriter(this.output());
        Throwable throwable = null;
        try {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            writer.write("seqid,start,end,rr_id,average_r2_ld\n");
            Map it2 = intervalMap.asMapOfRanges();
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"intervalMap.asMapOfRanges()");
            boolean $i$f$map2 = false;
            element$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator bl3 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (bl3.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = bl3.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add((AccumulateR2)it3.getValue());
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AccumulateR2 it4 = (AccumulateR2)element$iv;
                boolean bl5 = false;
                writer.write(it4.getChr());
                writer.write(",");
                writer.write(String.valueOf(it4.getStart()));
                writer.write(",");
                writer.write(String.valueOf(it4.getEnd()));
                writer.write(",");
                writer.write(it4.getId());
                writer.write(",");
                writer.write(it4.getR2Count() == 0 ? "0" : String.valueOf(it4.getR2Total() / (double)it4.getR2Count()));
                writer.write("\n");
            }
            iterable = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }

    @NotNull
    public final RangeMap<Position, AccumulateR2> intervalMap(@NotNull String intervalFile) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)intervalFile, (String)"intervalFile");
        ImmutableRangeMap.Builder intervalMapBuilder = new ImmutableRangeMap.Builder();
        BufferedReader bufferedReader = Utils.getBufferedReader(intervalFile);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getBufferedReader(intervalFile)");
        Iterable $this$filter$iv = TextStreamsKt.readLines((Reader)bufferedReader);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it, (String)"seqnames", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)Range.closed((Comparable)Position.of((String)it.get(0), Integer.parseInt((String)it.get(1))), (Comparable)Position.of((String)it.get(0), Integer.parseInt((String)it.get(2)))), (Object)new AccumulateR2((String)it.get(3), (String)it.get(0), Integer.parseInt((String)it.get(1)), Integer.parseInt((String)it.get(2)), 0.0, 0, 48, null)));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            intervalMapBuilder.put((Range)it2.getFirst(), it2.getSecond());
        }
        bufferedReader = intervalMapBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"intervalMapBuilder.build()");
        return (RangeMap)bufferedReader;
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Mean R2 From LD";
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Mean R2 From LD";
    }

    @NotNull
    public final String intervalFile() {
        String string = this.intervalFile.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intervalFile.value()");
        return string;
    }

    @NotNull
    public final MeanR2FromLDPlugin intervalFile(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.intervalFile = new PluginParameter<String>(this.intervalFile, value);
        return this;
    }

    @NotNull
    public final String ldResultFile() {
        String string = this.ldResultFile.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ldResultFile.value()");
        return string;
    }

    @NotNull
    public final MeanR2FromLDPlugin ldResultFile(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.ldResultFile = new PluginParameter<String>(this.ldResultFile, value);
        return this;
    }

    @NotNull
    public final String output() {
        String string = this.output.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.value()");
        return string;
    }

    @NotNull
    public final MeanR2FromLDPlugin output(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.output = new PluginParameter<String>(this.output, value);
        return this;
    }

    public MeanR2FromLDPlugin() {
        this(null, false, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006%"}, d2={"Lnet/maizegenetics/analysis/data/MeanR2FromLDPlugin$AccumulateR2;", "", "id", "", "chr", "start", "", "end", "r2Total", "", "r2Count", "(Ljava/lang/String;Ljava/lang/String;IIDI)V", "getChr", "()Ljava/lang/String;", "getEnd", "()I", "getId", "getR2Count", "setR2Count", "(I)V", "getR2Total", "()D", "setR2Total", "(D)V", "getStart", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "tassel"})
    public static final class AccumulateR2 {
        @NotNull
        private final String id;
        @NotNull
        private final String chr;
        private final int start;
        private final int end;
        private double r2Total;
        private int r2Count;

        public AccumulateR2(@NotNull String id, @NotNull String chr, int start, int end, double r2Total, int r2Count) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)chr, (String)"chr");
            this.id = id;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.r2Total = r2Total;
            this.r2Count = r2Count;
        }

        public /* synthetic */ AccumulateR2(String string, String string2, int n, int n2, double d, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x10) != 0) {
                d = 0.0;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            this(string, string2, n, n2, d, n3);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getChr() {
            return this.chr;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final double getR2Total() {
            return this.r2Total;
        }

        public final void setR2Total(double d) {
            this.r2Total = d;
        }

        public final int getR2Count() {
            return this.r2Count;
        }

        public final void setR2Count(int n) {
            this.r2Count = n;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.chr;
        }

        public final int component3() {
            return this.start;
        }

        public final int component4() {
            return this.end;
        }

        public final double component5() {
            return this.r2Total;
        }

        public final int component6() {
            return this.r2Count;
        }

        @NotNull
        public final AccumulateR2 copy(@NotNull String id, @NotNull String chr, int start, int end, double r2Total, int r2Count) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)chr, (String)"chr");
            return new AccumulateR2(id, chr, start, end, r2Total, r2Count);
        }

        public static /* synthetic */ AccumulateR2 copy$default(AccumulateR2 accumulateR2, String string, String string2, int n, int n2, double d, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = accumulateR2.id;
            }
            if ((n4 & 2) != 0) {
                string2 = accumulateR2.chr;
            }
            if ((n4 & 4) != 0) {
                n = accumulateR2.start;
            }
            if ((n4 & 8) != 0) {
                n2 = accumulateR2.end;
            }
            if ((n4 & 0x10) != 0) {
                d = accumulateR2.r2Total;
            }
            if ((n4 & 0x20) != 0) {
                n3 = accumulateR2.r2Count;
            }
            return accumulateR2.copy(string, string2, n, n2, d, n3);
        }

        @NotNull
        public String toString() {
            return "AccumulateR2(id=" + this.id + ", chr=" + this.chr + ", start=" + this.start + ", end=" + this.end + ", r2Total=" + this.r2Total + ", r2Count=" + this.r2Count + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.chr.hashCode();
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + Double.hashCode(this.r2Total);
            result = result * 31 + Integer.hashCode(this.r2Count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AccumulateR2)) {
                return false;
            }
            AccumulateR2 accumulateR2 = (AccumulateR2)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)accumulateR2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chr, (Object)accumulateR2.chr)) {
                return false;
            }
            if (this.start != accumulateR2.start) {
                return false;
            }
            if (this.end != accumulateR2.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.r2Total, (Object)accumulateR2.r2Total)) {
                return false;
            }
            return this.r2Count == accumulateR2.r2Count;
        }
    }
}

