/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class MergeAlignmentsSameSitesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeAlignmentsSameSitesPlugin.class);
    private static final char DELIMITER = '\t';
    private static final Pattern DELIMITER_PATTERN = Pattern.compile(String.valueOf('\t'));
    private List<String> myInputFiles;
    private String myOutputFile;

    public MergeAlignmentsSameSitesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        if (this.myInputFiles == null || this.myInputFiles.size() < 2) {
            myLogger.warn((Object)"performFunction: Must set at least two hapmap alignment files.");
            return null;
        }
        if (this.myOutputFile == null || this.myOutputFile.length() == 0) {
            myLogger.warn((Object)"performFunction: Must set an output file.");
            return null;
        }
        int numInputs = this.myInputFiles.size();
        BufferedReader[] readers = new BufferedReader[numInputs];
        try (BufferedWriter bw = Utils.getBufferedWriter(Utils.addSuffixIfNeeded(this.myOutputFile, ".hmp.txt"));){
            int i;
            String[] headers = new String[numInputs];
            for (i = 0; i < numInputs; ++i) {
                readers[i] = Utils.getBufferedReader(this.myInputFiles.get(i));
                headers[i] = readers[i].readLine();
                while (headers[i].startsWith("##")) {
                    bw.write(headers[i]);
                    bw.write("\n");
                    headers[i] = readers[i].readLine();
                }
            }
            this.writeHeader(bw);
            for (i = 0; i < numInputs; ++i) {
                int index = Utils.findNthOccurrenceInString(headers[i], '\t', 11);
                bw.write(headers[i].substring(index));
            }
            bw.write("\n");
            headers = null;
            String[] current = new String[numInputs];
            int line = 1;
            while ((current[0] = readers[0].readLine()) != null) {
                ++line;
                int firstIndex = Utils.findNthOccurrenceInString(current[0], '\t', 11);
                String[] firstHeader = DELIMITER_PATTERN.split(current[0].substring(0, firstIndex));
                bw.write(current[0]);
                for (int i2 = 1; i2 < numInputs; ++i2) {
                    current[i2] = readers[i2].readLine();
                    int currentIndex = Utils.findNthOccurrenceInString(current[i2], '\t', 11);
                    String[] currentHeader = DELIMITER_PATTERN.split(current[i2].substring(0, currentIndex));
                    if (!firstHeader[0].equals(currentHeader[0])) {
                        throw new IllegalStateException("MergeAlignmentsSameSitesPlugin: performFunction: Site Name does not match line: " + line + "  first: " + firstHeader[0] + "  current: " + currentHeader[0]);
                    }
                    if (!firstHeader[2].equals(currentHeader[2])) {
                        throw new IllegalStateException("MergeAlignmentsSameSitesPlugin: performFunction: Chromosome does not match line: " + line + "  first: " + firstHeader[2] + "  current: " + currentHeader[2]);
                    }
                    if (!firstHeader[3].equals(currentHeader[3])) {
                        throw new IllegalStateException("MergeAlignmentsSameSitesPlugin: performFunction: Physical Position does not match line: " + line + "  first: " + firstHeader[3] + "  current: " + currentHeader[3]);
                    }
                    bw.write(current[i2].substring(currentIndex));
                }
                bw.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            for (int i = 0; i < readers.length; ++i) {
                try {
                    readers[i].close();
                    continue;
                }
                catch (Exception exception) {}
            }
            this.fireProgress(100);
        }
        return null;
    }

    private void writeHeader(BufferedWriter bw) {
        try {
            bw.write("rs#");
            bw.write(9);
            bw.write("alleles");
            bw.write(9);
            bw.write("chrom");
            bw.write(9);
            bw.write("pos");
            bw.write(9);
            bw.write("strand");
            bw.write(9);
            bw.write("assembly#");
            bw.write(9);
            bw.write("center");
            bw.write(9);
            bw.write("protLSID");
            bw.write(9);
            bw.write("assayLSID");
            bw.write(9);
            bw.write("panelLSID");
            bw.write(9);
            bw.write("QCcode");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInputFiles(List<String> files) {
        this.myInputFiles = new ArrayList<String>(files);
    }

    public void setOutputFile(String filename) {
        this.myOutputFile = filename;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Merge";
    }

    @Override
    public String getToolTipText() {
        return "Merge Alignments Same Sites";
    }
}

