/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.MaskMatrixBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class SetLowDepthGenosToMissingPlugin
extends AbstractPlugin {
    private PluginParameter<Integer> minDepth = new PluginParameter.Builder<Integer>("minDepth", null, Integer.class).guiName("minimum genotype depth").required(true).description("Minimum depth, below which genotypes are set to missing. Must be between 2 and 127, inclusive.").range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(127))).build();
    private static final Logger myLogger = Logger.getLogger(SetLowDepthGenosToMissingPlugin.class);
    private GenotypeTable inputGenotypes = null;
    private String inputGenosName = null;

    @Override
    public String pluginDescription() {
        return "Sets each genotype in the input genotypes to missing if the underlying allelic depth is below a specified minimum.";
    }

    public SetLowDepthGenosToMissingPlugin() {
        super(null, false);
    }

    public SetLowDepthGenosToMissingPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("SetLowDepathGenotypesToMissingPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        this.inputGenosName = genotypeTables.get(0).getName();
        myLogger.info((Object)("\n" + this.pluginDescription() + "\n"));
        myLogger.info((Object)("Input genotype name: " + this.inputGenosName));
        if (genotypeTables.size() == 1) {
            this.inputGenotypes = (GenotypeTable)genotypeTables.get(0).getData();
            if (!this.inputGenotypes.hasDepth()) {
                throw new IllegalArgumentException("SetLowDepthGenotypesToMissingPlugin: preProcessParameters: Please select a Genotype Table with allele depth information.");
            }
        } else {
            throw new IllegalArgumentException("SetLowDepthGenotypesToMissingPlugin: preProcessParameters: Please select one Genotype Table.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        int numberOfSites = this.inputGenotypes.numberOfSites();
        MaskMatrixBuilder mgtb = MaskMatrixBuilder.getInstance(this.inputGenotypes.numberOfTaxa(), this.inputGenotypes.numberOfSites(), true);
        int nGenosSetToMissing = 0;
        int nOrigNonMissing = 0;
        for (int siteIndex = 0; siteIndex < numberOfSites; ++siteIndex) {
            nOrigNonMissing += this.inputGenotypes.totalNonMissingForSite(siteIndex);
            int[][] allelesByFreq = this.inputGenotypes.allelesSortedByFrequency(siteIndex);
            int numAlleles = allelesByFreq[0].length;
            int[] allelesAtSite = new int[numAlleles];
            for (int alleleIndex = 0; alleleIndex < numAlleles; ++alleleIndex) {
                allelesAtSite[alleleIndex] = allelesByFreq[0][alleleIndex];
            }
            for (Taxon inTaxon : this.inputGenotypes.taxa()) {
                int taxonIndex = this.inputGenotypes.taxa().indexOf(inTaxon);
                int[] alleleDepths = this.inputGenotypes.depthForAlleles(taxonIndex, siteIndex);
                int depthSum = 0;
                for (int allele : allelesAtSite) {
                    depthSum += alleleDepths[allele];
                }
                if (depthSum >= this.minDepth()) continue;
                mgtb.set(taxonIndex, siteIndex);
                ++nGenosSetToMissing;
            }
        }
        String outGenosName = this.inputGenosName + "MinDepth" + this.minDepth();
        GenotypeTable outGenos = GenotypeTableBuilder.getInstance(this.inputGenotypes, mgtb.build());
        double percentOfTotalSetToMissing = 100.0 * (double)nGenosSetToMissing / (double)(numberOfSites * this.inputGenotypes.numberOfTaxa());
        double percentOfNonMissingSetToMissing = 100.0 * (double)nGenosSetToMissing / (double)nOrigNonMissing;
        myLogger.info((Object)("\n" + nGenosSetToMissing + " genotypes with a depth less than " + this.minDepth() + " were set to missing \n   = " + String.format("%,.2f", percentOfTotalSetToMissing) + "% of the original genotypes (nSites x nSamples), or " + String.format("%,.2f", percentOfNonMissingSetToMissing) + "% of the original nonMissing genotypes.\n"));
        return new DataSet(new Datum(outGenosName, outGenos, null), null);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SetLowDepthGenosToMissingPlugin.class.getResource("/net/maizegenetics/analysis/images/lowDepthToMissing.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "SetLowDepthGenosToMissing";
    }

    @Override
    public String getToolTipText() {
        return "Set genotypes below a minimum depth to missing";
    }

    @Override
    public String getCitation() {
        return "Christopher Bottoms, Jeff Glaubitz (2015) TASSEL Hackathon Oct 2015";
    }

    public GenotypeTable runPlugin(GenotypeTable inputGenos) {
        DataSet input = new DataSet(new Datum("inputGenotypes", inputGenos, null), null);
        return this.runPlugin(input);
    }

    private GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public Integer minDepth() {
        return this.minDepth.value();
    }

    public SetLowDepthGenosToMissingPlugin minDepth(Integer value) {
        this.minDepth = new PluginParameter<Integer>(this.minDepth, value);
        return this;
    }
}

