/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.DifferenceGenotypeCallTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class SubtractGenotypesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SubtractGenotypesPlugin.class);
    private PluginParameter<String> myHybridFile = new PluginParameter.Builder<String>("hybridFile", null, String.class).description("Three column tab-delimited file defining parent crosses. Columns are hybrid, firstParent, secondParent. The second parent will be imputed from the hybrid by subtracting the first parent, which should be homozygous.").required(true).inFile().build();

    public SubtractGenotypesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> data = input.getDataOfType(GenotypeTable.class);
        if (data.size() != 1) {
            throw new IllegalArgumentException("SubtractGenotypesPlugin: preProcessParameters: must input 1 GenotypeTable.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSet processData(DataSet input) {
        Datum data = input.getDataOfType(GenotypeTable.class).get(0);
        GenotypeTable genotypeTable = (GenotypeTable)data.getData();
        TaxaList origTaxa = genotypeTable.taxa();
        TaxaListBuilder taxaBuilder = new TaxaListBuilder();
        try (BufferedReader reader = Utils.getBufferedReader(this.myHybridFile.value());){
            ArrayList<Integer> hybrids = new ArrayList<Integer>();
            ArrayList<Integer> parents = new ArrayList<Integer>();
            int lineNum = 1;
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = line.trim().split("\t");
                if (tokens.length != 3) {
                    throw new IllegalArgumentException("SubtractGenotypePlugin: processData: a hybrid and two parents per line in file: " + this.myHybridFile.value() + ". Problem on line: " + lineNum);
                }
                int firstIndex = origTaxa.indexOf(tokens[0]);
                int secondIndex = origTaxa.indexOf(tokens[1]);
                if (firstIndex == -1) {
                    myLogger.warn((Object)("processData: line: " + lineNum + " taxon name: " + tokens[0] + " not in the genotype."));
                } else if (secondIndex == -1) {
                    myLogger.warn((Object)("processData: line: " + lineNum + " taxon name: " + tokens[1] + " not in the genotype."));
                } else {
                    hybrids.add(firstIndex);
                    parents.add(secondIndex);
                    taxaBuilder.add(new Taxon(tokens[2].trim()));
                }
                line = reader.readLine();
                ++lineNum;
            }
            GenotypeTable result = GenotypeTableBuilder.getInstance(new DifferenceGenotypeCallTable(genotypeTable.genotypeMatrix(), hybrids, parents), genotypeTable.positions(), taxaBuilder.build());
            DataSet dataSet = new DataSet(new Datum(data.getName() + "_ParentsBySubtraction", result, null), (Plugin)this);
            return dataSet;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("SubtractGenotypesPlugin: processData: problem reading hybrid file: " + this.myHybridFile.value());
        }
    }

    public String hybridFile() {
        return this.myHybridFile.value();
    }

    public SubtractGenotypesPlugin hybridFile(String filename) {
        this.myHybridFile = new PluginParameter<String>(this.myHybridFile, filename);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SubtractGenotypesPlugin.class.getResource("/net/maizegenetics/analysis/images/hybrid.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Subtract Genotypes";
    }

    @Override
    public String getToolTipText() {
        return "Subtract Parent from Hybrid";
    }
}

