/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.ProgressListener;
import org.apache.log4j.Logger;

public class IBSDistanceMatrix3Alleles {
    private static final Logger myLogger = Logger.getLogger(IBSDistanceMatrix3Alleles.class);
    private static final long TRUE_TRUE_LONG = 4398048608257L;
    private static final long TRUE_FALSE_LONG = 1L;
    private static final long FALSE_TRUE_LONG = 0x200000L;
    private static final long FALSE_FALSE_LONG = 0L;
    private static long[] PRECALCULATED_COUNTS = null;
    private static final byte[] PRECALCULATED_ENCODINGS;
    private static final int NUM_CORES_TO_USE;
    private static int myNumSitesProcessed;
    private static final int MAX_NUMBER_20_BITS = 1048575;

    private IBSDistanceMatrix3Alleles() {
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype) {
        return IBSDistanceMatrix3Alleles.getInstance(genotype, 0, false, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, ProgressListener listener) {
        return IBSDistanceMatrix3Alleles.getInstance(genotype, 0, false, listener);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, int minSiteComp, boolean trueIBS, ProgressListener listener) {
        return IBSDistanceMatrix3Alleles.computeHetBitDistances(genotype, listener, trueIBS, minSiteComp);
    }

    private static DistanceMatrix computeHetBitDistances(GenotypeTable genotype, ProgressListener listener, boolean isTrueIBS, int minSitesComp) {
        int numSeqs = genotype.numberOfTaxa();
        double avgTotalSites = 0.0;
        long time = System.currentTimeMillis();
        Counters temp = new Counters(numSeqs);
        IBSDistanceMatrix3Alleles.stream(genotype, listener).forEach(t -> temp.add((long[])t));
        int[][] counters = temp.myCounters;
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(genotype.taxa());
        long count = 0L;
        for (int i = 0; i < numSeqs; ++i) {
            int index = 0;
            for (int j = i; j < numSeqs; ++j) {
                if (j == i && !isTrueIBS) {
                    builder.set(i, i, 0.0);
                    index += 3;
                    continue;
                }
                int sameCount = counters[i][index++];
                int diffCount = counters[i][index++];
                int hetCount = counters[i][index++];
                long sites = sameCount + diffCount - hetCount;
                double identity = ((double)sameCount - 0.5 * (double)hetCount) / (double)sites;
                double dist = 1.0 - identity;
                if (sites < (long)minSitesComp) {
                    dist = Double.NaN;
                }
                builder.set(i, j, dist);
                avgTotalSites += (double)sites;
                ++count;
            }
        }
        avgTotalSites /= (double)count;
        GeneralAnnotationStorage.Builder annotations = GeneralAnnotationStorage.getBuilder();
        annotations.addAnnotation("Matrix_Type", "IBS_Distance_Matrix");
        annotations.addAnnotation("IBS_Distance_Matrix.NumAlleles", "3");
        annotations.addAnnotation("IBS_Distance_Matrix.TrueIBS", String.valueOf(isTrueIBS));
        annotations.addAnnotation("IBS_Distance_Matrix.AverageTotalSites", String.valueOf(avgTotalSites));
        builder.annotation(annotations.build());
        myLogger.info((Object)("IBSDistanceMatrix3Alleles: computeHetBitDistances time = " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        return builder.build();
    }

    public static double[] computeHetDistances(byte[] first, byte[] second, int minSitesComp) {
        return null;
    }

    protected static void fireProgress(int percent, ProgressListener listener) {
        if (listener != null) {
            listener.progress(percent, null);
        }
    }

    private static Stream<long[]> stream(GenotypeTable genotypes, ProgressListener listener) {
        myNumSitesProcessed = 0;
        return StreamSupport.stream(new IBSSiteSpliterator(genotypes, 0, genotypes.numberOfSites(), listener), true);
    }

    static {
        long[] possibleTerms = new long[32];
        possibleTerms[22] = 1L;
        possibleTerms[20] = 4398048608257L;
        possibleTerms[18] = 4398048608257L;
        possibleTerms[6] = 0x200000L;
        possibleTerms[2] = 0x200000L;
        possibleTerms[0] = 0L;
        possibleTerms[21] = 4398048608257L;
        possibleTerms[17] = 4398048608257L;
        possibleTerms[4] = 4398048608257L;
        possibleTerms[1] = 4398048608257L;
        possibleTerms[5] = 0x200000L;
        possibleTerms[19] = 4398048608257L;
        possibleTerms[3] = 4398048608257L;
        possibleTerms[14] = 1L;
        possibleTerms[10] = 4398048608257L;
        possibleTerms[11] = 4398048608257L;
        possibleTerms[7] = 1L;
        PRECALCULATED_COUNTS = new long[23255];
        for (int i = 0; i < 23255; ++i) {
            int firstCode = i & 0x1F;
            int secondCode = i >>> 5 & 0x1F;
            int thirdCode = i >>> 10 & 0x1F;
            IBSDistanceMatrix3Alleles.PRECALCULATED_COUNTS[i] = possibleTerms[firstCode] + possibleTerms[secondCode] + possibleTerms[thirdCode];
        }
        PRECALCULATED_ENCODINGS = new byte[8];
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[1] = 22;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[3] = 21;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[5] = 19;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[2] = 14;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[6] = 11;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[4] = 7;
        IBSDistanceMatrix3Alleles.PRECALCULATED_ENCODINGS[0] = 0;
        NUM_CORES_TO_USE = TasselPrefs.getMaxThreads();
        myNumSitesProcessed = 0;
    }

    static class IBSSiteSpliterator
    implements Spliterator<long[]> {
        private int myCurrentSite;
        private final int myFence;
        private final GenotypeTable myGenotypes;
        private final int myNumTaxa;
        private final int myNumSites;
        private final ProgressListener myProgressListener;
        private int myMinSitesToProcess;
        private static final int NUM_SITES_PER_BLOCK = 3;

        IBSSiteSpliterator(GenotypeTable genotypes, int currentIndex, int fence, ProgressListener listener) {
            this.myGenotypes = genotypes;
            this.myNumTaxa = this.myGenotypes.numberOfTaxa();
            this.myNumSites = this.myGenotypes.numberOfSites();
            this.myCurrentSite = currentIndex;
            this.myFence = fence;
            this.myProgressListener = listener;
            this.myMinSitesToProcess = this.myNumSites / NUM_CORES_TO_USE;
            if (this.myMinSitesToProcess == 0) {
                this.myMinSitesToProcess = this.myNumSites;
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super long[]> action) {
            int numSitesProcessed = this.myFence - this.myCurrentSite;
            while (this.myCurrentSite < this.myFence) {
                int currentBlockFence = Math.min(this.myCurrentSite + 1048575, this.myFence);
                long[] counts = new long[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
                while (this.myCurrentSite < currentBlockFence) {
                    int[] numSites = new int[1];
                    short[] encodings1 = this.getBlockOfSites(this.myCurrentSite, numSites, currentBlockFence);
                    short[] encodings2 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings3 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings4 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings5 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings6 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    this.myCurrentSite += numSites[0];
                    int index = 0;
                    for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                        if (encodings1[firstTaxa] != 0 || encodings2[firstTaxa] != 0 || encodings3[firstTaxa] != 0 || encodings4[firstTaxa] != 0 || encodings5[firstTaxa] != 0 || encodings6[firstTaxa] != 0) {
                            for (int secondTaxa = firstTaxa; secondTaxa < this.myNumTaxa; ++secondTaxa) {
                                int n = index++;
                                counts[n] = counts[n] + (PRECALCULATED_COUNTS[encodings1[firstTaxa] & encodings1[secondTaxa]] + PRECALCULATED_COUNTS[encodings2[firstTaxa] & encodings2[secondTaxa]] + PRECALCULATED_COUNTS[encodings3[firstTaxa] & encodings3[secondTaxa]] + PRECALCULATED_COUNTS[encodings4[firstTaxa] & encodings4[secondTaxa]] + PRECALCULATED_COUNTS[encodings5[firstTaxa] & encodings5[secondTaxa]] + PRECALCULATED_COUNTS[encodings6[firstTaxa] & encodings6[secondTaxa]]);
                            }
                            continue;
                        }
                        index += this.myNumTaxa - firstTaxa;
                    }
                }
                action.accept((long[])counts);
            }
            myNumSitesProcessed = myNumSitesProcessed + numSitesProcessed;
            IBSDistanceMatrix3Alleles.fireProgress((int)((double)myNumSitesProcessed / (double)this.myNumSites * 100.0), this.myProgressListener);
        }

        private short[] getBlockOfSites(int currentSite, int[] numSites, int currentBlockFence) {
            int currentSiteNum = 0;
            short[] encodings = new short[this.myNumTaxa];
            while (currentSiteNum < 3 && currentSite < currentBlockFence) {
                byte[] genotype = this.myGenotypes.genotypeAllTaxa(currentSite);
                int[][] alleles = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotype);
                int numAlleles = alleles[0].length;
                if (numAlleles != 0) {
                    for (int i = 0; i < this.myNumTaxa; ++i) {
                        byte first = (byte)(genotype[i] & 0xF);
                        byte second = (byte)(genotype[i] >>> 4 & 0xF);
                        int allelePresent = 0;
                        if (alleles[0][0] == first || alleles[0][0] == second) {
                            allelePresent = 1;
                        }
                        if (numAlleles >= 2) {
                            if (alleles[0][1] == first || alleles[0][1] == second) {
                                allelePresent |= 2;
                            }
                            if (numAlleles >= 3 && (alleles[0][2] == first || alleles[0][2] == second)) {
                                allelePresent |= 4;
                            }
                        }
                        encodings[i] = (short)(encodings[i] << 5 | PRECALCULATED_ENCODINGS[allelePresent]);
                    }
                    ++currentSiteNum;
                }
                ++currentSite;
                numSites[0] = numSites[0] + 1;
            }
            return encodings;
        }

        @Override
        public boolean tryAdvance(Consumer<? super long[]> action) {
            if (this.myCurrentSite < this.myFence) {
                long[] counts = new long[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
                int[] numSites = new int[1];
                short[] encodings1 = this.getBlockOfSites(this.myCurrentSite, numSites, this.myFence);
                short[] encodings2 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, this.myFence);
                short[] encodings3 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, this.myFence);
                this.myCurrentSite += numSites[0];
                int index = 0;
                for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                    if (encodings1[firstTaxa] != 0 || encodings2[firstTaxa] != 0 || encodings3[firstTaxa] != 0) {
                        for (int secondTaxa = firstTaxa; secondTaxa < this.myNumTaxa; ++secondTaxa) {
                            int n = index++;
                            counts[n] = counts[n] + (PRECALCULATED_COUNTS[encodings1[firstTaxa] & encodings1[secondTaxa]] + PRECALCULATED_COUNTS[encodings2[firstTaxa] & encodings2[secondTaxa]] + PRECALCULATED_COUNTS[encodings3[firstTaxa] & encodings3[secondTaxa]]);
                        }
                        continue;
                    }
                    index += this.myNumTaxa - firstTaxa;
                }
                action.accept((long[])counts);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<long[]> trySplit() {
            int lo = this.myCurrentSite;
            int mid = lo + this.myMinSitesToProcess;
            if (mid < this.myFence) {
                this.myCurrentSite = mid;
                return new IBSSiteSpliterator(this.myGenotypes, lo, mid, this.myProgressListener);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentSite;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class Counters {
        private final int[][] myCounters;
        private final int myNumTaxa;

        public Counters(int numTaxa) {
            this.myNumTaxa = numTaxa;
            this.myCounters = new int[this.myNumTaxa][];
            for (int i = 0; i < this.myNumTaxa; ++i) {
                this.myCounters[i] = new int[(this.myNumTaxa - i) * 3];
            }
        }

        public synchronized void add(long[] values) {
            int index = 0;
            for (int i = 0; i < this.myNumTaxa; ++i) {
                for (int j = 0; j < this.myCounters[i].length; j += 3) {
                    int[] nArray = this.myCounters[i];
                    int n = j;
                    nArray[n] = nArray[n] + (int)(values[index] & 0x1FFFFFL);
                    int[] nArray2 = this.myCounters[i];
                    int n2 = j + 1;
                    nArray2[n2] = nArray2[n2] + (int)(values[index] >>> 21 & 0x1FFFFFL);
                    int[] nArray3 = this.myCounters[i];
                    int n3 = j + 2;
                    nArray3[n3] = nArray3[n3] + (int)(values[index] >>> 42 & 0x1FFFFFL);
                    ++index;
                }
            }
        }

        public void addAll(Counters counters) {
            int[][] other = counters.myCounters;
            for (int t = 0; t < this.myNumTaxa; ++t) {
                int n = this.myCounters[t].length;
                for (int i = 0; i < n; ++i) {
                    int[] nArray = this.myCounters[t];
                    int n2 = i;
                    nArray[n2] = nArray[n2] + other[t][i];
                }
            }
        }
    }
}

