/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.DominanceNormalizedIBSMatrix;
import net.maizegenetics.analysis.distance.DominanceRelationshipMatrix;
import net.maizegenetics.analysis.distance.EndelmanDistanceMatrix;
import net.maizegenetics.analysis.distance.GCTADistanceMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import org.apache.log4j.Logger;

public class KinshipPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(KinshipPlugin.class);
    private PluginParameter<KINSHIP_METHOD> myMethod = new PluginParameter.Builder<KINSHIP_METHOD>("method", KINSHIP_METHOD.Centered_IBS, KINSHIP_METHOD.class).guiName("Kinship method").range((Comparable<T>[])KINSHIP_METHOD.values()).description("The Centered_IBS (Endelman - previously Scaled_IBS) method produces a kinship matrix that is scaled to give a reasonable estimate of additive genetic variance. Uses algorithm http://www.g3journal.org/content/2/11/1405.full.pdf Equation-13. The Normalized_IBS (Previously GCTA) uses the algorithm published here: http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3014363/pdf/main.pdf.").build();
    private PluginParameter<Integer> myMaxAlleles = new PluginParameter.Builder<Integer>("maxAlleles", 6, Integer.class).description("").range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6))).dependentOnParameter(this.myMethod, new Object[]{KINSHIP_METHOD.Centered_IBS, KINSHIP_METHOD.Dominance_Centered_IBS}).build();
    private PluginParameter<ALGORITHM_VARIATION> myAlgorithmVariation = new PluginParameter.Builder<ALGORITHM_VARIATION>("algorithmVariation", ALGORITHM_VARIATION.Observed_Allele_Freq, ALGORITHM_VARIATION.class).description("").range((Comparable<T>[])ALGORITHM_VARIATION.values()).dependentOnParameter(this.myMethod, new Object[]{KINSHIP_METHOD.Dominance_Centered_IBS}).build();

    public KinshipPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList == null || alignInList.isEmpty()) {
            throw new IllegalArgumentException("KinshipPlugin: Nothing selected. Please select a genotype.");
        }
    }

    @Override
    public void setParameters(String[] args) {
        try {
            int i = 0;
            if (i < args.length && args[i].equals("-method")) {
                if (args[i + 1].equalsIgnoreCase("GCTA")) {
                    args[i + 1] = KINSHIP_METHOD.Normalized_IBS.name();
                    myLogger.warn((Object)"setParameters: Notice GCTA has been changed to Normalized_IBS");
                } else if (args[i + 1].equalsIgnoreCase("Scaled_IBS")) {
                    args[i + 1] = KINSHIP_METHOD.Centered_IBS.name();
                    myLogger.warn((Object)"setParameters: Notice Scaled_IBS has been changed to Centered_IBS");
                } else if (args[i + 1].equalsIgnoreCase("Dominance")) {
                    args[i + 1] = KINSHIP_METHOD.Dominance_Centered_IBS.name();
                    myLogger.warn((Object)"setParameters: Notice Dominance has been changed to Dominance_Centered_IBS");
                }
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        super.setParameters(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataSet processData(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        ArrayList<Datum> result = new ArrayList<Datum>();
        for (Datum current : alignInList) {
            String datasetName = current.getName();
            DistanceMatrix kin = null;
            if (!(current.getData() instanceof GenotypeTable)) throw new IllegalArgumentException("Invalid selection. Can't create kinship matrix from: " + datasetName);
            GenotypeTable myGenotype = (GenotypeTable)current.getData();
            if (this.kinshipMethod() == KINSHIP_METHOD.Centered_IBS) {
                kin = EndelmanDistanceMatrix.getInstance(myGenotype, this.maxAlleles(), this);
            } else if (this.kinshipMethod() == KINSHIP_METHOD.Normalized_IBS) {
                kin = GCTADistanceMatrix.getInstance(myGenotype, this);
            } else if (this.kinshipMethod() == KINSHIP_METHOD.Dominance_Centered_IBS) {
                kin = DominanceRelationshipMatrix.getInstance(myGenotype, this.maxAlleles(), this.algorithmVariation(), this);
            } else {
                if (this.kinshipMethod() != KINSHIP_METHOD.Dominance_Normalized_IBS) throw new IllegalArgumentException("Unknown method to calculate kinship: " + (Object)((Object)this.kinshipMethod()));
                kin = DominanceNormalizedIBSMatrix.getInstance(myGenotype, this);
            }
            if (kin == null) continue;
            StringBuilder comment = new StringBuilder();
            comment.append((Object)this.kinshipMethod());
            if (this.kinshipMethod() == KINSHIP_METHOD.Dominance_Centered_IBS) {
                comment.append("(variation: ");
                comment.append((Object)this.algorithmVariation());
                comment.append(")");
            }
            comment.append(" matrix created from ");
            comment.append(datasetName);
            Datum ds = new Datum((Object)((Object)this.kinshipMethod()) + "_" + datasetName, kin, comment.toString());
            result.add(ds);
        }
        return new DataSet(result, (Plugin)this);
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/Kinship/Kinship";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = KinshipPlugin.class.getResource("/net/maizegenetics/analysis/images/Kin.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Kinship";
    }

    @Override
    public String getToolTipText() {
        return "Calculate kinship from marker data";
    }

    public DistanceMatrix runPlugin(DataSet input) {
        return (DistanceMatrix)this.performFunction(input).getData(0).getData();
    }

    public DistanceMatrix runPlugin(GenotypeTable input) {
        return (DistanceMatrix)this.performFunction(DataSet.getDataSet(input)).getData(0).getData();
    }

    public KINSHIP_METHOD kinshipMethod() {
        return this.myMethod.value();
    }

    public KinshipPlugin kinshipMethod(KINSHIP_METHOD value) {
        this.myMethod = new PluginParameter<KINSHIP_METHOD>(this.myMethod, value);
        return this;
    }

    public Integer maxAlleles() {
        return this.myMaxAlleles.value();
    }

    public KinshipPlugin maxAlleles(Integer value) {
        this.myMaxAlleles = new PluginParameter<Integer>(this.myMaxAlleles, value);
        return this;
    }

    public ALGORITHM_VARIATION algorithmVariation() {
        return this.myAlgorithmVariation.value();
    }

    public KinshipPlugin algorithmVariation(ALGORITHM_VARIATION value) {
        this.myAlgorithmVariation = new PluginParameter<ALGORITHM_VARIATION>(this.myAlgorithmVariation, value);
        return this;
    }

    public static enum ALGORITHM_VARIATION {
        Observed_Allele_Freq,
        Proportion_Heterozygous;

    }

    public static enum KINSHIP_METHOD {
        Centered_IBS,
        Normalized_IBS,
        Dominance_Centered_IBS,
        Dominance_Normalized_IBS;

    }
}

