/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.filter.FilterBySites;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterList;
import net.maizegenetics.dna.snp.FilterSite;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.GenotypePhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class FilterSiteBuilderPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterSiteBuilderPlugin.class);
    private PluginParameter<String> myFilterName = new PluginParameter.Builder<String>(FilterSite.FILTER_SITES_ATTRIBUTES.filterName.name(), "Filter", String.class).description("Filter Name").build();
    private PluginParameter<Integer> mySiteMinCount = new PluginParameter.Builder<Integer>(FilterSite.FILTER_SITES_ATTRIBUTES.siteMinCount.name(), 0, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).description("Site Minimum Count of Alleles not Unknown").build();
    private PluginParameter<Double> mySiteMinAlleleFreq = new PluginParameter.Builder<Double>(FilterSite.FILTER_SITES_ATTRIBUTES.siteMinAlleleFreq.name(), 0.0, Double.class).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("Site Minimum Minor Allele Frequency").build();
    private PluginParameter<Double> mySiteMaxAlleleFreq = new PluginParameter.Builder<Double>(FilterSite.FILTER_SITES_ATTRIBUTES.siteMaxAlleleFreq.name(), 1.0, Double.class).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("Site Maximum Minor Allele Frequency").build();
    private PluginParameter<Double> myMinHeterozygous = new PluginParameter.Builder<Double>(FilterSite.FILTER_SITES_ATTRIBUTES.minHeterozygous.name(), 0.0, Double.class).guiName("Min Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Double> myMaxHeterozygous = new PluginParameter.Builder<Double>(FilterSite.FILTER_SITES_ATTRIBUTES.maxHeterozygous.name(), 1.0, Double.class).guiName("Max Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Boolean> myRemoveMinorSNPStates = new PluginParameter.Builder<Boolean>(FilterSite.FILTER_SITES_ATTRIBUTES.removeMinorSNPStates.name(), false, Boolean.class).guiName("Remove Minor SNP States").description("").build();
    private PluginParameter<Boolean> myRemoveSitesWithIndels = new PluginParameter.Builder<Boolean>(FilterSite.FILTER_SITES_ATTRIBUTES.removeSitesWithIndels.name(), false, Boolean.class).description("Removes sites containing an indel (+ or -)").build();
    private PluginParameter<FilterSite.SITE_RANGE_FILTER_TYPES> mySiteFilter = new PluginParameter.Builder<FilterSite.SITE_RANGE_FILTER_TYPES>(FilterSite.FILTER_SITES_ATTRIBUTES.siteRangeFilterType.name(), FilterSite.SITE_RANGE_FILTER_TYPES.NONE, FilterSite.SITE_RANGE_FILTER_TYPES.class).description("True if filtering by site numbers. False if filtering by chromosome and position").range((Comparable<T>[])FilterSite.SITE_RANGE_FILTER_TYPES.values()).build();
    private PluginParameter<Integer> myStartSite = new PluginParameter.Builder<Integer>(FilterSite.FILTER_SITES_ATTRIBUTES.startSite.name(), 0, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.SITES).description("").build();
    private PluginParameter<Integer> myEndSite = new PluginParameter.Builder<Integer>(FilterSite.FILTER_SITES_ATTRIBUTES.endSite.name(), 0, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.SITES).description("").build();
    private PluginParameter<Chromosome> myStartChr = new PluginParameter.Builder<Chromosome>(FilterSite.FILTER_SITES_ATTRIBUTES.startChr.name(), null, Chromosome.class).dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS).description("").build();
    private PluginParameter<Integer> myStartPos = new PluginParameter.Builder<Integer>(FilterSite.FILTER_SITES_ATTRIBUTES.startPos.name(), null, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).nullable().dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS).description("").build();
    private PluginParameter<Chromosome> myEndChr = new PluginParameter.Builder<Chromosome>(FilterSite.FILTER_SITES_ATTRIBUTES.endChr.name(), null, Chromosome.class).dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS).description("").build();
    private PluginParameter<Integer> myEndPos = new PluginParameter.Builder<Integer>(FilterSite.FILTER_SITES_ATTRIBUTES.endPos.name(), null, Integer.class).range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).nullable().dependentOnParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS).description("").build();
    private PluginParameter<Boolean> myIncludeSites = new PluginParameter.Builder<Boolean>(FilterSite.FILTER_SITES_ATTRIBUTES.includeSites.name(), true, Boolean.class).description("").build();
    private PluginParameter<PositionList> myPositionList = new PluginParameter.Builder<PositionList>(FilterSite.FILTER_SITES_ATTRIBUTES.positionList.name(), null, PositionList.class).description("Filter based on position list. Position list can come from .json, .bed, or any TASSEL supported genotype file.").build();
    private PluginParameter<List> mySiteNamesList = new PluginParameter.Builder<List>(FilterSite.FILTER_SITES_ATTRIBUTES.siteNames.name(), null, List.class).siteNameList().dependentOnParameter(this.myPositionList, "None").description("Filter based on site names.").build();
    private PluginParameter<String> myBedFile = new PluginParameter.Builder<String>(FilterSite.FILTER_SITES_ATTRIBUTES.bedFile.name(), null, String.class).inFile().dependentOnParameter(this.myPositionList, "None").description("Filter based on BED file.").build();
    private PluginParameter<String> myChrPosFile = new PluginParameter.Builder<String>(FilterSite.FILTER_SITES_ATTRIBUTES.chrPosFile.name(), null, String.class).inFile().description("Filter based on list of chromsome / position in file.").build();

    public FilterSiteBuilderPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public FilterSiteBuilderPlugin() {
        this(null, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            return;
        }
        if (this.isInteractive()) {
            List<Datum> filterList = input.getDataOfType(FilterSite.class);
            if (filterList.size() == 1) {
                FilterSite filter = (FilterSite)filterList.get(0).getData();
                this.useFilterValues(filter);
                return;
            }
            List<Datum> genotypeTableList = input.getDataOfType(GenotypeTable.class);
            if (genotypeTableList.size() == 1) {
                GenotypeTable genotypeTable = (GenotypeTable)genotypeTableList.get(0).getData();
                int lastSite = genotypeTable.numberOfSites() - 1;
                this.setParameter(this.myEndSite.cmdLineName(), (Object)lastSite);
                PositionList positions = genotypeTable.positions();
                this.setParameter(this.myStartChr, (Object)positions.chromosome(0));
                this.setParameter(this.myEndChr, (Object)positions.chromosome(lastSite));
                return;
            }
            List<Datum> positionLists = input.getDataOfType(PositionList.class);
            if (positionLists.size() == 1) {
                PositionList positions = (PositionList)positionLists.get(0).getData();
                int lastSite = positions.numberOfSites() - 1;
                this.setParameter(this.myStartChr, (Object)positions.chromosome(0));
                this.setParameter(this.myEndChr, (Object)positions.chromosome(lastSite));
                return;
            }
        } else {
            if (!this.myStartSite.value().equals(this.myStartSite.defaultValue()) || !this.myEndSite.value().equals(this.myEndSite.defaultValue())) {
                this.setParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.SITES);
            }
            if (this.myStartPos.value() != null || this.myStartChr.value() != null || this.myEndPos.value() != null || this.myEndChr.value() != null) {
                this.setParameter(this.mySiteFilter, (Object)FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS);
            }
        }
    }

    @Override
    protected void postProcessParameters() {
        if (this.siteMaxAlleleFreq() < this.siteMinAlleleFreq()) {
            throw new IllegalArgumentException("Site Max. Minor Allele Frequency: " + this.siteMaxAlleleFreq() + " is less than Site Min. Minor Allele Frequency: " + this.siteMinAlleleFreq());
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> phenoGenoTableList;
        Object sites;
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Field field : this.getParameterFields()) {
            PluginParameter current = null;
            try {
                current = (PluginParameter)field.get(this);
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (current == null || (current.value() == null || current.value().equals(current.defaultValue())) && !current.cmdLineName().equals(FilterSite.FILTER_SITES_ATTRIBUTES.filterName.name())) continue;
            values.put(current.cmdLineName(), current.value());
        }
        if (this.siteFilter() == FilterSite.SITE_RANGE_FILTER_TYPES.SITES) {
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startChr.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startPos.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endChr.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endPos.name());
            if (values.get(FilterSite.FILTER_SITES_ATTRIBUTES.startSite.name()) == null) {
                values.put(FilterSite.FILTER_SITES_ATTRIBUTES.startSite.name(), 0);
            }
        } else if (this.siteFilter() == FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS) {
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startSite.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endSite.name());
        } else if (this.siteFilter() == FilterSite.SITE_RANGE_FILTER_TYPES.NONE) {
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startSite.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endSite.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startChr.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.startPos.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endChr.name());
            values.remove(FilterSite.FILTER_SITES_ATTRIBUTES.endPos.name());
        }
        if ((sites = values.get(FilterSite.FILTER_SITES_ATTRIBUTES.siteNames.name())) != null) {
            values.put(FilterSite.FILTER_SITES_ATTRIBUTES.siteNames.name(), sites);
        }
        ArrayList<Datum> result = new ArrayList<Datum>();
        FilterSite filter = new FilterSite(values);
        List<Datum> genotypeTableList = input.getDataOfType(GenotypeTable.class);
        if (genotypeTableList.size() >= 1) {
            for (Datum datum : genotypeTableList) {
                GenotypeTable current = (GenotypeTable)datum.getData();
                GenotypeTable filteredGenotype = FilterBySites.filter(current, filter);
                if (filteredGenotype == null || filteredGenotype.numberOfSites() == 0) {
                    DialogUtils.showWarning("No genotype data remained after filtering: " + datum.getName(), this.getParentFrame());
                    continue;
                }
                if (filteredGenotype != current) {
                    Datum temp = new Datum(datum.getName() + "_" + filter.filterName(), filteredGenotype, null);
                    result.add(temp);
                    GenotypeSummaryPlugin.printSimpleSummary(temp);
                    continue;
                }
                result.add(datum);
                DialogUtils.showWarning("Genotype data unchanged after filtering: " + datum.getName(), this.getParentFrame());
            }
        }
        if ((phenoGenoTableList = input.getDataOfType(GenotypePhenotype.class)).size() >= 1) {
            for (Datum datum : phenoGenoTableList) {
                GenotypePhenotype pheno = (GenotypePhenotype)datum.getData();
                GenotypeTable current = pheno.genotypeTable();
                GenotypeTable filteredGenotype = FilterBySites.filter(current, filter);
                if (filteredGenotype == null || filteredGenotype.numberOfSites() == 0) {
                    DialogUtils.showWarning("No genotype data remained after filtering: " + datum.getName(), this.getParentFrame());
                    continue;
                }
                if (filteredGenotype != current) {
                    GenotypePhenotype resultPheno = new GenotypePhenotypeBuilder().genotype(filteredGenotype).phenotype(pheno.phenotype()).union().build();
                    String name = datum.getName() + "_" + filter.filterName();
                    Datum temp = new Datum(name, resultPheno, null);
                    result.add(temp);
                    GenotypeSummaryPlugin.printSimpleSummary(filteredGenotype, name);
                    continue;
                }
                result.add(datum);
                DialogUtils.showWarning("Genotype data unchanged after filtering: " + datum.getName(), this.getParentFrame());
            }
        }
        result.add(new Datum(filter.filterName(), new FilterList(filter), null));
        return new DataSet(result, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterSiteBuilderPlugin.class.getResource("/net/maizegenetics/analysis/images/FilterNew.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Filter Genotype Table Sites";
    }

    @Override
    public String getToolTipText() {
        return "Filter Genotype Table Sites";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/FilterMenu/FilterSiteBuilderPlugin";
    }

    public FilterSite build() {
        return (FilterSite)this.performFunction(null).getData(0).getData();
    }

    public FilterSiteBuilderPlugin useFilterValues(FilterSite filter) {
        this.setParametersToDefault();
        filter.attributes().entrySet().stream().forEach(attribute -> this.setParameter(((FilterSite.FILTER_SITES_ATTRIBUTES)((Object)((Object)attribute.getKey()))).name(), attribute.getValue()));
        return this;
    }

    public FilterSite runPlugin() {
        return (FilterSite)this.performFunction(null).getData(0).getData();
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getDataOfType(GenotypeTable.class).get(0).getData();
    }

    public GenotypeTable runPlugin(GenotypeTable input) {
        return (GenotypeTable)this.performFunction(DataSet.getDataSet(input)).getDataOfType(GenotypeTable.class).get(0).getData();
    }

    public String filterName() {
        return this.myFilterName.value();
    }

    public FilterSiteBuilderPlugin filterName(String value) {
        this.myFilterName = new PluginParameter<String>(this.myFilterName, value);
        return this;
    }

    public Integer siteMinCount() {
        return this.mySiteMinCount.value();
    }

    public FilterSiteBuilderPlugin siteMinCount(Integer value) {
        this.mySiteMinCount = new PluginParameter<Integer>(this.mySiteMinCount, value);
        return this;
    }

    public Double siteMinAlleleFreq() {
        return this.mySiteMinAlleleFreq.value();
    }

    public FilterSiteBuilderPlugin siteMinAlleleFreq(Double value) {
        this.mySiteMinAlleleFreq = new PluginParameter<Double>(this.mySiteMinAlleleFreq, value);
        return this;
    }

    public Double siteMaxAlleleFreq() {
        return this.mySiteMaxAlleleFreq.value();
    }

    public FilterSiteBuilderPlugin siteMaxAlleleFreq(Double value) {
        this.mySiteMaxAlleleFreq = new PluginParameter<Double>(this.mySiteMaxAlleleFreq, value);
        return this;
    }

    public Double minHeterozygous() {
        return this.myMinHeterozygous.value();
    }

    public FilterSiteBuilderPlugin minHeterozygous(Double value) {
        this.myMinHeterozygous = new PluginParameter<Double>(this.myMinHeterozygous, value);
        return this;
    }

    public Double maxHeterozygous() {
        return this.myMaxHeterozygous.value();
    }

    public FilterSiteBuilderPlugin maxHeterozygous(Double value) {
        this.myMaxHeterozygous = new PluginParameter<Double>(this.myMaxHeterozygous, value);
        return this;
    }

    public Boolean removeMinorSNPStates() {
        return this.myRemoveMinorSNPStates.value();
    }

    public FilterSiteBuilderPlugin removeMinorSNPStates(Boolean value) {
        this.myRemoveMinorSNPStates = new PluginParameter<Boolean>(this.myRemoveMinorSNPStates, value);
        return this;
    }

    public Boolean removeSitesWithIndels() {
        return this.myRemoveSitesWithIndels.value();
    }

    public FilterSiteBuilderPlugin removeSitesWithIndels(Boolean value) {
        this.myRemoveSitesWithIndels = new PluginParameter<Boolean>(this.myRemoveSitesWithIndels, value);
        return this;
    }

    public FilterSite.SITE_RANGE_FILTER_TYPES siteFilter() {
        return this.mySiteFilter.value();
    }

    public FilterSiteBuilderPlugin siteFilter(FilterSite.SITE_RANGE_FILTER_TYPES value) {
        this.mySiteFilter = new PluginParameter<FilterSite.SITE_RANGE_FILTER_TYPES>(this.mySiteFilter, value);
        return this;
    }

    public Integer startSite() {
        return this.myStartSite.value();
    }

    public FilterSiteBuilderPlugin startSite(Integer value) {
        this.myStartSite = new PluginParameter<Integer>(this.myStartSite, value);
        return this;
    }

    public Integer endSite() {
        return this.myEndSite.value();
    }

    public FilterSiteBuilderPlugin endSite(Integer value) {
        this.myEndSite = new PluginParameter<Integer>(this.myEndSite, value);
        return this;
    }

    public Chromosome startChr() {
        return this.myStartChr.value();
    }

    public FilterSiteBuilderPlugin startChr(Chromosome value) {
        this.myStartChr = new PluginParameter<Chromosome>(this.myStartChr, value);
        return this;
    }

    public Integer startPos() {
        return this.myStartPos.value();
    }

    public FilterSiteBuilderPlugin startPos(Integer value) {
        this.myStartPos = new PluginParameter<Integer>(this.myStartPos, value);
        return this;
    }

    public Chromosome endChr() {
        return this.myEndChr.value();
    }

    public FilterSiteBuilderPlugin endChr(Chromosome value) {
        this.myEndChr = new PluginParameter<Chromosome>(this.myEndChr, value);
        return this;
    }

    public Integer endPos() {
        return this.myEndPos.value();
    }

    public FilterSiteBuilderPlugin endPos(Integer value) {
        this.myEndPos = new PluginParameter<Integer>(this.myEndPos, value);
        return this;
    }

    public Boolean includeSites() {
        return this.myIncludeSites.value();
    }

    public FilterSiteBuilderPlugin includeSites(Boolean value) {
        this.myIncludeSites = new PluginParameter<Boolean>(this.myIncludeSites, value);
        return this;
    }

    public PositionList positionList() {
        return this.myPositionList.value();
    }

    public FilterSiteBuilderPlugin positionList(PositionList value) {
        this.myPositionList = new PluginParameter<PositionList>(this.myPositionList, value);
        return this;
    }

    public List<String> siteNamesList() {
        return this.mySiteNamesList.value();
    }

    public FilterSiteBuilderPlugin siteNamesList(List<String> value) {
        this.mySiteNamesList = new PluginParameter<List<String>>((PluginParameter<List<String>>)this.mySiteNamesList, value);
        return this;
    }

    public String bedFile() {
        return this.myBedFile.value();
    }

    public FilterSiteBuilderPlugin bedFile(String value) {
        this.myBedFile = new PluginParameter<String>(this.myBedFile, value);
        return this;
    }

    public String chrPosFile() {
        return this.myChrPosFile.value();
    }

    public FilterSiteBuilderPlugin chrPosFile(String value) {
        this.myChrPosFile = new PluginParameter<String>(this.myChrPosFile, value);
        return this;
    }
}

