/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.gui.SelectFromAvailableSitesDialog;
import net.maizegenetics.gui.SiteNamesAvailableListModel;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class FilterSiteNamePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterSiteNamePlugin.class);
    private int[] mySitesToKeep = null;
    private int[] mySitesToCovariates = null;
    private int[] mySitesToFactors = null;
    private String[] mySiteNamesToKeep = null;
    private String[] mySiteNamesToRemove = null;
    private String[] mySiteNamesToCovariates = null;
    private String[] mySiteNamesToFactors = null;

    public FilterSiteNamePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> inputData = input.getDataOfType(GenotypeTable.class);
            if (inputData.size() != 1) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single alignment.");
                } else {
                    myLogger.error((Object)"performFunction: Please input a single alignment.");
                }
                DataSet dataSet = null;
                return dataSet;
            }
            List<Datum> td = this.processDatum(inputData.get(0), this.isInteractive());
            if (td == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet output = new DataSet(td, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterSiteNamePlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private List<Datum> processDatum(Datum inDatum, boolean isInteractive) {
        GenotypeTable alignment = (GenotypeTable)inDatum.getData();
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        if (isInteractive) {
            SiteNamesAvailableListModel listModel = new SiteNamesAvailableListModel(alignment.positions());
            SelectFromAvailableSitesDialog dialog = new SelectFromAvailableSitesDialog(this.getParentFrame(), "Site Name Filter", listModel);
            dialog.setLocationRelativeTo(this.getParentFrame());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
            for (int[] indices : dialog.listOfSelectedIndices()) {
                this.mySitesToKeep = indices;
                this.addResults(resultList, alignment, inDatum.getName());
                this.mySitesToKeep = null;
            }
            for (int[] indices : dialog.listOfCovariateIndices()) {
                this.mySitesToCovariates = indices;
                this.addResults(resultList, alignment, inDatum.getName());
                this.mySitesToCovariates = null;
            }
            for (int[] indices : dialog.listOfFactorIndices()) {
                this.mySitesToFactors = indices;
                this.addResults(resultList, alignment, inDatum.getName());
                this.mySitesToFactors = null;
            }
            dialog.dispose();
        } else {
            this.addResults(resultList, alignment, inDatum.getName());
        }
        return resultList;
    }

    private void addResults(List<Datum> resultList, GenotypeTable alignment, String datasetName) {
        ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList;
        GenotypeTable result = null;
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            result = FilterGenotypeTable.getInstance(alignment, this.mySitesToKeep);
        } else if (this.mySiteNamesToKeep != null && this.mySiteNamesToKeep.length != 0) {
            result = FilterGenotypeTable.getInstance(alignment, this.mySiteNamesToKeep);
        } else if (this.mySiteNamesToRemove != null && this.mySiteNamesToRemove.length != 0) {
            result = FilterGenotypeTable.getInstanceRemoveSiteNames(alignment, this.mySiteNamesToRemove);
        }
        if (result != null) {
            String theName = datasetName + "_" + result.numberOfSites() + "_Sites";
            String string = "Subset of " + result.numberOfSites() + " from " + datasetName;
            resultList.add(new Datum(theName, result, string));
        }
        if (this.mySiteNamesToCovariates != null) {
            this.mySitesToCovariates = this.siteNumbersFromNames(this.mySiteNamesToCovariates, alignment);
        }
        if (this.mySitesToCovariates != null) {
            typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            for (int site : this.mySitesToCovariates) {
                typeList.add(Phenotype.ATTRIBUTE_TYPE.covariate);
            }
            ArrayList<PhenotypeAttribute> arrayList = new ArrayList<PhenotypeAttribute>();
            arrayList.add(new TaxaAttribute(alignment.taxa()));
            for (int site : this.mySitesToCovariates) {
                arrayList.add(this.convertSiteToCovariate(site, alignment));
            }
            Phenotype phenotype = new PhenotypeBuilder().fromAttributeList(arrayList, typeList).build().get(0);
            String name = "Site_Covariates_" + datasetName;
            StringBuilder commentBuilder = new StringBuilder("Sites as covariates\n");
            commentBuilder.append("from ").append(datasetName).append("\n");
            for (int siteNumber : this.mySitesToCovariates) {
                commentBuilder.append(alignment.siteName(siteNumber)).append("\n");
            }
            resultList.add(new Datum(name, phenotype, commentBuilder.toString()));
        }
        if (this.mySiteNamesToFactors != null) {
            this.mySitesToFactors = this.siteNumbersFromNames(this.mySiteNamesToFactors, alignment);
        }
        if (this.mySitesToFactors != null) {
            typeList = new ArrayList();
            typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            for (int site : this.mySitesToFactors) {
                typeList.add(Phenotype.ATTRIBUTE_TYPE.factor);
            }
            ArrayList<PhenotypeAttribute> arrayList = new ArrayList<PhenotypeAttribute>();
            arrayList.add(new TaxaAttribute(alignment.taxa()));
            for (int site : this.mySitesToFactors) {
                arrayList.add(this.convertSiteToFactor(site, alignment));
            }
            Phenotype phenotype = new PhenotypeBuilder().fromAttributeList(arrayList, typeList).build().get(0);
            String name = "Site_Factors_" + datasetName;
            StringBuilder commentBuilder = new StringBuilder("Sites as factors\n");
            commentBuilder.append("from ").append(datasetName).append("\n");
            for (int siteNumber : this.mySitesToFactors) {
                commentBuilder.append(alignment.siteName(siteNumber)).append("\n");
            }
            resultList.add(new Datum(name, phenotype, commentBuilder.toString()));
        }
    }

    private PhenotypeAttribute convertSiteToCovariate(int site, GenotypeTable geno) {
        byte major = geno.majorAllele(site);
        float sitemean = (float)(geno.majorAlleleFrequency(site) * 2.0);
        int ntaxa = geno.numberOfTaxa();
        float[] siteScore = new float[ntaxa];
        for (int t = 0; t < ntaxa; ++t) {
            byte taxonGeno = geno.genotype(t, site);
            if (taxonGeno == -1) {
                siteScore[t] = sitemean;
                continue;
            }
            siteScore[t] = 0.0f;
            byte[] tgArray = GenotypeTableUtils.getDiploidValues(taxonGeno);
            if (tgArray[0] == major) {
                int n = t;
                siteScore[n] = siteScore[n] + 1.0f;
            }
            if (tgArray[1] != major) continue;
            int n = t;
            siteScore[n] = siteScore[n] + 1.0f;
        }
        return new NumericAttribute(geno.siteName(site), siteScore, new OpenBitSet(ntaxa));
    }

    private PhenotypeAttribute convertSiteToFactor(int site, GenotypeTable geno) {
        int ntaxa = geno.numberOfTaxa();
        Byte unknownByte = new Byte(-1);
        byte[] byteGeno = geno.genotypeAllTaxa(site);
        Map<Byte, Long> genoMap = IntStream.range(0, ntaxa).mapToObj(i -> new Byte(byteGeno[i])).filter(g -> !g.equals(unknownByte)).collect(Collectors.groupingBy(g -> g, Collectors.counting()));
        double totalGenoCount = genoMap.values().stream().mapToInt(v -> v.intValue()).sum();
        double[] freq = genoMap.values().stream().mapToDouble(v -> v.doubleValue() / totalGenoCount).toArray();
        double[] cumfreq = new double[freq.length];
        cumfreq[0] = freq[0];
        for (int i2 = 1; i2 < freq.length; ++i2) {
            cumfreq[i2] = cumfreq[i2 - 1] + freq[i2];
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>(genoMap.keySet());
        Random ran = new Random();
        String[] strGeno = (String[])IntStream.range(0, ntaxa).mapToObj(t -> {
            if (byteGeno[t] == -1) {
                double p = ran.nextDouble();
                int bin = 0;
                while (p > cumfreq[bin]) {
                    ++bin;
                }
                return NucleotideAlignmentConstants.getNucleotideIUPAC((Byte)byteList.get(bin));
            }
            return NucleotideAlignmentConstants.getNucleotideIUPAC(byteGeno[t]);
        }).toArray(String[]::new);
        return new CategoricalAttribute(geno.siteName(site), strGeno);
    }

    private int[] siteNumbersFromNames(String[] siteNames, GenotypeTable a) {
        Arrays.sort(siteNames);
        int[] temp = new int[siteNames.length];
        int count = 0;
        int n = a.numberOfSites();
        for (int i = 0; i < n; ++i) {
            if (Arrays.binarySearch(siteNames, a.siteName(i)) < 0) continue;
            temp[count++] = i;
            if (count == siteNames.length) break;
        }
        int[] result = null;
        if (count == siteNames.length) {
            result = temp;
        } else {
            result = new int[count];
            System.arraycopy(temp, 0, result, 0, count);
        }
        return result;
    }

    public int[] getSitesToKeep() {
        return this.mySitesToKeep;
    }

    public void setSitesToKeep(int[] sitesToKeep) {
        this.mySitesToKeep = sitesToKeep;
        this.validItemsSet();
    }

    public String[] getSiteNamesToKeep() {
        return this.mySiteNamesToKeep;
    }

    public void setSiteNamesToKeep(String[] sitesToKeep) {
        this.mySiteNamesToKeep = sitesToKeep;
        this.validItemsSet();
    }

    public String[] getSiteNamesToRemove() {
        return this.mySiteNamesToRemove;
    }

    public void setSiteNamesToRemove(String[] sitesToRemove) {
        this.mySiteNamesToRemove = sitesToRemove;
        this.validItemsSet();
    }

    public String[] getSiteNamesToCovariates() {
        return this.mySiteNamesToCovariates;
    }

    public void setSiteNamesToCovariates(String[] mySitesToCovariates) {
        this.mySiteNamesToCovariates = mySitesToCovariates;
    }

    public int[] getSitesToCovariatesIndex() {
        return this.mySitesToCovariates;
    }

    public void setSitesToCovariatesIndex(int[] index) {
        this.mySitesToCovariates = index;
    }

    public String[] getSiteNamesToFactors() {
        return this.mySiteNamesToFactors;
    }

    public void setSiteNamesToFactors(String[] mySitesToFactors) {
        this.mySiteNamesToFactors = mySitesToFactors;
    }

    public int[] getSitesToFactorsIndex() {
        return this.mySitesToFactors;
    }

    public void setSitesToFactorsIndex(int[] index) {
        this.mySitesToFactors = index;
    }

    private void validItemsSet() {
        int count = 0;
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            ++count;
        }
        if (this.mySiteNamesToKeep != null && this.mySiteNamesToKeep.length != 0) {
            ++count;
        }
        if (this.mySiteNamesToRemove != null && this.mySiteNamesToRemove.length != 0) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalStateException("FilterSiteNamePlugin: validItemsSet: Can only set one of the following: sites to keep, site names to keep, or site names to remove.");
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterSiteNamePlugin.class.getResource("/net/maizegenetics/analysis/images/Filter.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Site Names";
    }

    @Override
    public String getToolTipText() {
        return "Select Site Names Within Dataset";
    }
}

