/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;

class TraitTableModel
extends AbstractTableModel {
    List<PhenotypeAttribute> attributeList;
    Phenotype myPhenotype;
    Boolean[] include;
    Phenotype.ATTRIBUTE_TYPE[] types;
    String[] colName;
    int numberOfTraits;
    int numberOfColumns;
    int typeColumnNumber;

    TraitTableModel(Phenotype aPhenotype) {
        this.myPhenotype = aPhenotype;
        this.attributeList = this.myPhenotype.attributeListCopy();
        this.numberOfTraits = this.attributeList.size();
        this.numberOfColumns = 3;
        this.setColumnNames();
        this.include = new Boolean[this.numberOfTraits];
        this.types = new Phenotype.ATTRIBUTE_TYPE[this.numberOfTraits];
        for (int i = 0; i < this.numberOfTraits; ++i) {
            this.include[i] = true;
            this.types[i] = this.myPhenotype.attributeType(i);
        }
    }

    private void setColumnNames() {
        this.colName = new String[this.numberOfColumns];
        int col = 0;
        this.colName[col++] = "Trait";
        this.colName[col++] = "Type";
        this.colName[col++] = "Include";
        this.typeColumnNumber = 1;
    }

    @Override
    public int getColumnCount() {
        return this.colName.length;
    }

    @Override
    public int getRowCount() {
        return this.include.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.myPhenotype.attribute(row).name();
        }
        if (col == 1) {
            return this.types[row];
        }
        if (col == 2) {
            return this.include[row];
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 2) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.colName[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.myPhenotype.attributeType(rowIndex) == Phenotype.ATTRIBUTE_TYPE.taxa) {
            return false;
        }
        if (this.myPhenotype.attributeType(rowIndex) == Phenotype.ATTRIBUTE_TYPE.factor) {
            return false;
        }
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            this.include[rowIndex] = (Boolean)value;
        }
        if (columnIndex == 1 && value instanceof Phenotype.ATTRIBUTE_TYPE) {
            this.types[rowIndex] = (Phenotype.ATTRIBUTE_TYPE)((Object)value);
        }
    }

    public void excludeAll() {
        for (int i = 0; i < this.numberOfTraits; ++i) {
            if (this.types[i] == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
            this.include[i] = Boolean.FALSE;
        }
        this.fireTableDataChanged();
    }

    public void includeAll() {
        for (int i = 0; i < this.numberOfTraits; ++i) {
            this.include[i] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public void excludeSome(int[] index) {
        for (int i : index) {
            if (this.types[i] == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
            this.include[i] = Boolean.FALSE;
        }
        this.fireTableDataChanged();
    }

    public void includeSome(int[] index) {
        for (int i : index) {
            this.include[i] = Boolean.TRUE;
        }
        this.fireTableDataChanged();
    }

    public int getTypeColumnNumber() {
        return this.typeColumnNumber;
    }
}

