/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaShort;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class KmerToTBTPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(KmerToTBTPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] myFastqFileS = null;
    private String myOutputDir = null;
    private int myMinCount = 1;
    private Tags myMasterTags = null;
    private static int maxGoodReads = 200000000;
    private static String nullS = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    private boolean useTBTByte = false;
    private boolean useTBTShort = false;

    public KmerToTBTPlugin() {
        super(null, false);
    }

    public KmerToTBTPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        KmerToTBTPlugin.matchTagsToTaxa(this.myFastqFileS, this.myMasterTags, this.myOutputDir, this.myMinCount, this.useTBTByte, this.useTBTShort);
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)"\nUsage is as follows:\n-i  Input directory containing .kmer.fa files\n-o  Output directory\n-s  Max good reads per lane. (Optional. Default is 200,000,000).\n-c  Minimum taxa count within a fastq file for a tag to be output (default 1)\n-y  Output to tagsByTaxaByte (tag counts per taxon from 0 to 127) instead of tagsByTaxaBit (0 or 1)\n    -t  Tag count file, OR A\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-o", "--output-directory", true);
            this.myArgsEngine.add("-s", "--max-reads", true);
            this.myArgsEngine.add("-c", "--min-count", true);
            this.myArgsEngine.add("-y", "--TBTByte", false);
            this.myArgsEngine.add("-sh", "--TBTShort", false);
            this.myArgsEngine.add("-t", "--tag-count", true);
            this.myArgsEngine.add("-m", "--physical-map", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-i");
        if (this.myArgsEngine.getBoolean("-s")) {
            maxGoodReads = Integer.parseInt(this.myArgsEngine.getString("-s"));
        }
        if (tempDirectory != null) {
            File fastqDirectory = new File(tempDirectory);
            if (!fastqDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myFastqFileS = DirectoryCrawler.listFileNames("(?i).*\\.kmer\\.fa$|.*\\.kmer\\.fa\\.gz$", fastqDirectory.getAbsolutePath());
            if (this.myFastqFileS.length == 0 || this.myFastqFileS == null) {
                this.printUsage();
                throw new IllegalArgumentException("Couldn't find any files that end with \".kmer.fa\", \".kmer.fa.gz\" in the supplied directory: " + tempDirectory);
            }
            myLogger.info((Object)"KmerToTBTPlugin: setParameters: Using the following fastq files:");
            for (String filename : this.myFastqFileS) {
                myLogger.info((Object)filename);
            }
        }
        if (this.myArgsEngine.getBoolean("-o")) {
            this.myOutputDir = this.myArgsEngine.getString("-o");
            File outDirectory = new File(this.myOutputDir);
            if (!outDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("The output name you supplied (option -o) is not a directory: " + this.myOutputDir);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output directory (option -o).");
        }
        Object var3_3 = null;
        this.myMinCount = this.myArgsEngine.getBoolean("-c") ? Integer.parseInt(this.myArgsEngine.getString("-c")) : 1;
        if (this.myArgsEngine.getBoolean("-y")) {
            this.useTBTByte = true;
        }
        if (this.myArgsEngine.getBoolean("-y")) {
            if (this.myArgsEngine.getBoolean("-sh")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -y and -sh are mutually exclusive.");
            }
            this.useTBTByte = true;
        } else if (this.myArgsEngine.getBoolean("-sh")) {
            if (this.myArgsEngine.getBoolean("-y")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -y and -sh are mutually exclusive.");
            }
            this.useTBTShort = true;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify byte format (-y) *OR* short int format (-sh).");
        }
        if (this.myArgsEngine.getBoolean("-t")) {
            if (this.myArgsEngine.getBoolean("-m")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagCounts(this.myArgsEngine.getString("-t"), TagsByTaxa.FilePacking.Byte);
        } else if (this.myArgsEngine.getBoolean("-m")) {
            if (this.myArgsEngine.getBoolean("-t")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagsOnPhysicalMap(this.myArgsEngine.getString("-m"), true);
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a tagCounts file (-t) *OR* a TagsOnPhysicalMap file (-m)");
        }
    }

    public static void matchTagsToTaxa(String[] fastqFileS, Tags theMasterTags, String outputDir, int minCount, boolean useTBTByte, boolean useTBTShort) {
        HashMap<String, Integer> readsPerSample = new HashMap<String, Integer>();
        HashMap<String, Integer> mappedReadsPerSample = new HashMap<String, Integer>();
        for (int laneNum = 0; laneNum < fastqFileS.length; ++laneNum) {
            String replaceS;
            TagsByTaxa.FilePacking outFormat = useTBTByte ? TagsByTaxa.FilePacking.Byte : (useTBTShort ? TagsByTaxa.FilePacking.Short : TagsByTaxa.FilePacking.Byte);
            String outFileS = outputDir + fastqFileS[laneNum].substring(fastqFileS[laneNum].lastIndexOf(File.separator));
            File outfile = new File(outFileS.replaceAll("(?i)\\.kmer\\.fa$|\\.kmer\\.fa\\.gz$", replaceS = outFormat == TagsByTaxa.FilePacking.Text ? ".tbt.txt" : (outFormat == TagsByTaxa.FilePacking.Byte ? ".tbt.byte" : (outFormat == TagsByTaxa.FilePacking.Short ? ".tbt.shrt" : ".tbt.bin"))));
            if (outfile.isFile()) {
                System.out.println("An output file " + outfile.getName() + "\n already exists in the output directory for file " + fastqFileS[laneNum] + ".  Skipping.");
                continue;
            }
            System.out.println("\nWorking on kmer file: " + fastqFileS[laneNum]);
            AbstractTagsByTaxa theTBT = null;
            System.gc();
            int allReads = 0;
            int goodMatched = 0;
            File fastqFile = new File(fastqFileS[laneNum]);
            String taxaName = fastqFile.getName();
            taxaName = taxaName.substring(0, taxaName.indexOf("."));
            String[] taxaNames = new String[]{taxaName};
            if (useTBTByte) {
                theTBT = new TagsByTaxaByte(taxaNames, theMasterTags);
            } else if (useTBTShort) {
                theTBT = new TagsByTaxaShort(taxaNames, theMasterTags);
            }
            String temp = "";
            allReads = 0;
            goodMatched = 0;
            try {
                BufferedReader br = fastqFileS[laneNum].endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fastqFileS[laneNum])))) : new BufferedReader(new FileReader(fastqFileS[laneNum]), 65536);
                String sl = "";
                long[] binary_s1 = new long[2];
                while ((temp = br.readLine()) != null && allReads < maxGoodReads) {
                    ++allReads;
                    int kmercount = Integer.parseInt(temp.replaceAll("[^\\d]", ""));
                    sl = br.readLine().trim();
                    sl = sl + nullS;
                    binary_s1 = BaseEncoder.getLongArrayFromSeq(sl = sl.substring(0, 64));
                    int h = theTBT.getTagIndex(binary_s1);
                    if (h > -1) {
                        theTBT.addReadsToTagTaxon(h, 0, 1);
                        ++goodMatched;
                    }
                    if (allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + allReads + " goodMatched:" + goodMatched);
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline read at =" + allReads + " e=" + e);
                System.out.println(temp);
                e.printStackTrace();
            }
            readsPerSample.put(taxaName, allReads);
            mappedReadsPerSample.put(taxaName, allReads);
            System.out.println("Timing process (writing TagsByTaxa file)...");
            long timePoint1 = System.currentTimeMillis();
            theTBT.writeDistFile(outfile, outFormat, minCount);
            System.out.println("...process (writing KmerByTaxa file) took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            System.out.println("Total number of kmer in file=" + allReads);
            System.out.println("Total number of matched reads=" + goodMatched);
            int filesDone = laneNum + 1;
            System.out.println("Finished reading " + filesDone + " of " + fastqFileS.length + " sequence files: " + fastqFileS[laneNum] + "\n");
        }
        try {
            String ofname = outputDir + "kmer.log";
            DataOutputStream report = new DataOutputStream(new FileOutputStream(ofname));
            report.writeBytes("name\tread count\tmapped read count\n");
            for (String name : readsPerSample.keySet()) {
                int count = (Integer)readsPerSample.get(name);
                int mappedCount = (Integer)mappedReadsPerSample.get(name);
                report.writeBytes(name + '\t' + count + '\t' + mappedCount + '\n');
            }
            report.close();
        }
        catch (Exception e) {
            myLogger.warn((Object)("Caught exception while writing report file! " + e));
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

