/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteFileMap;
import net.maizegenetics.dna.tag.TagsByTaxaByteFileMapSeq;
import net.maizegenetics.dna.tag.TagsByTaxaUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class MergeTagsByTaxaFilesByRowPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeTagsByTaxaFilesByRowPlugin.class);
    static File inputDirectory = null;
    static File hapmapFile = null;
    static String topmFileName = "/Volumes/nextgen/Zea/build20120110/topm/allZea_mappedonly_chr5-10_20120115.topm";
    static String topmFileName2 = "/Volumes/LaCie/zea20120110c510.topm";
    static String[] infiles = null;
    static String outfilename = null;
    static ArgsEngine myArgsEngine = null;
    static boolean combineSynonymousTaxa = false;
    static int maxTags = 200000000;

    public MergeTagsByTaxaFilesByRowPlugin() {
        super(null, false);
    }

    public MergeTagsByTaxaFilesByRowPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public static final void createMergeOutfile(String[] infiles, String outfile) {
        TagsOnPhysicalMap theTOPM = new TagsOnPhysicalMap(topmFileName2, true);
        ArrayList<String> allTaxa = new ArrayList<String>();
        int filesRead = 0;
        int tagLengthInLong = theTOPM.getTagSizeInLong();
        TagsByTaxaByteFileMapSeq[] inTBT = new TagsByTaxaByteFileMapSeq[infiles.length];
        for (int i = 0; i < infiles.length; ++i) {
            String inName = infiles[i];
            myLogger.info((Object)("Scanning " + inName + " (file " + ++filesRead + " of " + infiles.length + ")."));
            inTBT[i] = new TagsByTaxaByteFileMapSeq(inName);
            for (String name : inTBT[i].getTaxaNames()) {
                allTaxa.add(name);
            }
        }
        System.out.println("Total Taxa:" + allTaxa.size());
        System.out.println(allTaxa.toString());
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfilename), 0x4000000));
            fw.writeInt(theTOPM.getTagCount());
            fw.writeInt(theTOPM.getTagSizeInLong());
            fw.writeInt(allTaxa.size());
            for (int t = 0; t < allTaxa.size(); ++t) {
                fw.writeUTF((String)allTaxa.get(t));
            }
            for (int i = 0; i < theTOPM.getTagCount(); ++i) {
                long[] currtag = theTOPM.getTag(i);
                for (int j = 0; j < tagLengthInLong; ++j) {
                    fw.writeLong(currtag[j]);
                }
                fw.writeByte(theTOPM.getTagLength(i));
                for (int f = 0; f < infiles.length; ++f) {
                    byte[] ob = inTBT[f].advanceToTagDist(currtag);
                    fw.write(ob);
                }
                if (i % 10000 != 0) continue;
                System.out.println("TagNumber out:" + i);
            }
            fw.close();
            for (int f = 0; f < infiles.length; ++f) {
                inTBT[f].getFileReadyForClosing();
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
    }

    public void creatMergeTBTByTagCount(String infileDirS, String outfileS, String tagCountFileS) {
        File[] tbtFiles = new File(infileDirS).listFiles();
        String[] tbtFileSs = new String[tbtFiles.length];
        for (int i = 0; i < tbtFiles.length; ++i) {
            tbtFileSs[i] = tbtFiles[i].getAbsolutePath();
        }
        TagCounts tc = new TagCounts(tagCountFileS, TagsByTaxa.FilePacking.Byte);
        this.createMergeTBTByTagCount(tbtFileSs, outfileS, tc);
    }

    private void createMergeTBTByTagCount(String[] infiles, String outfileS, TagCounts tc) {
        ArrayList<String> allTaxa = new ArrayList<String>();
        int filesRead = 0;
        int tagLengthInLong = tc.getTagSizeInLong();
        TagsByTaxaByteFileMapSeq[] inTBT = new TagsByTaxaByteFileMapSeq[infiles.length];
        for (int i = 0; i < infiles.length; ++i) {
            String inName = infiles[i];
            ++filesRead;
            inTBT[i] = new TagsByTaxaByteFileMapSeq(inName);
            for (String name : inTBT[i].getTaxaNames()) {
                allTaxa.add(name);
            }
        }
        System.out.println("Total Taxa:" + allTaxa.size());
        System.out.println(allTaxa.toString());
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 0x4000000));
            fw.writeInt(tc.getTagCount());
            fw.writeInt(tc.getTagSizeInLong());
            fw.writeInt(allTaxa.size());
            for (int t = 0; t < allTaxa.size(); ++t) {
                fw.writeUTF((String)allTaxa.get(t));
            }
            for (int i = 0; i < tc.getTagCount(); ++i) {
                long[] currtag = tc.getTag(i);
                for (int j = 0; j < tagLengthInLong; ++j) {
                    fw.writeLong(currtag[j]);
                }
                fw.writeByte(tc.getTagLength(i));
                for (int f = 0; f < infiles.length; ++f) {
                    byte[] ob = inTBT[f].advanceToTagDist(currtag);
                    fw.write(ob);
                }
                if (i % 10000 != 0) continue;
                System.out.println("TagNumber out:" + i);
            }
            fw.close();
            for (int f = 0; f < infiles.length; ++f) {
                inTBT[f].getFileReadyForClosing();
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
    }

    @Override
    public DataSet performFunction(DataSet input) {
        MergeTagsByTaxaFilesByRowPlugin.createMergeOutfile(infiles, outfilename);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        myLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        if (args.length == 0) {
            MergeTagsByTaxaFilesByRowPlugin.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (myArgsEngine == null) {
            myArgsEngine = new ArgsEngine();
            myArgsEngine.add("-i", "--input-directory", true);
            myArgsEngine.add("-o", "--output_file", true);
            myArgsEngine.add("-s", "--max_tags", true);
            myArgsEngine.add("-x", "--combine-synonymous-taxa");
            myArgsEngine.add("-h", "--write-hapmap", true);
        }
        myArgsEngine.parse(args);
        if (myArgsEngine.getBoolean("-x")) {
            combineSynonymousTaxa = true;
        }
        if (myArgsEngine.getBoolean("-h")) {
            hapmapFile = new File(myArgsEngine.getString("-h"));
        }
        if (myArgsEngine.getBoolean("-s")) {
            maxTags = Integer.parseInt(myArgsEngine.getString("-s"));
        }
        if (myArgsEngine.getBoolean("-o")) {
            outfilename = myArgsEngine.getString("-o");
            File outfile = new File(outfilename);
            if (outfile.isDirectory()) {
                MergeTagsByTaxaFilesByRowPlugin.printUsage();
                throw new IllegalArgumentException("The output filename you provided is a directory, not a file.");
            }
        } else {
            MergeTagsByTaxaFilesByRowPlugin.printUsage();
            throw new IllegalArgumentException("Please specify an output file.");
        }
        if (myArgsEngine.getBoolean("-i")) {
            inputDirectory = new File(myArgsEngine.getString("-i"));
            if (!inputDirectory.isDirectory()) {
                MergeTagsByTaxaFilesByRowPlugin.printUsage();
                throw new IllegalArgumentException("The input name you supplied is not a directory.");
            }
            infiles = DirectoryCrawler.listFileNames(".*\\.tbt\\.bin|.*\\.tbt\\.byte", inputDirectory.getAbsolutePath());
            myLogger.info((Object)"Merging the following .tbt.bin files...");
            for (String filename : infiles) {
                if (!TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxaUtils.format(outfilename))) {
                    myLogger.warn((Object)"Input file extension does not match output file extension.");
                }
                myLogger.info((Object)filename);
            }
        } else {
            MergeTagsByTaxaFilesByRowPlugin.printUsage();
            throw new IllegalArgumentException("You forgot to provide an input directory name.");
        }
        myLogger.info((Object)("...to \"" + outfilename + "\"."));
    }

    private static void printUsage() {
        myLogger.info((Object)("\n\n\nUsage is as follows:\n-i  Input directory containing .tbt.bin files\n-o  Output file name\n-s  Maximum number of tags the TBT can hold while merging (default: " + maxTags + ")\n-x  Merge tag counts of taxa with identical names (default: false)\n-h  Call snps in output and write to HapMap file with the provided name\n\n\n"), (Throwable)new IllegalArgumentException());
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "FilterErrorForBiparental";
    }

    @Override
    public String getToolTipText() {
        return "FilterErrorForBiparental";
    }

    private static TagsByTaxa newTBT(String filename, String[] taxonNames, TagCountMutable tcm) {
        if (TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxa.FilePacking.Byte)) {
            return new TagsByTaxaByteFileMap(filename, taxonNames, tcm);
        }
        return null;
    }

    private static TagsByTaxa newTBT(String filename) {
        if (TagsByTaxaUtils.format(filename).equals((Object)TagsByTaxa.FilePacking.Byte)) {
            return new TagsByTaxaByteFileMap(filename);
        }
        return null;
    }

    public static void main(String[] args) {
        args = new String[]{"-i", "/Volumes/nextgen/Zea/build20120110/tbt/", "-o", "/Volumes/LaCie/zea20120110c510b.tbt.byte"};
        MergeTagsByTaxaFilesByRowPlugin testClass = new MergeTagsByTaxaFilesByRowPlugin();
        testClass.setParameters(args);
        testClass.performFunction(null);
    }
}

