/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.analysis.gbs.TagMatchFinder;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class ProductionSNPCallerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProductionSNPCallerPlugin.class);
    private PluginParameter<String> myInputDirectory = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing fastq AND/OR qseq files.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library").build();
    private PluginParameter<String> myProductionTOPM = new PluginParameter.Builder<String>("m", null, String.class).guiName("Input TOPM File").required(true).inFile().description("Physical map file containing tags and corresponding variants (production TOPM)").build();
    private PluginParameter<String> myOutputGenotypes = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output HDF5 Genotypes File").required(true).outFile().description("Output (target) HDF5 genotypes file to add new genotypes to (new file created if it doesn't exist)").build();
    private PluginParameter<Double> myAveSeqErrorRate = new PluginParameter.Builder<Double>("eR", 0.01, Double.class).guiName("Ave Seq Error Rate").description("Average sequencing error rate per base (used to decide between heterozygous and homozygous calls)").build();
    private PluginParameter<Boolean> myKeepGenotypesOpen = new PluginParameter.Builder<Boolean>("ko", false, Boolean.class).guiName("Keep Genotypes Open").description("Keep hdf5 genotypes open for future runs that add more taxa or more depth").build();
    private PluginParameter<Boolean> myNoDepthOutput = new PluginParameter.Builder<Boolean>("ndo", false, Boolean.class).guiName("No Depth to Output").description("No depth output: do not write depths to the output hdf5 genotypes file").build();
    private String[] myRawSeqFileNames = null;
    private String myOutputDir = null;
    private TOPMInterface topm = null;
    private int[] chromosomes = null;
    private boolean fastq = true;
    private Map<String, Integer> keyFileColumns = new HashMap<String, Integer>();
    private Set<String> flowcellLanesInKey = new TreeSet<String>();
    private Map<String, String> seqFileNameToFlowcellLane = new HashMap<String, String>();
    private Set<String> seqFilesInKeyAndDir = new TreeSet<String>();
    private Map<String, String> fullNameToHDF5Name = new TreeMap<String, String>();
    private Multimap<String, String> flowCellLaneToLibPrepIDs = TreeMultimap.create();
    private Map<String, String> libraryPrepIDToSampleName = new TreeMap<String, String>();
    private GenotypeTableBuilder genos = null;
    private TaxaList taxaList = null;
    private PositionList myPositionList = null;
    private IntArrayList[] obsTagsForEachTaxon = null;
    private Table<Integer, Integer, Integer> positionToSite = null;
    private Map<String, Integer> rawReadCountsForFullSampleName = new TreeMap<String, Integer>();
    private Map<String, Integer> matchedReadCountsForFullSampleName = new TreeMap<String, Integer>();
    private BasicGenotypeMergeRule genoMergeRule = null;
    public static final String rawSeqFileNameRegex = "(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$";
    private String noMatchingRawSeqFileNamesMessage = "Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", \"_sequence.txt.gz\", \"_qseq.txt\", or \"_qseq.txt.gz\" in the supplied directory: ";

    public ProductionSNPCallerPlugin() {
        super(null, false);
    }

    public ProductionSNPCallerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        File rawSeqDirectory = new File(this.inputDirectory());
        this.myRawSeqFileNames = DirectoryCrawler.listFileNames(rawSeqFileNameRegex, rawSeqDirectory.getAbsolutePath());
        if (this.myRawSeqFileNames.length == 0 || this.myRawSeqFileNames == null) {
            throw new IllegalArgumentException(this.noMatchingRawSeqFileNamesMessage + this.inputDirectory());
        }
        Arrays.sort(this.myRawSeqFileNames);
        String message = "\nProductionSNPCallerPlugin:\n\nThe following GBS raw sequence data files were found in the input folder (and sub-folders):";
        for (String filename : this.myRawSeqFileNames) {
            message = message + "\n   " + filename;
        }
        myLogger.info((Object)(message + "\n"));
        this.topm = TOPMUtils.readTOPM(this.inputTOPMFile());
        if (this.topm.getSize() == 0) {
            throw new IllegalStateException("TagsOnPhysicalMap file not available or is empty");
        }
        try {
            this.myOutputDir = new File(this.outputHDF5GenotypesFile()).getCanonicalFile().getParent();
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem resolving output directory:" + e);
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        long current;
        long previous;
        this.readKeyFile();
        this.matchKeyFileToAvailableRawSeqFiles();
        this.myPositionList = this.getUniquePositions();
        this.generateFastSiteLookup(this.myPositionList);
        this.setUpGenotypeTableBuilder();
        int nFilesProcessed = 0;
        for (int fileNum = 0; fileNum < this.myRawSeqFileNames.length; ++fileNum) {
            if (!this.seqFilesInKeyAndDir.contains(this.myRawSeqFileNames[fileNum])) continue;
            int[] counters = new int[]{0, 0, 0, 0, 0, 0};
            myLogger.info((Object)"\nLooking for known SNPs in sequence reads from file:");
            myLogger.info((Object)("  " + this.myRawSeqFileNames[fileNum] + "\n"));
            previous = System.nanoTime();
            this.readRawSequencesAndRecordDepth(fileNum, counters);
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: readRawSequencesAndRecordDepth: " + this.myRawSeqFileNames[fileNum] + ": " + (double)(current - previous) / 1.0E9 + " sec");
            previous = System.nanoTime();
            this.callGenotypes();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: callGenotypes: " + this.myRawSeqFileNames[fileNum] + ": " + (double)(current - previous) / 1.0E9 + " sec");
            this.reportTotals(fileNum, counters, ++nFilesProcessed);
        }
        if (this.keepGenotypesOpen().booleanValue()) {
            previous = System.nanoTime();
            this.genos.closeUnfinished();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: genos.closeUnfinished(): " + (double)(current - previous) / 1.0E9 + " sec");
        } else {
            previous = System.nanoTime();
            this.genos.build();
            current = System.nanoTime();
            System.out.println("ProductionSNPCallerPlugin: performFunction: genos.build(): " + (double)(current - previous) / 1.0E9 + " sec");
        }
        this.writeReadsPerSampleReports();
        return null;
    }

    private void readRawSequencesAndRecordDepth(int fileNum, int[] counters) {
        ParseBarcodeRead thePBR = this.setUpBarcodes(fileNum);
        if (thePBR == null || thePBR.getBarCodeCount() == 0) {
            myLogger.info((Object)"No barcodes found. Skipping this raw sequence file.");
            return;
        }
        this.taxaList = new TaxaListBuilder().addAll((Collection<Taxon>)this.getHDF5Taxa(fileNum)).sortTaxaAlphabetically().build();
        this.obsTagsForEachTaxon = new IntArrayList[this.taxaList.numberOfTaxa()];
        for (int t = 0; t < this.obsTagsForEachTaxon.length; ++t) {
            this.obsTagsForEachTaxon[t] = new IntArrayList(750000);
        }
        String temp = "Nothing has been read from the raw sequence file yet";
        BufferedReader br = this.getBufferedReaderForRawSeqFile(fileNum);
        try {
            long readSeqReadTime = 0L;
            long ifRRNotNullTime = 0L;
            while ((temp = br.readLine()) != null) {
                if (counters[0] % 1000000 == 0) {
                    this.reportProgress(counters, readSeqReadTime, ifRRNotNullTime);
                }
                long previous = System.nanoTime();
                ReadBarcodeResult rr = this.readSequenceRead(br, temp, thePBR, counters);
                long current = System.nanoTime();
                readSeqReadTime += current - previous;
                previous = System.nanoTime();
                if (rr != null) {
                    counters[1] = counters[1] + 1;
                    this.rawReadCountsForFullSampleName.put(rr.getTaxonName(), this.rawReadCountsForFullSampleName.get(rr.getTaxonName()) + 1);
                    int tagIndex = this.topm.getTagIndex(rr.getRead());
                    if (tagIndex >= 0) {
                        counters[3] = counters[3] + 1;
                    }
                    if (tagIndex < 0) continue;
                    counters[2] = counters[2] + 1;
                    this.matchedReadCountsForFullSampleName.put(rr.getTaxonName(), this.matchedReadCountsForFullSampleName.get(rr.getTaxonName()) + 1);
                    int taxonIndex = this.taxaList.indexOf(this.fullNameToHDF5Name.get(rr.getTaxonName()));
                    if (taxonIndex == -1) {
                        System.out.println("We're here!");
                    }
                    this.obsTagsForEachTaxon[taxonIndex].add(tagIndex);
                }
                current = System.nanoTime();
                ifRRNotNullTime += current - previous;
            }
            System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: readSequenceTime: " + (double)readSeqReadTime / 1.0E9 + " sec");
            System.out.println("ProductionSNPCallerPlugin: readRawSequencesAndRecordDepth: processSequenceTime: " + (double)ifRRNotNullTime / 1.0E9 + " sec");
            br.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Catch in readRawSequencesAndRecordDepth() at nReads=" + counters[0] + " e=" + e));
            myLogger.error((Object)("Last line read: " + temp));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void reportProgress(int[] counters, long readSeqReadTime, long ifRRNotNullTime) {
        myLogger.info((Object)("totalReads:" + counters[0] + "  goodBarcodedReads:" + counters[1] + "  goodMatchedToTOPM:" + counters[2] + "  cumulReadSequenceTime: " + (double)readSeqReadTime / 1.0E9 + " sec  cumulProcessSequenceTime: " + (double)ifRRNotNullTime / 1.0E9 + " sec"));
    }

    private void reportTotals(int fileNum, int[] counters, int nFilesProcessed) {
        myLogger.info((Object)("Total number of reads in lane=" + counters[0]));
        myLogger.info((Object)("Total number of good, barcoded reads=" + counters[1]));
        myLogger.info((Object)("Total number of good, barcoded reads matched to the TOPM=" + counters[2]));
        myLogger.info((Object)("Finished reading " + nFilesProcessed + " of " + this.seqFilesInKeyAndDir.size() + " sequence files: " + this.myRawSeqFileNames[fileNum] + "\n"));
    }

    private void readKeyFile() {
        this.flowcellLanesInKey.clear();
        this.seqFileNameToFlowcellLane.clear();
        this.seqFilesInKeyAndDir.clear();
        this.fullNameToHDF5Name.clear();
        this.flowCellLaneToLibPrepIDs.clear();
        this.libraryPrepIDToSampleName.clear();
        String inputLine = "Nothing has been read from the keyfile yet";
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.keyFile()), 65536);
            int currLine = 0;
            while ((inputLine = br.readLine()) != null) {
                if (currLine == 0) {
                    this.parseKeyFileHeader(inputLine);
                } else {
                    this.populateKeyFileFields(inputLine);
                }
                ++currLine;
            }
        }
        catch (Exception e) {
            myLogger.error((Object)("Couldn't read key file: " + e));
            myLogger.error((Object)("Last line read from key file: " + inputLine));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void parseKeyFileHeader(String headerLine) {
        headerLine.trim();
        String[] header = headerLine.split("\\t");
        this.keyFileColumns.clear();
        for (int col = 0; col < header.length; ++col) {
            if (header[col].equalsIgnoreCase("Flowcell")) {
                this.keyFileColumns.put("Flowcell", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("Lane")) {
                this.keyFileColumns.put("Lane", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("Barcode")) {
                this.keyFileColumns.put("Barcode", col);
                continue;
            }
            if (header[col].equalsIgnoreCase("DNASample") || header[col].equalsIgnoreCase("Sample")) {
                this.keyFileColumns.put("Sample", col);
                continue;
            }
            if (!header[col].equalsIgnoreCase("LibraryPrepID")) continue;
            this.keyFileColumns.put("LibPrepID", col);
        }
        if (!this.confirmKeyFileHeader()) {
            this.throwBadKeyFileError();
        }
    }

    private boolean confirmKeyFileHeader() {
        if (!this.keyFileColumns.containsKey("Flowcell")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Lane")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Barcode")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("Sample")) {
            return false;
        }
        if (!this.keyFileColumns.containsKey("LibPrepID")) {
            return false;
        }
        if (!this.keyFileColumns.get("Flowcell").equals(0)) {
            return false;
        }
        if (!this.keyFileColumns.get("Lane").equals(1)) {
            return false;
        }
        if (!this.keyFileColumns.get("Barcode").equals(2)) {
            return false;
        }
        if (!this.keyFileColumns.get("Sample").equals(3)) {
            return false;
        }
        return this.keyFileColumns.get("LibPrepID").equals(7);
    }

    private void throwBadKeyFileError() {
        String badKeyFileMessage = "\n\nThe keyfile does not conform to expections.\nIt must contain columns with the following (exact) headers, and\nin the indicated columns:\n   \"Flowcell\"                 (column A)\n   \"Lane\"                     (column B)\n   \"Barcode\"                  (column C)\n   \"DNASample\" or \"Sample\"    (column D)\n   \"LibraryPrepID\"            (column H)\n\n\n";
        try {
            throw new IllegalStateException(badKeyFileMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void populateKeyFileFields(String keyFileLine) {
        keyFileLine.trim();
        String[] cells = keyFileLine.split("\\t");
        String sample = cells[this.keyFileColumns.get("Sample")];
        String libPrepID = cells[this.keyFileColumns.get("LibPrepID")];
        String fullName = sample + ":" + cells[this.keyFileColumns.get("Flowcell")] + ":" + cells[this.keyFileColumns.get("Lane")] + ":" + libPrepID;
        this.rawReadCountsForFullSampleName.put(fullName, 0);
        this.matchedReadCountsForFullSampleName.put(fullName, 0);
        this.fullNameToHDF5Name.put(fullName, sample + ":" + libPrepID);
        String flowCell_Lane = cells[this.keyFileColumns.get("Flowcell")] + "_" + cells[this.keyFileColumns.get("Lane")];
        this.flowcellLanesInKey.add(flowCell_Lane);
        this.flowCellLaneToLibPrepIDs.put((Object)flowCell_Lane, (Object)libPrepID);
        String prevSample = this.libraryPrepIDToSampleName.get(libPrepID);
        if (prevSample == null) {
            this.libraryPrepIDToSampleName.put(libPrepID, sample);
        } else if (!prevSample.contentEquals(sample)) {
            try {
                throw new IllegalStateException("\nThe key file contains different Sample names (\"" + prevSample + "\" and \"" + sample + "\") for the sample LibraryPrepID (" + libPrepID + ")\n\n");
            }
            catch (Exception e) {
                myLogger.error((Object)("Error in key file: " + e));
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void matchKeyFileToAvailableRawSeqFiles() {
        String message = "\nThe following raw sequence files in the input directory conform to one of our file naming conventions and have corresponding samples in the barcode key file:";
        for (int fileNum = 0; fileNum < this.myRawSeqFileNames.length; ++fileNum) {
            String[] flowcellLane = this.parseRawSeqFileName(this.myRawSeqFileNames[fileNum]);
            if (flowcellLane == null || !this.flowcellLanesInKey.contains(flowcellLane[0] + "_" + flowcellLane[1])) continue;
            this.seqFileNameToFlowcellLane.put(this.myRawSeqFileNames[fileNum], flowcellLane[0] + "_" + flowcellLane[1]);
            this.seqFilesInKeyAndDir.add(this.myRawSeqFileNames[fileNum]);
            message = message + "\n  " + this.myRawSeqFileNames[fileNum];
        }
        message = message + "\n";
        myLogger.info((Object)message);
    }

    private ParseBarcodeRead setUpBarcodes(int fileNum) {
        System.gc();
        String message = "\nWorking on GBS raw sequence file: " + this.myRawSeqFileNames[fileNum];
        this.fastq = true;
        if (new File(this.myRawSeqFileNames[fileNum]).getName().contains("qseq")) {
            this.fastq = false;
        }
        message = this.fastq ? message + "\n\tThis file is assumed to be in fastq format" : message + "\n\tThis file contains 'qseq' in its name so is assumed to be in qseq format";
        String[] flowcellLane = this.parseRawSeqFileName(this.myRawSeqFileNames[fileNum]);
        if (flowcellLane == null) {
            myLogger.info((Object)message);
            return null;
        }
        ParseBarcodeRead thePBR = new ParseBarcodeRead(this.keyFile(), this.enzyme(), flowcellLane[0], flowcellLane[1]);
        message = message + "\nTotal barcodes found in key file for this lane:" + thePBR.getBarCodeCount() + "\n";
        myLogger.info((Object)message);
        return thePBR;
    }

    private String[] parseRawSeqFileName(String rawSeqFileName) {
        File rawSeqFile = new File(rawSeqFileName);
        String[] FileNameParts = rawSeqFile.getName().split("_");
        if (FileNameParts.length == 3) {
            return new String[]{FileNameParts[0], FileNameParts[1]};
        }
        if (FileNameParts.length == 4) {
            return new String[]{FileNameParts[0], FileNameParts[2]};
        }
        if (FileNameParts.length == 5) {
            return new String[]{FileNameParts[1], FileNameParts[3]};
        }
        this.printFileNameConventions(rawSeqFileName);
        return null;
    }

    private void setUpGenotypeTableBuilder() {
        this.genoMergeRule = new BasicGenotypeMergeRule(this.aveSeqErrorRate());
        File hdf5File = new File(this.outputHDF5GenotypesFile());
        if (hdf5File.exists()) {
            myLogger.info((Object)("\nGenotypes will be added to existing HDF5 file:\n  " + this.outputHDF5GenotypesFile() + "\n"));
            this.genos = GenotypeTableBuilder.mergeTaxaIncremental(this.outputHDF5GenotypesFile(), this.genoMergeRule);
        } else {
            myLogger.info((Object)("\nThe target HDF5 file:\n  " + this.outputHDF5GenotypesFile() + "\ndoes not exist. A new HDF5 file of that name will be created \nto hold the genotypes from this run."));
            this.genos = GenotypeTableBuilder.getTaxaIncrementalWithMerging(this.outputHDF5GenotypesFile(), this.myPositionList, this.genoMergeRule);
        }
    }

    private ArrayList<Taxon> getHDF5Taxa(int fileNum) {
        String currFlowcellLane = this.seqFileNameToFlowcellLane.get(this.myRawSeqFileNames[fileNum]);
        String[] flowcellLane = currFlowcellLane.split("_");
        TaxaList annoTL = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), "LibraryPrepID", (Map<String, String>)ImmutableMap.of((Object)"Flowcell", (Object)flowcellLane[0], (Object)"Lane", (Object)flowcellLane[1]), false);
        ArrayList<Taxon> taxaAL = new ArrayList<Taxon>();
        for (Taxon tax : annoTL) {
            GeneralAnnotation annotation = tax.getAnnotation();
            String newName = annotation.getTextAnnotation("Sample").length == 0 ? annotation.getTextAnnotation("DNASample")[0] : annotation.getTextAnnotation("Sample")[0];
            String libPrepID = tax.getName();
            newName = newName + ":" + libPrepID;
            Taxon gbsTaxon = new Taxon.Builder(tax).name(newName).addAnno("Flowcell_Lane", currFlowcellLane).addAnno("LibraryPrepID", libPrepID).addAnno("Status", "private").build();
            taxaAL.add(gbsTaxon);
        }
        return taxaAL;
    }

    private PositionList getUniquePositions() {
        myLogger.info((Object)"\nCounting sites in TOPM file");
        PositionListBuilder plb = new PositionListBuilder();
        int[] nArray = this.chromosomes = this.topm.getChromosomes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer chrNum = nArray[i];
            Chromosome chr = new Chromosome(chrNum.toString());
            for (int pos : this.topm.getUniquePositions(this.topm.getChromosomeIndex(chrNum))) {
                GeneralPosition p = new GeneralPosition.Builder(chr, pos).build();
                plb.add(p);
            }
        }
        PositionList pl = plb.sortPositions().build();
        myLogger.info((Object)("In total, the TOPM contains " + this.chromosomes.length + " chromosomes and " + pl.numberOfSites() + " sites."));
        return pl;
    }

    private void generateFastSiteLookup(PositionList pl) {
        ImmutableTable.Builder ptsB = new ImmutableTable.Builder();
        for (int i = 0; i < pl.numberOfSites(); ++i) {
            Position position = (Position)pl.get(i);
            ptsB.put((Object)position.getChromosome().getChromosomeNumber(), (Object)position.getPosition(), (Object)i);
        }
        this.positionToSite = ptsB.build();
    }

    private BufferedReader getBufferedReaderForRawSeqFile(int fileNum) {
        BufferedReader br = null;
        try {
            br = this.myRawSeqFileNames[fileNum].endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(this.myRawSeqFileNames[fileNum])))) : new BufferedReader(new FileReader(this.myRawSeqFileNames[fileNum]), 65536);
        }
        catch (Exception e) {
            myLogger.error((Object)("Catch in getBufferedReader(): e=" + e));
            e.printStackTrace();
        }
        return br;
    }

    private ReadBarcodeResult readSequenceRead(BufferedReader br, String temp, ParseBarcodeRead thePBR, int[] counters) {
        ReadBarcodeResult rr = null;
        String sl = "";
        try {
            if (this.fastq) {
                sl = br.readLine();
                temp = br.readLine();
                temp = br.readLine();
                rr = thePBR.parseReadIntoTagAndTaxa(sl, null, true, 0);
            } else {
                String[] jj = temp.split("\\s");
                sl = jj[8];
                rr = thePBR.parseReadIntoTagAndTaxa(sl, null, false, 0);
            }
        }
        catch (Exception e) {
            myLogger.error((Object)("Catch in readSequenceRead() at nReads=" + counters[0] + " e=" + e));
            myLogger.error((Object)("Last line read:\n" + temp + "\n"));
            e.printStackTrace();
        }
        counters[0] = counters[0] + 1;
        return rr;
    }

    private int findBestImperfectMatch(long[] read2, int[] counters) {
        int tagIndex = -1;
        TagMatchFinder tmf = new TagMatchFinder(this.topm);
        TreeMap<Integer, Integer> bestHitsAndDiv = tmf.findMatchesWithIntLengthWords(read2, 0, true);
        if (bestHitsAndDiv.size() > 0) {
            counters[4] = counters[4] + 1;
            if (bestHitsAndDiv.size() == 1) {
                counters[5] = counters[5] + 1;
            }
            tagIndex = bestHitsAndDiv.firstKey();
        }
        return tagIndex;
    }

    private void incrementDepthForTagVariants(int tagIndex, int[][] alleleDepths, int increment) {
        int chromosome = this.topm.getChromosome(tagIndex);
        if (chromosome == Integer.MIN_VALUE) {
            return;
        }
        int startPos = this.topm.getStartPosition(tagIndex);
        for (int variant = 0; variant < this.topm.getMaxNumVariants(); ++variant) {
            byte newBase = this.topm.getVariantDef(tagIndex, variant);
            if (newBase == -128 || newBase == 15) continue;
            byte offset = this.topm.getVariantPosOff(tagIndex, variant);
            int pos = startPos + offset;
            int currSite = (Integer)this.positionToSite.get((Object)chromosome, (Object)pos);
            if (currSite < 0) continue;
            int[] nArray = alleleDepths[newBase];
            int n = currSite;
            nArray[n] = nArray[n] + increment;
        }
    }

    private void callGenotypes() {
        myLogger.info((Object)"\nCalling genotypes...");
        for (int currTaxonIndex = 0; currTaxonIndex < this.obsTagsForEachTaxon.length; ++currTaxonIndex) {
            IntArrayList currTagList = this.obsTagsForEachTaxon[currTaxonIndex];
            currTagList.sort();
            int[][] alleleDepths = new int[6][this.myPositionList.numberOfSites()];
            int prevTag = currTagList.getQuick(0);
            int currInc = 0;
            for (int t = 0; t < currTagList.size(); ++t) {
                int tag = currTagList.getQuick(t);
                if (tag == prevTag) {
                    ++currInc;
                    continue;
                }
                this.incrementDepthForTagVariants(prevTag, alleleDepths, currInc);
                prevTag = tag;
                currInc = 1;
            }
            this.incrementDepthForTagVariants(prevTag, alleleDepths, currInc);
            byte[][] byteDepths = AlleleDepthUtil.depthIntToByte(alleleDepths);
            byte[] taxonGenos = this.resolveGenosForTaxon(byteDepths);
            if (this.noDepthToOutput().booleanValue()) {
                this.genos.addTaxon((Taxon)this.taxaList.get(currTaxonIndex), taxonGenos, (byte[][])null);
            } else {
                this.genos.addTaxon((Taxon)this.taxaList.get(currTaxonIndex), taxonGenos, byteDepths);
            }
            myLogger.info((Object)("  finished calling genotypes for " + ((Taxon)this.taxaList.get(currTaxonIndex)).getName()));
        }
        myLogger.info((Object)("Finished calling genotypes for " + this.obsTagsForEachTaxon.length + " taxa\n"));
    }

    private byte[] resolveGenosForTaxon(byte[][] depthsForTaxon) {
        int nAlleles = depthsForTaxon.length;
        byte[] depthsAtSite = new byte[nAlleles];
        int nSites = depthsForTaxon[0].length;
        byte[] genos = new byte[nSites];
        for (int site = 0; site < nSites; ++site) {
            for (int allele = 0; allele < nAlleles; ++allele) {
                depthsAtSite[allele] = depthsForTaxon[allele][site];
            }
            genos[site] = this.genoMergeRule.callBasedOnDepth(depthsAtSite);
        }
        return genos;
    }

    private void writeReadsPerSampleReports() {
        myLogger.info((Object)"\nWriting ReadsPerSample log file...");
        String outFileS = this.myOutputDir + File.separator + new File(this.keyFile()).getName();
        outFileS = outFileS.replaceAll(".txt", "_ReadsPerSample.log");
        outFileS = outFileS.replaceAll("_key", "");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(outFileS))), 65536);
            bw.write("FullSampleName\tgoodBarcodedReads\tgoodReadsMatchedToTOPM\n");
            for (String fullSampleName : this.rawReadCountsForFullSampleName.keySet()) {
                bw.write(fullSampleName + "\t" + this.rawReadCountsForFullSampleName.get(fullSampleName) + "\t" + this.matchedReadCountsForFullSampleName.get(fullSampleName) + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Couldn't write to ReadsPerSample log file: " + e));
            e.printStackTrace();
            System.exit(1);
        }
        myLogger.info((Object)"   ...done\n");
    }

    private void printFileNameConventions(String actualFileName) {
        String message = "\n\nError in parsing file name:\n   The raw sequence filename does not contain either 3, 4, or 5 underscore-delimited values.\n   Acceptable file naming conventions include the following (where FLOWCELL indicates the flowcell name and LANE is an integer):\n       FLOWCELL_LANE_fastq.gz\n       FLOWCELL_s_LANE_fastq.gz\n       code_FLOWCELL_s_LANE_fastq.gz\n       FLOWCELL_LANE_fastq.txt.gz\n       FLOWCELL_s_LANE_fastq.txt.gz\n       code_FLOWCELL_s_LANE_fastq.txt.gz\n       FLOWCELL_LANE_qseq.txt.gz\n       FLOWCELL_s_LANE_qseq.txt.gz\n       code_FLOWCELL_s_LANE_qseq.txt.gz\n\n   Actual Filename: " + actualFileName + "\n\n";
        myLogger.error((Object)message);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Production SNP Caller";
    }

    @Override
    public String getToolTipText() {
        return "Production SNP Caller";
    }

    public String inputDirectory() {
        return this.myInputDirectory.value();
    }

    public ProductionSNPCallerPlugin inputDirectory(String value) {
        this.myInputDirectory = new PluginParameter<String>(this.myInputDirectory, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public ProductionSNPCallerPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public ProductionSNPCallerPlugin enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String inputTOPMFile() {
        return this.myProductionTOPM.value();
    }

    public ProductionSNPCallerPlugin inputTOPMFile(String value) {
        this.myProductionTOPM = new PluginParameter<String>(this.myProductionTOPM, value);
        return this;
    }

    public String outputHDF5GenotypesFile() {
        return this.myOutputGenotypes.value();
    }

    public ProductionSNPCallerPlugin outputHDF5GenotypesFile(String value) {
        this.myOutputGenotypes = new PluginParameter<String>(this.myOutputGenotypes, value);
        return this;
    }

    public Double aveSeqErrorRate() {
        return this.myAveSeqErrorRate.value();
    }

    public ProductionSNPCallerPlugin aveSeqErrorRate(Double value) {
        this.myAveSeqErrorRate = new PluginParameter<Double>(this.myAveSeqErrorRate, value);
        return this;
    }

    public Boolean keepGenotypesOpen() {
        return this.myKeepGenotypesOpen.value();
    }

    public ProductionSNPCallerPlugin keepGenotypesOpen(Boolean value) {
        this.myKeepGenotypesOpen = new PluginParameter<Boolean>(this.myKeepGenotypesOpen, value);
        return this;
    }

    public Boolean noDepthToOutput() {
        return this.myNoDepthOutput.value();
    }

    public ProductionSNPCallerPlugin noDepthToOutput(Boolean value) {
        this.myNoDepthOutput = new PluginParameter<Boolean>(this.myNoDepthOutput, value);
        return this;
    }
}

