/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class QseqToTagCountPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(QseqToTagCountPlugin.class);
    String directoryName = null;
    String keyfile = null;
    String enzyme = null;
    int maxGoodReads = 300000000;
    int minCount = 1;
    String outputDir = null;

    public QseqToTagCountPlugin() {
        super(null, false);
    }

    public QseqToTagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  Input directory containing qseq files as text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.\n\n -k  Key file listing barcodes for each sample\n -e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n -s  Max good reads per lane. (Optional. Default is 300,000,000).\n -c  Minimum tag count (default is 1).\n -o  Output directory to contain .cnt files (one per qseq file, defaults to input directory).\n\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        File qseqDirectory = new File(this.directoryName);
        if (!qseqDirectory.isDirectory()) {
            throw new IllegalStateException("The input name you supplied is not a directory.");
        }
        QseqToTagCountPlugin.countTags(this.keyfile, this.enzyme, this.directoryName, this.outputDir, this.maxGoodReads, this.minCount);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-directory", true);
            this.engine.add("-k", "--key-file", true);
            this.engine.add("-e", "--enzyme", true);
            this.engine.add("-s", "--max-reads", true);
            this.engine.add("-c", "--min-count", true);
            this.engine.add("-o", "--output-file", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the location of your .qseq files.");
        }
        this.directoryName = this.engine.getString("-i");
        if (!this.engine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a barcode key file.");
        }
        this.keyfile = this.engine.getString("-k");
        if (this.engine.getBoolean("-e")) {
            this.enzyme = this.engine.getString("-e");
        } else {
            System.out.println("No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.engine.getBoolean("-s")) {
            this.maxGoodReads = Integer.parseInt(this.engine.getString("-s"));
        }
        if (this.engine.getBoolean("-c")) {
            this.minCount = Integer.parseInt(this.engine.getString("-c"));
        }
        this.outputDir = this.engine.getBoolean("-o") ? this.engine.getString("-o") : this.directoryName;
    }

    public static void countTags(String keyFileS, String enzyme, String qseqDirectory, String outputDir, int maxGoodReads, int minCount) {
        String[] countFileNames = null;
        File inputDirectory = new File(qseqDirectory);
        File[] qseqFiles = DirectoryCrawler.listFiles(".*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", inputDirectory.getAbsolutePath());
        if (qseqFiles.length == 0 || qseqFiles == null) {
            System.out.println("Couldn't find any files that end with \"_qseq.txt\" or \"_qseq.txt.gz\" in the supplied directory.");
        } else {
            System.out.println("Using the following .qseq files:");
            countFileNames = new String[qseqFiles.length];
            for (int i = 0; i < qseqFiles.length; ++i) {
                countFileNames[i] = qseqFiles[i].getName().replaceAll("_qseq\\.txt$|_qseq\\.txt\\.gz$", ".cnt");
                System.out.println(qseqFiles[i].getAbsolutePath());
            }
        }
        int allReads = 0;
        int goodBarcodedReads = 0;
        for (int laneNum = 0; laneNum < qseqFiles.length; ++laneNum) {
            ParseBarcodeRead thePBR;
            File outputFile = new File(outputDir + File.separator + countFileNames[laneNum]);
            if (outputFile.isFile()) {
                System.out.println("An output file " + countFileNames[laneNum] + "\n already exists in the output directory for file " + qseqFiles[laneNum] + ".  Skipping.");
                continue;
            }
            TagCountMutable theTC = null;
            System.out.println("Reading qseq file: " + qseqFiles[laneNum]);
            String[] filenameField = qseqFiles[laneNum].getName().split("_");
            if (filenameField.length == 3) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[1]);
            } else if (filenameField.length == 4) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[2]);
            } else if (filenameField.length == 5) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, filenameField[1], filenameField[3]);
            } else {
                System.out.println("Error in parsing file name:");
                System.out.println("   The filename does not contain either 3 or 5 underscore-delimited values.");
                System.out.println("   Expect: flowcell_lane_qseq.txt OR code_flowcell_s_lane_qseq.txt");
                System.out.println("   Filename: " + qseqFiles[laneNum]);
                return;
            }
            System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
            if (thePBR.getBarCodeCount() == 0) {
                System.out.println("No barcodes found.  Skipping this flowcell lane.");
                continue;
            }
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
            }
            try {
                String temp;
                BufferedReader br = qseqFiles[laneNum].getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(qseqFiles[laneNum])))) : new BufferedReader(new FileReader(qseqFiles[laneNum]), 65536);
                String sequence = "";
                String qualityScore = "";
                try {
                    theTC = new TagCountMutable(2, maxGoodReads);
                }
                catch (OutOfMemoryError e) {
                    System.out.println("Your system doesn't have enough memory to store the number of sequencesyou specified.  Try using a smaller value for the maximum number of good reads (-s option).");
                }
                allReads = 0;
                goodBarcodedReads = 0;
                while ((temp = br.readLine()) != null && goodBarcodedReads < maxGoodReads) {
                    String[] jj = temp.split("\t");
                    ++allReads;
                    try {
                        sequence = jj[8];
                        qualityScore = jj[9];
                    }
                    catch (NullPointerException e) {
                        System.out.println("Read a line that lacks a sequence and quality score in fields 9 and 10.  Your file may have been corrupted.");
                        System.exit(0);
                    }
                    ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sequence, qualityScore, false, 0);
                    if (rr != null) {
                        ++goodBarcodedReads;
                        theTC.addReadCount(rr.getRead(), rr.getLength(), 1);
                    }
                    if (allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads);
                }
                System.out.println("Total number of reads in lane=" + allReads);
                System.out.println("Total number of good barcoded reads=" + goodBarcodedReads);
                System.out.println("Timing process (sorting, collapsing, and writing TagCount to file).");
                timePoint1 = System.currentTimeMillis();
                theTC.collapseCounts();
                theTC.writeTagCountFile(outputDir + File.separator + countFileNames[laneNum], TagsByTaxa.FilePacking.Byte, minCount);
                System.out.println("Process took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline c=" + goodBarcodedReads + " e=" + e);
                e.printStackTrace();
            }
            System.out.println("Finished reading " + (laneNum + 1) + " of " + qseqFiles.length + " sequence files.");
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

