/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TOPMSummaryPlugin
extends AbstractPlugin {
    private final Logger myLogger = Logger.getLogger(TOPMSummaryPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String myInputFilename = null;
    private TagsOnPhysicalMap myInputTOPM = null;
    private int myTagCount = 0;
    private int[] myChromosomes;
    private Map<Integer, Integer>[] myTagsPerSite;
    private Map<Integer, Set<Byte>>[] myVariantDefsPerPosition;
    private int myNumUndefinedStrandedTags = 0;
    private Set<Byte> myUndefinedStrandValues = new HashSet<Byte>();
    private String myOutputFilename = null;
    private int[] myNumTagsPerVariantsDefined;
    private TreeSet<Integer>[] myPositionsOnMaxVariantTags;

    public TOPMSummaryPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        int i;
        int i2;
        int m;
        this.myInputTOPM = new TagsOnPhysicalMap(this.myInputFilename, true);
        this.myTagCount = this.myInputTOPM.getTagCount();
        this.myLogger.info((Object)("performFunction: Number of Tags: " + this.myTagCount));
        this.myChromosomes = this.myInputTOPM.getChromosomes();
        Arrays.sort(this.myChromosomes);
        this.myNumTagsPerVariantsDefined = new int[this.myInputTOPM.getMaxNumVariants() + 1];
        this.myPositionsOnMaxVariantTags = new TreeSet[this.myChromosomes.length];
        for (m = 0; m < this.myChromosomes.length; ++m) {
            this.myPositionsOnMaxVariantTags[m] = new TreeSet();
        }
        this.myTagsPerSite = new TreeMap[this.myChromosomes.length];
        for (m = 0; m < this.myChromosomes.length; ++m) {
            this.myTagsPerSite[m] = new TreeMap<Integer, Integer>();
        }
        this.myVariantDefsPerPosition = new TreeMap[this.myChromosomes.length];
        for (m = 0; m < this.myChromosomes.length; ++m) {
            this.myVariantDefsPerPosition[m] = new TreeMap<Integer, Set<Byte>>();
        }
        for (i2 = 0; i2 < this.myTagCount; ++i2) {
            Set<Object> temp;
            Integer count;
            int position;
            byte def;
            byte offset;
            int j;
            int numDefinedVariants;
            ArrayList<Integer> positionsOnTag;
            int startPos = this.myInputTOPM.getStartPosition(i2);
            int endPos = this.myInputTOPM.getEndPosition(i2);
            byte strand = this.myInputTOPM.getStrand(i2);
            int chrom = this.myInputTOPM.getChromosome(i2);
            int index = Arrays.binarySearch(this.myChromosomes, chrom);
            if (strand == 1) {
                if (index < 0) {
                    this.myLogger.error((Object)("performFunction: tag: " + i2 + " chromosome: " + chrom + " not reported by getChromosomes()"));
                    continue;
                }
                if (startPos > endPos) {
                    this.myLogger.error((Object)("performFunction: tag: " + i2 + " invalid state: strand: " + strand + "  start position: " + startPos + "  end position: " + endPos));
                    continue;
                }
                positionsOnTag = new ArrayList<Integer>();
                numDefinedVariants = 0;
                for (j = 0; j < this.myInputTOPM.getMaxNumVariants(); ++j) {
                    offset = this.myInputTOPM.getVariantPosOff(i2, j);
                    def = this.myInputTOPM.getVariantDef(i2, j);
                    if (offset == -128 || def == -128) continue;
                    ++numDefinedVariants;
                    position = startPos + offset;
                    positionsOnTag.add(position);
                    count = this.myTagsPerSite[index].get(position);
                    if (count == null) {
                        this.myTagsPerSite[index].put(position, 1);
                        temp = new HashSet<Byte>();
                        temp.add(def);
                        this.myVariantDefsPerPosition[index].put(position, temp);
                        continue;
                    }
                    this.myTagsPerSite[index].put(position, count + 1);
                    temp = this.myVariantDefsPerPosition[index].get(position);
                    temp.add(def);
                }
                if (numDefinedVariants == this.myInputTOPM.getMaxNumVariants()) {
                    this.myPositionsOnMaxVariantTags[index].addAll(positionsOnTag);
                }
                int n = numDefinedVariants;
                this.myNumTagsPerVariantsDefined[n] = this.myNumTagsPerVariantsDefined[n] + 1;
                continue;
            }
            if (strand == -1) {
                if (index < 0) {
                    this.myLogger.error((Object)("performFunction: tag: " + i2 + " chromosome: " + chrom + " not reported by getChromosomes()"));
                    continue;
                }
                if (startPos < endPos) {
                    this.myLogger.error((Object)("performFunction: tag: " + i2 + " invalid state: strand: " + strand + "  start position: " + startPos + "  end position: " + endPos));
                    continue;
                }
                positionsOnTag = new ArrayList();
                numDefinedVariants = 0;
                for (j = 0; j < this.myInputTOPM.getMaxNumVariants(); ++j) {
                    offset = this.myInputTOPM.getVariantPosOff(i2, j);
                    def = this.myInputTOPM.getVariantDef(i2, j);
                    if (offset == -128 || def == -128) continue;
                    ++numDefinedVariants;
                    position = startPos + offset;
                    positionsOnTag.add(position);
                    count = this.myTagsPerSite[index].get(position);
                    if (count == null) {
                        this.myTagsPerSite[index].put(position, 1);
                        temp = new HashSet();
                        temp.add(def);
                        this.myVariantDefsPerPosition[index].put(position, temp);
                        continue;
                    }
                    this.myTagsPerSite[index].put(position, count + 1);
                    temp = this.myVariantDefsPerPosition[index].get(position);
                    temp.add(def);
                }
                if (numDefinedVariants == this.myInputTOPM.getMaxNumVariants()) {
                    this.myPositionsOnMaxVariantTags[index].addAll(positionsOnTag);
                }
                int n = numDefinedVariants;
                this.myNumTagsPerVariantsDefined[n] = this.myNumTagsPerVariantsDefined[n] + 1;
                continue;
            }
            ++this.myNumUndefinedStrandedTags;
            this.myUndefinedStrandValues.add(strand);
        }
        for (i2 = 0; i2 < this.myChromosomes.length; ++i2) {
            Iterator<Integer> itr = this.myPositionsOnMaxVariantTags[i2].iterator();
            StringBuilder builder = new StringBuilder();
            builder.append("performFunction: Chromosome: ");
            builder.append(this.myChromosomes[i2]);
            builder.append(" Positions on Tags with Max Variants: ");
            boolean first = true;
            while (itr.hasNext()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(itr.next());
            }
            this.myLogger.info((Object)builder.toString());
        }
        this.myLogger.info((Object)("performFunction: Number of Tags with Undefined Strands: " + this.myNumUndefinedStrandedTags));
        Iterator<Byte> itr = this.myUndefinedStrandValues.iterator();
        while (itr.hasNext()) {
            this.myLogger.info((Object)("performFunction: Undefined Strand Value: " + itr.next()));
        }
        int totalSNPs = 0;
        for (i = 0; i < this.myChromosomes.length; ++i) {
            totalSNPs += this.myTagsPerSite[i].size();
            this.myLogger.info((Object)("performFunction: Chromosome: " + this.myChromosomes[i] + " Number of SNPs: " + this.myTagsPerSite[i].size()));
        }
        this.myLogger.info((Object)("performFunction: Total SNPs: " + totalSNPs));
        for (i = 0; i <= this.myInputTOPM.getMaxNumVariants(); ++i) {
            this.myLogger.info((Object)("performFunction: Number of Tags: " + this.myNumTagsPerVariantsDefined[i] + " Has: " + i + " Variants Defined"));
        }
        this.printSummary();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary() {
        BufferedWriter writer = null;
        try {
            writer = Utils.getBufferedWriter(this.myOutputFilename);
            writer.append("Chromosome\tPosition\tNum Tags\tVariant Defs\n");
            for (int c = 0; c < this.myChromosomes.length; ++c) {
                for (Map.Entry<Integer, Integer> entry : this.myTagsPerSite[c].entrySet()) {
                    writer.append(this.myChromosomes[c] + "\t" + entry.getKey() + "\t" + entry.getValue() + "\t");
                    Set<Byte> defSet = this.myVariantDefsPerPosition[c].get(entry.getKey());
                    Iterator<Byte> itr2 = defSet.iterator();
                    boolean notFirst = false;
                    while (itr2.hasNext()) {
                        if (notFirst) {
                            writer.append(",");
                        } else {
                            notFirst = true;
                        }
                        writer.append(NucleotideAlignmentConstants.getHaplotypeNucleotide(itr2.next()));
                    }
                    writer.append("\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void printUsage() {
        this.myLogger.info((Object)"\nThe options for the TOPMSummaryPlugin:\n-input Input TOPM\n-output Output Filename\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-input", "-input", true);
            this.myArgsEngine.add("-output", "-output", true);
        }
        this.myArgsEngine.parse(args);
        this.myInputFilename = this.myArgsEngine.getString("-input");
        if (this.myInputFilename == null || this.myInputFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("TOPMSummaryPlugin: setParameters: Must define input file");
        }
        File inputFile = new File(this.myInputFilename);
        if (!inputFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("TOPMSummaryPlugin: setParameters: The input file doesn't exist: " + this.myInputFilename);
        }
        this.myOutputFilename = this.myArgsEngine.getString("-output");
        if (this.myOutputFilename == null || this.myOutputFilename.length() == 0) {
            this.printUsage();
            throw new IllegalArgumentException("TOPMSummaryPlugin: setParameters: Must define output file");
        }
        File outputFile = new File(this.myOutputFilename);
        if (outputFile.exists()) {
            this.printUsage();
            throw new IllegalArgumentException("TOPMSummaryPlugin: setParameters: The output file already exists: " + this.myOutputFilename);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

