/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.jet.random.Binomial;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.maizegenetics.analysis.gbs.SimpleGenotypeSBit;
import net.maizegenetics.dna.map.TagGeneticMappingInfo;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.util.OpenBitSet;

public class TagAgainstAnchorHypothesis {
    SimpleGenotypeSBit anchor;
    double[] anchorMaf;
    int[] chromosomeNumber;
    int[] chrStartIndex;
    int[] chrEndIndex;
    TagsByTaxaByteHDF5TagGroups tbt;
    int[] tbtRedirect;
    TagsOnPhysicalMapV3 topm;
    TagMappingInfoV3.Aligner blockAligner;
    double pThresh = 1.0E-6;
    int minCount = 20;
    int minTagAlleleIntersection = 4;
    int testSiteNum = 100;
    Task[] jobs;
    static int threadNumPerCore = 32;
    int threadNum;

    public TagAgainstAnchorHypothesis(String hapMapHDF5, String tbtHDF5, String topmFileS, String software, int testSiteNum, double pThresh, int minCount, int coreNum) {
        this.testSiteNum = testSiteNum;
        this.pThresh = pThresh;
        this.minCount = minCount;
        this.loadAnchorMap(hapMapHDF5);
        this.loadTBT(tbtHDF5);
        this.loadTOPM(topmFileS);
        this.loadBlockAligner(software);
        this.calculateThreadNum(coreNum);
        this.MTMapping();
    }

    public static int getChunkNum(String tbtHDF5, int chunkSize) {
        TagsByTaxaByteHDF5TagGroups tbt = new TagsByTaxaByteHDF5TagGroups(tbtHDF5);
        int tagNum = tbt.getTagCount();
        int chunkNum = 0;
        int left = tagNum % chunkSize;
        chunkNum = left == 0 ? tagNum / chunkSize : tagNum / chunkSize + 1;
        System.out.println("TBT has " + tagNum + " tags");
        System.out.println("TBT will be devided into " + chunkNum + " chunks, " + chunkSize + " tags each");
        if (left != 0) {
            System.out.println("The last chunk has " + left + " tags");
        }
        System.out.println("The index of chunk are used submit parallel computation to different node");
        System.out.println("Tags in each chunk will be multi-threaded in one node");
        return chunkNum;
    }

    public void MTMapping() {
        int chunkNum = this.topm.getChunkNum();
        TagGeneticMappingInfo[][] gmChunk = new TagGeneticMappingInfo[this.topm.getMappingNum()][this.topm.getChunkSize()];
        String[] dataSetNames = this.topm.creatTagGeneticMappingInfoDatasets(0, this.topm.getMappingNum());
        for (int i = 0; i < chunkNum; ++i) {
            int j;
            int j2;
            int j3;
            int[] threadEndTagIndex;
            int[] threadStartTagIndex;
            int chunkStartTagIndex = i * this.topm.getChunkSize();
            int chunkEndTagIndex = chunkStartTagIndex + this.topm.getChunkSize();
            if (chunkEndTagIndex > this.topm.getTagCount()) {
                chunkEndTagIndex = this.topm.getTagCount();
            }
            int actualChunkSize = chunkEndTagIndex - chunkStartTagIndex;
            int[] chunkTopm2TbtIndex = new int[actualChunkSize];
            TagMappingInfoV3[][] tmiChunk = this.topm.getMappingInfoChunk(chunkStartTagIndex);
            int[][] blockChrPos = new int[actualChunkSize][];
            for (int j4 = 0; j4 < actualChunkSize; ++j4) {
                int topmTagIndex = chunkStartTagIndex + j4;
                blockChrPos[j4] = this.topm.getUniqueMappingOfAligner(topmTagIndex, this.blockAligner);
                long[] t = this.topm.getTag(topmTagIndex);
                int hit = this.tbt.getTagIndex(t);
                chunkTopm2TbtIndex[j4] = hit < 0 ? Integer.MIN_VALUE : hit;
            }
            int left = actualChunkSize % this.threadNum;
            int baseSize = actualChunkSize / this.threadNum;
            if (baseSize == 0) {
                threadStartTagIndex = new int[left];
                threadEndTagIndex = new int[left];
                for (j3 = 0; j3 < threadStartTagIndex.length; ++j3) {
                    threadStartTagIndex[j3] = chunkStartTagIndex + j3;
                    threadEndTagIndex[j3] = threadStartTagIndex[j3] + 1;
                }
            } else {
                int[] threadSize = new int[this.threadNum];
                threadStartTagIndex = new int[this.threadNum];
                threadEndTagIndex = new int[this.threadNum];
                for (j3 = 0; j3 < left; ++j3) {
                    threadSize[j3] = baseSize + 1;
                }
                for (j3 = left; j3 < this.threadNum; ++j3) {
                    threadSize[j3] = baseSize;
                }
                threadStartTagIndex[0] = chunkStartTagIndex;
                threadEndTagIndex[0] = threadStartTagIndex[0] + threadSize[0];
                for (j3 = 1; j3 < this.threadNum; ++j3) {
                    threadStartTagIndex[j3] = threadEndTagIndex[j3 - 1];
                    threadEndTagIndex[j3] = threadStartTagIndex[j3] + threadSize[j3];
                }
            }
            int actualThreadNum = threadStartTagIndex.length;
            this.jobs = new Task[actualThreadNum];
            Thread[] mts = new Thread[actualThreadNum];
            long lastTimePoint = this.getCurrentTimeNano();
            for (j2 = 0; j2 < actualThreadNum; ++j2) {
                this.jobs[j2] = new Task(threadStartTagIndex[j2], threadEndTagIndex[j2], chunkStartTagIndex, chunkTopm2TbtIndex, tmiChunk, blockChrPos);
            }
            System.out.println("Loading this chunk to multiple threads took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
            System.out.println("Multiple threading mapping in progress...");
            lastTimePoint = this.getCurrentTimeNano();
            for (j2 = 0; j2 < actualThreadNum; ++j2) {
                mts[j2] = new Thread(this.jobs[j2]);
                mts[j2].start();
            }
            for (j2 = 0; j2 < actualThreadNum; ++j2) {
                try {
                    mts[j2].join();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
            System.out.println(chunkStartTagIndex / this.topm.getChunkSize() + 1 + " chunks are mapped. " + this.topm.getChunkNum() + " chunks in total");
            System.out.println("Each LD compirison took " + (double)this.getTimeSpanNano(lastTimePoint) / (double)actualChunkSize / (double)this.testSiteNum / (double)this.topm.getMappingNum() + " nano seconds");
            System.out.println("Multiple threading mapping took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
            int cnt = 0;
            for (j = 0; j < this.jobs.length; ++j) {
                TagGeneticMappingInfo[][] sub = this.jobs[j].getResult();
                for (int k = 0; k < sub.length; ++k) {
                    for (int u = 0; u < sub[0].length; ++u) {
                        gmChunk[u][cnt + k] = sub[k][u];
                    }
                }
                cnt += sub.length;
            }
            if (cnt < this.topm.getChunkSize()) {
                for (j = cnt; j < this.topm.getChunkSize(); ++j) {
                    for (int k = 0; k < this.topm.getMappingNum(); ++k) {
                        gmChunk[k][j] = new TagGeneticMappingInfo();
                    }
                }
            }
            this.topm.writeTagGeneticMappingInfoDataSets(dataSetNames, gmChunk, i);
            System.out.println("Mapping result from chunk " + i + "(Index) was written\n");
            System.gc();
        }
    }

    private void calculateThreadNum(int coreNum) {
        int numOfProcessors = Runtime.getRuntime().availableProcessors();
        if (coreNum < 0) {
            this.threadNum = numOfProcessors * threadNumPerCore;
        } else {
            if (coreNum == 0) {
                System.out.println("Core number = 0, This runs at least on 1 thread. Quit.");
                System.exit(0);
            }
            threadNumPerCore = 1;
            this.threadNum = coreNum * threadNumPerCore;
            System.out.println("TBT will be mapped by " + this.threadNum + " tasks");
            System.out.println("Each core runs 1 tasks, or 1 threads");
        }
        int acutualUseCoreNum = numOfProcessors;
        if (acutualUseCoreNum > this.threadNum) {
            acutualUseCoreNum = this.threadNum;
        }
        System.out.println("This node has " + numOfProcessors + " processors. Will use " + acutualUseCoreNum + " processors");
        System.out.println("TOPM will be mapped by " + this.threadNum + " threads");
        System.out.println("Each core runs " + threadNumPerCore + " threads");
        System.out.println("Each TOPM chunk has " + this.topm.getChunkSize() + " tags, which will be split and mapped by the " + this.threadNum + " threads");
        System.out.println("Each thread will map " + this.topm.getChunkSize() / this.threadNum + " tags");
        System.out.println("For each tags, " + this.topm.getMappingNum() + " hypothesis will be tested at " + this.testSiteNum + " adjacent sites");
        int left = this.topm.getTagCount() % this.topm.getChunkSize();
        if (left != 0) {
            System.out.println("The last TOPM chunk has " + left + " tags");
        }
        System.out.println("");
    }

    public double fastTestSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, double maf, Binomial binomFunc) {
        int cdfCount;
        double minorProb;
        double result = 1.0;
        int tagMinorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        int sumTagAllele = tagMinorCount + (tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor));
        if (sumTagAllele < 4) {
            return result;
        }
        double ratio = (double)tagMinorCount / (double)sumTagAllele;
        if (tagMinorCount < tagMajorCount) {
            minorProb = maf;
            cdfCount = tagMinorCount;
        } else {
            minorProb = 1.0 - maf;
            cdfCount = tagMajorCount;
        }
        if (ratio - minorProb < -0.003) {
            return result;
        }
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = binomFunc.cdf(cdfCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    public double testSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, double maf, Binomial binomFunc) {
        double result = 1.0;
        int tagMinorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        int sumTagAllele = tagMinorCount + (tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor));
        if (sumTagAllele < 4) {
            return result;
        }
        double minorProb = tagMinorCount < tagMajorCount ? maf : 1.0 - maf;
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = tagMinorCount < tagMajorCount ? binomFunc.cdf(tagMinorCount) : binomFunc.cdf(tagMajorCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    public static double testSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, Binomial binomFunc) {
        double result = 1.0;
        int minorCount = 0;
        int tagMinorCount = 0;
        int majorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor);
        minorCount = (int)obsMinor.cardinality();
        majorCount = (int)obsMajor.cardinality();
        int sumAllele = minorCount + majorCount;
        int sumTagAllele = tagMinorCount + tagMajorCount;
        if (sumTagAllele < 4) {
            return result;
        }
        double minorProb = tagMinorCount < tagMajorCount ? (double)minorCount / (double)sumAllele : (double)majorCount / (double)sumAllele;
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = tagMinorCount < tagMajorCount ? binomFunc.cdf(tagMinorCount) : binomFunc.cdf(tagMajorCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    private long[] getTagsInBits(TagsByTaxaByte aTBT, int tagIndex, int[] reDirect, int anchorTaxa) {
        int lgPerSite = anchorTaxa / 64 + 1;
        long[] seq = new long[lgPerSite];
        for (int j = 0; j < aTBT.getTaxaCount(); ++j) {
            if (reDirect[j] < 0) continue;
            int index = reDirect[j] / 64;
            int offset = reDirect[j] % 64;
            if (aTBT.getReadCountForTagTaxon(tagIndex, j) <= 0) continue;
            seq[index] = seq[index] | 1L << offset;
        }
        return seq;
    }

    private void redirect() {
        long lastTimePoint = this.getCurrentTimeNano();
        this.tbtRedirect = new int[this.tbt.getTaxaCount()];
        for (int i = 0; i < this.tbtRedirect.length; ++i) {
            this.tbtRedirect[i] = this.anchor.getTaxonIndex(this.tbt.getTaxaName(i));
        }
        System.out.println("Taxa redirection took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds\n");
    }

    private void loadBlockAligner(String software) {
        this.blockAligner = TagMappingInfoV3.Aligner.getAlignerFromName(software);
        if (this.blockAligner == null) {
            System.out.println("Please input correct aligner name, currently sopport Bowtie2, BWA and Blast");
            System.exit(1);
        }
    }

    private void loadTOPM(String topmFileS) {
        long lastTimePoint = this.getCurrentTimeNano();
        this.topm = new TagsOnPhysicalMapV3(topmFileS);
        System.out.println("Loading TOPM HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds\n");
    }

    private void loadTBT(String tbtHDF5) {
        long lastTimePoint = this.getCurrentTimeNano();
        this.tbt = new TagsByTaxaByteHDF5TagGroups(tbtHDF5);
        System.out.println("Loading TBT HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
        System.out.println("TBT has " + this.tbt.getTagCount() + " tags and " + this.tbt.getTaxaCount() + " taxa\n");
        this.redirect();
    }

    private void loadAnchorMap(String hapMapHDF5) {
        System.out.println("Start loading anchor map");
        long lastTimePoint = this.getCurrentTimeNano();
        this.anchor = new SimpleGenotypeSBit(hapMapHDF5);
        System.out.println("Loading hapmap (SimpleGenotypeSBit) HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
        System.out.println("The anchor map has " + this.anchor.getSiteNum() + " sites and " + this.anchor.getTaxaNum() + " taxa");
        this.chromosomeNumber = this.anchor.chromosomeNumber;
        this.chrStartIndex = this.anchor.chrStartIndex;
        this.chrEndIndex = this.anchor.chrEndIndex;
        this.anchorMaf = this.anchor.maf;
        System.gc();
        this.screenPrintGbMemoryCurrentUse();
        this.screenPrintGbMemoryAvailable();
        System.out.println();
    }

    private double getTimeSpanSecond(long lastTimePoint) {
        return (double)this.getTimeSpanNano(lastTimePoint) / 1.0E9;
    }

    private long getTimeSpanNano(long lastTimePoint) {
        return this.getCurrentTimeNano() - lastTimePoint;
    }

    private long getCurrentTimeNano() {
        return System.nanoTime();
    }

    private String getCurrentTimeHR() {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String str = sd.format(date);
        return str;
    }

    private double getGbMemoryAvailable() {
        return (double)(Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024.0 / 1024.0 / 1024.0;
    }

    private double getGbMemoryCurrentUse() {
        return (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0 / 1024.0;
    }

    private void screenPrintTimeSpanSecond(long lastTimePoint) {
        System.out.println("Time span is " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
    }

    private void screenPrintTimeSpanNano(long lastTimePoint) {
        System.out.println("Time span is " + String.valueOf(this.getTimeSpanNano(lastTimePoint)) + " ns");
    }

    private void screenPrintCurrentTimeHR() {
        System.out.println("Current time is " + this.getCurrentTimeHR());
    }

    private void screenPrintGbMemoryAvailable() {
        System.out.println("Available memory is " + String.valueOf(this.getGbMemoryAvailable()) + " GB");
    }

    private void screenPrintGbMemoryCurrentUse() {
        System.out.println("Current memory in use is " + String.valueOf(this.getGbMemoryCurrentUse()) + " GB");
    }

    private class ScanChromosome {
        int chrIndex;
        int chrStartIndex;
        int chrEndIndex;
        OpenBitSet obsTdist;
        Binomial binomFunc = new Binomial(5, 0.5, (RandomEngine)new MersenneTwister());
        double[][] resultReport;
        double sigThreshold;
        int minSigPos = Integer.MIN_VALUE;
        int maxSigPos = Integer.MIN_VALUE;
        int step = 1;
        double bionomialThreshold = 0.2;
        int blockPosition = Integer.MIN_VALUE;
        int blockWindow = 64;

        public ScanChromosome(long[] tdist, double[][] resultReport, int chrIndex, int chrStartIndex, int chrEndIndex, double sigThreshold, int step, int blockPosition) {
            this.obsTdist = new OpenBitSet(tdist, tdist.length);
            this.resultReport = resultReport;
            this.chrIndex = chrIndex;
            this.chrStartIndex = chrStartIndex;
            this.chrEndIndex = chrEndIndex;
            this.sigThreshold = sigThreshold;
            this.blockPosition = blockPosition;
            this.step = step;
        }

        public void scan() {
            long tests = 0L;
            int bestSite = -1;
            int countSig = 0;
            double bestP = 2.0;
            for (int i = this.chrStartIndex; i < this.chrEndIndex; i += this.step) {
                if (Math.abs(TagAgainstAnchorHypothesis.this.anchor.getPosition(i) - this.blockPosition) < this.blockWindow) continue;
                OpenBitSet obsMajor = TagAgainstAnchorHypothesis.this.anchor.obsMajor[i];
                OpenBitSet obsMinor = TagAgainstAnchorHypothesis.this.anchor.obsMinor[i];
                if (obsMinor.cardinality() > 4L) {
                    double p = TagAgainstAnchorHypothesis.this.fastTestSites(this.obsTdist, obsMajor, obsMinor, TagAgainstAnchorHypothesis.this.anchorMaf[i], this.binomFunc);
                    if (p < bestP) {
                        bestP = p;
                        bestSite = i;
                    }
                    if (p < this.sigThreshold) {
                        ++countSig;
                        if (this.minSigPos == Integer.MIN_VALUE) {
                            this.minSigPos = TagAgainstAnchorHypothesis.this.anchor.getPosition(i);
                        }
                        this.maxSigPos = TagAgainstAnchorHypothesis.this.anchor.getPosition(i);
                    }
                }
                ++tests;
            }
            int chr = TagAgainstAnchorHypothesis.this.anchor.getChromosomeNumber(bestSite);
            double[] result = new double[]{chr, bestSite, TagAgainstAnchorHypothesis.this.anchor.getPosition(bestSite), bestP, countSig};
            this.resultReport[this.chrIndex] = result;
        }
    }

    class Task
    implements Runnable {
        int tagStartIndex;
        int chunkStartTagIndex;
        TagsByTaxaByte subTBT = null;
        TagMappingInfoV3[][] tmiChunk = null;
        int[][] blockChrPos = null;
        int[] chunkTopm2TbtIndex;
        int subTBTSize;
        TagGeneticMappingInfo[][] gmResult = null;
        HashMap<Integer, Integer> subtbt2ChunkTopmHash;

        Task(int tagStartIndex, int tagEndIndex, int chunkStartTagIndex, int[] subTopm2TbtIndex, TagMappingInfoV3[][] tmiChunk, int[][] blockChrPos) {
            this.chunkStartTagIndex = chunkStartTagIndex;
            this.chunkTopm2TbtIndex = subTopm2TbtIndex;
            this.tmiChunk = tmiChunk;
            this.blockChrPos = blockChrPos;
            this.buildHash(tagStartIndex, tagEndIndex);
            this.buildSubTBT(tagStartIndex, tagEndIndex);
        }

        private void buildHash(int tagStartIndex, int tagEndIndex) {
            this.subtbt2ChunkTopmHash = new HashMap();
            int cnt = 0;
            int offset = tagStartIndex - this.chunkStartTagIndex;
            for (int i = 0; i < tagEndIndex - tagStartIndex; ++i) {
                if (this.chunkTopm2TbtIndex[i + offset] < 0) continue;
                this.subtbt2ChunkTopmHash.put(cnt, i + offset);
                ++cnt;
            }
            this.subTBTSize = cnt;
        }

        private void buildSubTBT(int tagStartIndex, int tagEndIndex) {
            this.tagStartIndex = tagStartIndex;
            int subTopmSize = tagEndIndex - tagStartIndex;
            this.populateResult(subTopmSize);
            if (this.subTBTSize == 0) {
                return;
            }
            long[][] tags = new long[TagAgainstAnchorHypothesis.this.tbt.getTagSizeInLong()][this.subTBTSize];
            byte[] tagLength = new byte[this.subTBTSize];
            byte[][] tagDist = new byte[TagAgainstAnchorHypothesis.this.tbt.getTaxaCount()][this.subTBTSize];
            String[] namesForTaxa = TagAgainstAnchorHypothesis.this.tbt.getTaxaNames();
            for (int i = 0; i < this.subTBTSize; ++i) {
                int j;
                int tbtTagIndex = this.chunkTopm2TbtIndex[this.subtbt2ChunkTopmHash.get(i)];
                long[] t = TagAgainstAnchorHypothesis.this.tbt.getTag(tbtTagIndex);
                for (j = 0; j < tags.length; ++j) {
                    tags[j][i] = t[j];
                }
                tagLength[i] = (byte)TagAgainstAnchorHypothesis.this.tbt.getTagLength(tbtTagIndex);
                for (j = 0; j < TagAgainstAnchorHypothesis.this.tbt.getTaxaCount(); ++j) {
                    tagDist[j][i] = (byte)TagAgainstAnchorHypothesis.this.tbt.getReadCountForTagTaxon(tbtTagIndex, j);
                }
            }
            this.subTBT = new TagsByTaxaByte(tags, tagLength, tagDist, namesForTaxa);
        }

        private void populateResult(int subTopmSize) {
            this.gmResult = new TagGeneticMappingInfo[subTopmSize][TagAgainstAnchorHypothesis.this.topm.getMappingNum()];
            for (int i = 0; i < this.gmResult.length; ++i) {
                for (int j = 0; j < TagAgainstAnchorHypothesis.this.topm.getMappingNum(); ++j) {
                    this.gmResult[i][j] = new TagGeneticMappingInfo();
                }
            }
        }

        public TagGeneticMappingInfo[][] getResult() {
            return this.gmResult;
        }

        @Override
        public void run() {
            if (this.subTBT == null) {
                return;
            }
            long lastTimePoint = TagAgainstAnchorHypothesis.this.getCurrentTimeNano();
            ArrayList resultList = new ArrayList();
            int blockChr = Integer.MIN_VALUE;
            int blockPos = Integer.MIN_VALUE;
            int blastPos = Integer.MIN_VALUE;
            int bestAlignment = Integer.MIN_VALUE;
            int refDiv = Integer.MIN_VALUE;
            double[][] theResults = new double[1][];
            int offset = this.tagStartIndex - this.chunkStartTagIndex;
            for (int i = 0; i < this.subTBT.getTagCount(); ++i) {
                if (this.subTBT.getNumberOfTaxaWithTag(i) < TagAgainstAnchorHypothesis.this.minCount) continue;
                int chunkTopmTagIndex = this.subtbt2ChunkTopmHash.get(i);
                int[] chrPos = this.blockChrPos[chunkTopmTagIndex];
                if (chrPos == null) {
                    blockChr = Integer.MIN_VALUE;
                    blockPos = Integer.MIN_VALUE;
                } else {
                    blockChr = chrPos[0];
                    blockPos = chrPos[1];
                }
                long[] testTag = this.subTBT.getTag(i);
                long[] testTagDist = TagAgainstAnchorHypothesis.this.getTagsInBits(this.subTBT, i, TagAgainstAnchorHypothesis.this.tbtRedirect, TagAgainstAnchorHypothesis.this.anchor.getTaxaNum());
                for (int j = 0; j < TagAgainstAnchorHypothesis.this.topm.getMappingNum(); ++j) {
                    TagGeneticMappingInfo tgmi;
                    int siteIndex;
                    TagMappingInfoV3 tmi = this.tmiChunk[j][chunkTopmTagIndex];
                    if (tmi.chromosome < 0 || (siteIndex = TagAgainstAnchorHypothesis.this.anchor.getSiteIndex(tmi.chromosome, tmi.startPosition)) == Integer.MIN_VALUE) continue;
                    int[] siteIndexRange = TagAgainstAnchorHypothesis.this.anchor.getAdjacentSiteIndexRange(siteIndex, TagAgainstAnchorHypothesis.this.testSiteNum);
                    blastPos = tmi.chromosome == blockChr ? blockPos : Integer.MIN_VALUE;
                    ScanChromosome sc = new ScanChromosome(testTagDist, theResults, 0, siteIndexRange[0], siteIndexRange[1], TagAgainstAnchorHypothesis.this.pThresh, 1, blastPos);
                    sc.scan();
                    this.gmResult[this.subtbt2ChunkTopmHash.get((Object)Integer.valueOf((int)i)).intValue() - offset][j] = tgmi = new TagGeneticMappingInfo(theResults[0][3], (int)theResults[0][0], (int)theResults[0][2], (int)theResults[0][4], sc.maxSigPos - sc.minSigPos);
                }
            }
        }
    }
}

