/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.IOException;
import java.io.Reader;
import net.maizegenetics.analysis.gbs.neobio.AlignmentBlock;
import net.maizegenetics.analysis.gbs.neobio.Factor;
import net.maizegenetics.analysis.gbs.neobio.FactorSequence;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.OutMatrix;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignmentAlgorithm;
import net.maizegenetics.analysis.gbs.neobio.Smawk;

public abstract class CrochemoreLandauZivUkelson
extends PairwiseAlignmentAlgorithm {
    protected static final byte STOP_DIRECTION = 0;
    protected static final byte LEFT_DIRECTION = 1;
    protected static final byte DIAGONAL_DIRECTION = 2;
    protected static final byte TOP_DIRECTION = 3;
    protected FactorSequence seq1;
    protected FactorSequence seq2;
    protected AlignmentBlock[][] block_table;
    protected int num_rows;
    protected int num_cols;
    protected Smawk smawk = new Smawk();
    protected OutMatrix out_matrix = new OutMatrix();

    @Override
    protected void loadSequencesInternal(Reader input1, Reader input2) throws IOException, InvalidSequenceException {
        this.seq1 = new FactorSequence(input1);
        this.seq2 = new FactorSequence(input2);
        this.num_rows = this.seq1.numFactors();
        this.num_cols = this.seq2.numFactors();
    }

    @Override
    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.block_table = null;
    }

    @Override
    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeBlockTable();
        PairwiseAlignment alignment = this.buildOptimalAlignment();
        this.block_table = null;
        return alignment;
    }

    @Override
    protected int computeScore() throws IncompatibleScoringSchemeException {
        this.computeBlockTable();
        int score = this.locateScore();
        this.block_table = null;
        return score;
    }

    protected void computeBlockTable() throws IncompatibleScoringSchemeException {
        int c;
        this.block_table = new AlignmentBlock[this.num_rows][this.num_cols];
        int max_length = Math.max(this.seq1.numChars(), this.seq2.numChars());
        this.out_matrix.init(max_length, this.scoring.maxAbsoluteScore());
        Factor factor1 = this.seq1.getRootFactor();
        Factor factor2 = this.seq2.getRootFactor();
        if (factor1.getSerialNumber() != 0 || factor2.getSerialNumber() != 0) {
            throw new IndexOutOfBoundsException("Unexpected factor index.");
        }
        this.block_table[0][0] = this.createRootBlock(factor1, factor2);
        for (c = 1; c < this.num_cols; ++c) {
            factor2 = factor2.getNext();
            if (c < this.num_cols - 1 && factor2.getSerialNumber() != c) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            this.block_table[0][c] = this.createFirstRowBlock(factor1, factor2, c);
        }
        for (int r = 1; r < this.num_rows; ++r) {
            factor1 = factor1.getNext();
            if (r < this.num_rows - 1 && factor1.getSerialNumber() != r) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            factor2 = this.seq2.getRootFactor();
            if (factor2.getSerialNumber() != 0) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            this.block_table[r][0] = this.createFirstColumnBlock(factor1, factor2, r);
            for (c = 1; c < this.num_cols; ++c) {
                factor2 = factor2.getNext();
                if (c < this.num_cols - 1 && factor2.getSerialNumber() != c) {
                    throw new IndexOutOfBoundsException("Unexpected factor index.");
                }
                this.block_table[r][c] = this.createBlock(factor1, factor2, r, c);
            }
        }
    }

    protected int[][] assembleDistMatrix(AlignmentBlock block, int dim, int r, int c, int lc) {
        AlignmentBlock ancestor;
        int i;
        int[][] dist = new int[dim][];
        Factor parent = block.factor2.getAncestor();
        for (i = lc - 1; i >= 0; --i) {
            block.ancestor[i] = ancestor = this.block_table[r][parent.getSerialNumber()];
            dist[i] = ancestor.dist_column;
            parent = parent.getAncestor();
        }
        dist[lc] = block.dist_column;
        block.ancestor[lc] = block;
        parent = block.factor1.getAncestor();
        for (i = lc + 1; i < dim; ++i) {
            block.ancestor[i] = ancestor = this.block_table[parent.getSerialNumber()][c];
            dist[i] = ancestor.dist_column;
            parent = parent.getAncestor();
        }
        return dist;
    }

    protected int[] assembleInputBorder(int dim, int r, int c, int lr) {
        AlignmentBlock left = null;
        AlignmentBlock top = null;
        int[] input = new int[dim];
        if (c > 0) {
            left = this.block_table[r][c - 1];
        }
        if (r > 0) {
            top = this.block_table[r - 1][c];
        }
        for (int i = 0; i < dim; ++i) {
            if (i < lr) {
                if (left != null) {
                    input[i] = left.output_border[left.factor2.length() + i];
                    continue;
                }
                input[i] = -1073741824;
                continue;
            }
            if (i == lr) {
                if (left != null) {
                    input[i] = left.output_border[left.factor2.length() + i];
                    continue;
                }
                input[i] = top.output_border[i - lr];
                continue;
            }
            input[i] = top != null ? top.output_border[i - lr] : -1073741824;
        }
        return input;
    }

    protected void traverseBlock(AlignmentBlock block, int source, StringBuffer gapped_seq1, StringBuffer tag_line, StringBuffer gapped_seq2) throws IncompatibleScoringSchemeException {
        while (block.direction[source] != 0) {
            char char1 = block.factor1.getNewChar();
            char char2 = block.factor2.getNewChar();
            switch (block.direction[source]) {
                case 1: {
                    gapped_seq1.insert(0, '-');
                    tag_line.insert(0, ' ');
                    gapped_seq2.insert(0, char2);
                    block = this.getLeftPrefix(block);
                    break;
                }
                case 2: {
                    gapped_seq1.insert(0, char1);
                    if (char1 == char2) {
                        if (this.useMatchTag()) {
                            tag_line.insert(0, '|');
                        } else {
                            tag_line.insert(0, char1);
                        }
                    } else if (this.scoreSubstitution(char1, char2) > 0) {
                        tag_line.insert(0, '+');
                    } else {
                        tag_line.insert(0, ' ');
                    }
                    gapped_seq2.insert(0, char2);
                    block = this.getDiagonalPrefix(block);
                    --source;
                    break;
                }
                case 3: {
                    gapped_seq1.insert(0, char1);
                    tag_line.insert(0, ' ');
                    gapped_seq2.insert(0, '-');
                    block = this.getTopPrefix(block);
                    --source;
                }
            }
        }
    }

    protected AlignmentBlock getLeftPrefix(AlignmentBlock block) {
        int prefix_row = block.factor1.getSerialNumber();
        int prefix_col = block.factor2.getAncestorSerialNumber();
        return this.block_table[prefix_row][prefix_col];
    }

    protected AlignmentBlock getDiagonalPrefix(AlignmentBlock block) {
        int prefix_row = block.factor1.getAncestorSerialNumber();
        int prefix_col = block.factor2.getAncestorSerialNumber();
        return this.block_table[prefix_row][prefix_col];
    }

    protected AlignmentBlock getTopPrefix(AlignmentBlock block) {
        int prefix_row = block.factor1.getAncestorSerialNumber();
        int prefix_col = block.factor2.getSerialNumber();
        return this.block_table[prefix_row][prefix_col];
    }

    protected abstract AlignmentBlock createRootBlock(Factor var1, Factor var2) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createFirstRowBlock(Factor var1, Factor var2, int var3) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createFirstColumnBlock(Factor var1, Factor var2, int var3) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createBlock(Factor var1, Factor var2, int var3, int var4) throws IncompatibleScoringSchemeException;

    protected abstract PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException;

    protected abstract int locateScore();
}

