/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.IOException;
import java.io.Reader;
import net.maizegenetics.analysis.gbs.neobio.CharSequence;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignmentAlgorithm;

public class NeedlemanWunsch
extends PairwiseAlignmentAlgorithm {
    protected CharSequence seq1;
    protected CharSequence seq2;
    protected int[][] matrix;

    @Override
    protected void loadSequencesInternal(Reader input1, Reader input2) throws IOException, InvalidSequenceException {
        this.seq1 = new CharSequence(input1);
        this.seq2 = new CharSequence(input2);
    }

    @Override
    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.matrix = null;
    }

    @Override
    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeMatrix();
        PairwiseAlignment alignment = this.buildOptimalAlignment();
        this.matrix = null;
        return alignment;
    }

    protected void computeMatrix() throws IncompatibleScoringSchemeException {
        int c;
        int rows = this.seq1.length() + 1;
        int cols = this.seq2.length() + 1;
        this.matrix = new int[rows][cols];
        this.matrix[0][0] = 0;
        for (c = 1; c < cols; ++c) {
            this.matrix[0][c] = this.matrix[0][c - 1] + this.scoreInsertion(this.seq2.charAt(c));
        }
        for (int r = 1; r < rows; ++r) {
            this.matrix[r][0] = this.matrix[r - 1][0] + this.scoreDeletion(this.seq1.charAt(r));
            for (c = 1; c < cols; ++c) {
                int ins = this.matrix[r][c - 1] + this.scoreInsertion(this.seq2.charAt(c));
                int sub = this.matrix[r - 1][c - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c));
                int del = this.matrix[r - 1][c] + this.scoreDeletion(this.seq1.charAt(r));
                this.matrix[r][c] = this.max(ins, sub, del);
            }
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer gapped_seq1 = new StringBuffer();
        StringBuffer score_tag_line = new StringBuffer();
        StringBuffer gapped_seq2 = new StringBuffer();
        int r = this.matrix.length - 1;
        int c = this.matrix[r].length - 1;
        int max_score = this.matrix[r][c];
        while (r > 0 || c > 0) {
            int sub;
            if (c > 0 && this.matrix[r][c] == this.matrix[r][c - 1] + this.scoreInsertion(this.seq2.charAt(c))) {
                gapped_seq1.insert(0, '-');
                score_tag_line.insert(0, ' ');
                gapped_seq2.insert(0, this.seq2.charAt(c));
                --c;
                continue;
            }
            if (r > 0 && c > 0 && this.matrix[r][c] == this.matrix[r - 1][c - 1] + (sub = this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c)))) {
                gapped_seq1.insert(0, this.seq1.charAt(r));
                if (this.seq1.charAt(r) == this.seq2.charAt(c)) {
                    if (this.useMatchTag()) {
                        score_tag_line.insert(0, '|');
                    } else {
                        score_tag_line.insert(0, this.seq1.charAt(r));
                    }
                } else if (sub > 0) {
                    score_tag_line.insert(0, '+');
                } else {
                    score_tag_line.insert(0, ' ');
                }
                gapped_seq2.insert(0, this.seq2.charAt(c));
                --r;
                --c;
                continue;
            }
            gapped_seq1.insert(0, this.seq1.charAt(r));
            score_tag_line.insert(0, ' ');
            gapped_seq2.insert(0, '-');
            --r;
        }
        return new PairwiseAlignment(gapped_seq1.toString(), score_tag_line.toString(), gapped_seq2.toString(), max_score);
    }

    @Override
    protected int computeScore() throws IncompatibleScoringSchemeException {
        int c;
        int cols;
        int rows = this.seq1.length() + 1;
        if (rows <= (cols = this.seq2.length() + 1)) {
            int r;
            int[] array = new int[rows];
            array[0] = 0;
            for (r = 1; r < rows; ++r) {
                array[r] = array[r - 1] + this.scoreDeletion(this.seq1.charAt(r));
            }
            for (int c2 = 1; c2 < cols; ++c2) {
                int tmp = array[0] + this.scoreInsertion(this.seq2.charAt(c2));
                for (r = 1; r < rows; ++r) {
                    int ins = array[r] + this.scoreInsertion(this.seq2.charAt(c2));
                    int sub = array[r - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c2));
                    int del = tmp + this.scoreDeletion(this.seq1.charAt(r));
                    array[r - 1] = tmp;
                    tmp = this.max(ins, sub, del);
                }
                array[rows - 1] = tmp;
            }
            return array[rows - 1];
        }
        int[] array = new int[cols];
        array[0] = 0;
        for (c = 1; c < cols; ++c) {
            array[c] = array[c - 1] + this.scoreInsertion(this.seq2.charAt(c));
        }
        for (int r = 1; r < rows; ++r) {
            int tmp = array[0] + this.scoreDeletion(this.seq1.charAt(r));
            for (c = 1; c < cols; ++c) {
                int ins = tmp + this.scoreInsertion(this.seq2.charAt(c));
                int sub = array[c - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c));
                int del = array[c] + this.scoreDeletion(this.seq1.charAt(r));
                array[c - 1] = tmp;
                tmp = this.max(ins, sub, del);
            }
            array[cols - 1] = tmp;
        }
        return array[cols - 1];
    }
}

