/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import net.maizegenetics.analysis.gbs.neobio.Matrix;

public class OutMatrix
implements Matrix {
    protected int max_length;
    protected int max_score;
    protected int[][] dist;
    protected int[] input_border;
    protected int dim;
    protected int lc;

    public void init(int max_length, int max_score) {
        this.max_length = max_length;
        this.max_score = max_score;
    }

    public void setData(int[][] dist, int[] input_border, int dim, int lc) {
        this.dist = dist;
        this.input_border = input_border;
        this.dim = dim;
        this.lc = lc;
    }

    @Override
    public int valueAt(int row, int col) {
        if (col < this.lc) {
            if (row < this.dim - (this.lc - col)) {
                return this.dist[col][row] + this.input_border[row];
            }
            return -(this.max_length + row + 1) * this.max_score;
        }
        if (col == this.lc) {
            return this.dist[col][row] + this.input_border[row];
        }
        if (row < col - this.lc) {
            return Integer.MIN_VALUE + row;
        }
        return this.dist[col][row - (col - this.lc)] + this.input_border[row];
    }

    @Override
    public int numRows() {
        return this.dim;
    }

    @Override
    public int numColumns() {
        return this.dim;
    }
}

