/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidScoringMatrixException;
import net.maizegenetics.analysis.gbs.neobio.ScoringScheme;

public class ScoringMatrix
extends ScoringScheme {
    protected static final char INDEL_CHAR = '*';
    protected static final char COMMENT_CHAR = '#';
    protected String col_codes;
    protected String row_codes;
    protected int[][] matrix;
    protected int dimension;
    protected int max_absolute_score;

    public ScoringMatrix(Reader input) throws IOException, InvalidScoringMatrixException {
        this(input, true);
    }

    public ScoringMatrix(Reader input, boolean case_sensitive) throws IOException, InvalidScoringMatrixException {
        super(case_sensitive);
        int i;
        StringBuffer buf = new StringBuffer();
        int max_abs = 0;
        StreamTokenizer in = new StreamTokenizer(input);
        in.commentChar(35);
        in.eolIsSignificant(true);
        in.nextToken();
        while (in.ttype == 10) {
            in.nextToken();
        }
        while (in.ttype != -1 && in.ttype != 10) {
            if (in.ttype == -3) {
                if (in.sval.length() > 1) {
                    throw new InvalidScoringMatrixException("Column headers must have one-character only.");
                }
                buf.append(in.sval.charAt(0));
            } else if (in.ttype == 42) {
                buf.append('*');
            } else {
                throw new InvalidScoringMatrixException("Column headers must be one-character codes or the special character '*'.");
            }
            in.nextToken();
        }
        this.col_codes = case_sensitive ? buf.toString() : buf.toString().toUpperCase();
        this.dimension = this.col_codes.length();
        if (this.col_codes.indexOf(42) == -1) {
            throw new InvalidScoringMatrixException("Matrix have no column for deletion penalties.");
        }
        if (this.dimension < 2) {
            throw new InvalidScoringMatrixException("Matrix must have at least one column with a character code.");
        }
        for (i = 0; i < this.dimension; ++i) {
            if (this.col_codes.indexOf(this.col_codes.charAt(i), i + 1) <= i) continue;
            throw new InvalidScoringMatrixException("Columns must have distinct one-character codes.");
        }
        this.matrix = new int[this.dimension][this.dimension];
        buf.delete(0, this.dimension);
        in.eolIsSignificant(false);
        if (in.ttype == 10) {
            in.nextToken();
        }
        for (int row = 0; row < this.dimension && in.ttype != -1; ++row) {
            if (in.ttype == -3) {
                if (in.sval.length() > 1) {
                    throw new InvalidScoringMatrixException("Codes must have one character only.");
                }
                buf.append(in.sval.charAt(0));
            } else if (in.ttype == 42) {
                buf.append('*');
            } else {
                throw new InvalidScoringMatrixException("Rows must start with an one-character code or the special character '*'.");
            }
            for (int col = 0; col < this.dimension; ++col) {
                if (in.nextToken() != -2) {
                    throw new InvalidScoringMatrixException("Invalid value at row " + (row + 1) + ", column " + (col + 1) + ".");
                }
                this.matrix[row][col] = (int)in.nval;
                if (Math.abs(this.matrix[row][col]) <= max_abs) continue;
                max_abs = Math.abs(this.matrix[row][col]);
            }
            in.nextToken();
        }
        this.row_codes = case_sensitive ? buf.toString() : buf.toString().toUpperCase();
        if (this.row_codes.length() != this.dimension) {
            throw new InvalidScoringMatrixException("Matrix must have as many rows as columns.");
        }
        if (this.row_codes.indexOf(42) == -1) {
            throw new InvalidScoringMatrixException("Matrix have no row for insertion penalties.");
        }
        for (i = 0; i < this.dimension; ++i) {
            if (this.row_codes.indexOf(this.row_codes.charAt(i), i + 1) <= i) continue;
            throw new InvalidScoringMatrixException("Rows must have distinct one-character codes.");
        }
        for (i = 0; i < this.dimension; ++i) {
            char c = this.row_codes.charAt(i);
            if (this.col_codes.indexOf(c) != -1) continue;
            throw new InvalidScoringMatrixException("There is no corresponding column for row character '" + c + "'.");
        }
        this.max_absolute_score = max_abs;
    }

    @Override
    public int scoreSubstitution(char a, char b) throws IncompatibleScoringSchemeException {
        int c;
        int r;
        if (this.case_sensitive) {
            r = this.row_codes.indexOf(a);
            c = this.col_codes.indexOf(b);
        } else {
            r = this.row_codes.indexOf(Character.toUpperCase(a));
            c = this.col_codes.indexOf(Character.toUpperCase(b));
        }
        if (r < 0 || c < 0) {
            throw new IncompatibleScoringSchemeException("Substitution of character " + a + " for " + b + " is not defined.");
        }
        return this.matrix[r][c];
    }

    @Override
    public int scoreInsertion(char a) throws IncompatibleScoringSchemeException {
        return this.scoreSubstitution('*', a);
    }

    @Override
    public int scoreDeletion(char a) throws IncompatibleScoringSchemeException {
        return this.scoreSubstitution(a, '*');
    }

    @Override
    public boolean isPartialMatchSupported() {
        return true;
    }

    @Override
    public int maxAbsoluteScore() {
        return this.max_absolute_score;
    }

    public String toString() {
        int col;
        StringBuffer buf = new StringBuffer();
        buf.append("Scoring matrix:\n\t");
        for (col = 0; col < this.dimension; ++col) {
            buf.append("\t" + col);
        }
        buf.append("\n\t");
        for (col = 0; col < this.dimension; ++col) {
            buf.append('\t');
            buf.append(this.col_codes.charAt(col));
        }
        for (int row = 0; row < this.dimension; ++row) {
            buf.append("\n" + row + "\t" + this.row_codes.charAt(row));
            for (col = 0; col < this.dimension; ++col) {
                buf.append('\t');
                buf.append(this.matrix[row][col]);
            }
        }
        return buf.toString();
    }
}

