/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanABuildPivotTBTPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanABuildPivotTBTPlugin.class);
    String masterTagCountFileS = null;
    String tagCountDirS = null;
    String tbtFileS = null;
    IHDF5Writer h5 = null;

    public PanABuildPivotTBTPlugin() {
        super(null, false);
    }

    public PanABuildPivotTBTPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -m  master TagCount file\n -d  directory containing tagCount files\n -o  output TBT\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        Object[] tcFiles = new File(this.tagCountDirS).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("cnt");
            }
        });
        Arrays.sort(tcFiles);
        String[] taxaNames = new String[tcFiles.length];
        for (int i = 0; i < taxaNames.length; ++i) {
            taxaNames[i] = ((File)tcFiles[i]).getName().substring(0, ((File)tcFiles[i]).getName().length() - 4);
        }
        TagCounts masterTc = new TagCounts(this.masterTagCountFileS, TagsByTaxa.FilePacking.Byte);
        TagCounts[] tcs = new TagCounts[taxaNames.length];
        for (int i = 0; i < tcs.length; ++i) {
            tcs[i] = new TagCounts(((File)tcFiles[i]).getAbsolutePath(), TagsByTaxa.FilePacking.Byte);
        }
        this.naiveBuildTBT(masterTc, taxaNames, tcs);
        return null;
    }

    private void naiveBuildTBT(TagCounts masterTC, String[] taxaNames, TagCounts[] tcs) {
        long[][] newTags = new long[masterTC.getTagSizeInLong()][masterTC.getTagCount()];
        for (int i = 0; i < masterTC.getTagCount(); ++i) {
            long[] ct = masterTC.getTag(i);
            for (int j = 0; j < masterTC.getTagSizeInLong(); ++j) {
                newTags[j][i] = ct[j];
            }
        }
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(this.tbtFileS));
        System.out.println("Creating HDF5 file: " + this.tbtFileS);
        config.overwrite();
        config.dontUseExtendableDataTypes();
        config.useUTF8CharacterEncoding();
        this.h5 = config.writer();
        this.h5.int32().setAttr("/", "tagCount", masterTC.getTagCount());
        this.h5.int32().setAttr("/", "chunkSize", 65536);
        this.h5.int32().setAttr("/", "tagLengthInLong", masterTC.getTagSizeInLong());
        this.h5.int32().setAttr("/", "taxaNum", taxaNames.length);
        this.h5.int64().createMatrix("tags", (long)masterTC.getTagSizeInLong(), (long)masterTC.getTagCount(), masterTC.getTagSizeInLong(), masterTC.getTagCount());
        this.h5.writeLongMatrix("tags", newTags);
        this.h5.int8().createArray("tagLength", masterTC.getTagCount());
        this.h5.writeByteArray("tagLength", masterTC.getTagLength());
        this.h5.object().createGroup("tbttg");
        int tagChunks = masterTC.getTagCount() >> 16;
        if (masterTC.getTagCount() % 65536 > 0) {
            ++tagChunks;
        }
        System.out.println(65536);
        System.out.printf("tagChunks %d Div %g %n", tagChunks, (double)masterTC.getTagCount() / 65536.0);
        this.h5.int32().setAttr("tbttg/", "tagCount", masterTC.getTagCount());
        this.h5.int32().setAttr("tbttg/", "tagChunks", tagChunks);
        for (int tc = 0; tc < tagChunks; ++tc) {
            this.h5.object().createGroup("tbttg/c" + tc);
        }
        this.h5.string().createArrayVL("tbttg/taxaNames", taxaNames.length);
        this.h5.string().writeArrayVL("tbttg/taxaNames", taxaNames);
        byte cnt = 0;
        for (int i = 0; i < masterTC.getTagCount(); ++i) {
            byte[] td = new byte[taxaNames.length];
            long[] t = masterTC.getTag(i);
            for (int j = 0; j < taxaNames.length; ++j) {
                int index = tcs[j].getTagIndex(t);
                cnt = index < 0 ? (byte)0 : (byte)tcs[j].getReadCount(index);
                td[j] = cnt;
            }
            int chunk = i >> 16;
            String d = "tbttg/c" + chunk + "/" + i;
            byte[] deftc = TagsByTaxaByteHDF5TagGroups.encodeBySign(td);
            this.h5.int8().createArray(d, deftc.length);
            this.h5.writeByteArray(d, deftc);
        }
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-m", "--master-TC", true);
            this.engine.add("-d", "--directory-TC", true);
            this.engine.add("-o", "--output-TBT", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-m")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.masterTagCountFileS = this.engine.getString("-m");
        if (!this.engine.getBoolean("-d")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.tagCountDirS = this.engine.getString("-d");
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.tbtFileS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

