/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanASplitTBTPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanASplitTBTPlugin.class);
    String tbtHDF5 = null;
    String outDirS = null;
    int chunkSize = 65536;

    public PanASplitTBTPlugin() {
        super(null, false);
    }

    public PanASplitTBTPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  input TagsByTaxa(TBT) file, TagsByTaxaByteHDF5TagGroups format\n -s  chunkSize, number of tags in a sub TBT. This determines the mapping calculation time usage in a node/computer. Default = 65536\n -o  output directory of sub TBTs\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        int big;
        TagsByTaxaByteHDF5TagGroups tbt = new TagsByTaxaByteHDF5TagGroups(this.tbtHDF5);
        int tagNum = tbt.getTagCount();
        int base = tagNum % this.chunkSize;
        int fileNum = base == 0 ? tagNum / this.chunkSize : tagNum / this.chunkSize + 1;
        System.out.println("TBT will be split into " + String.valueOf(fileNum) + " subTBTs");
        for (big = 10; fileNum > big; big *= 10) {
        }
        for (int i = 0; i < fileNum; ++i) {
            int actualSize = this.chunkSize;
            if (i == fileNum - 1 && base != 0) {
                actualSize = base;
            }
            int actualStart = i * this.chunkSize;
            int actualEnd = actualStart + actualSize;
            String fileName = "0" + String.valueOf(big + i).substring(1);
            fileName = "pivotTBT_" + fileName + "_" + String.valueOf(actualStart) + "_" + String.valueOf(actualSize) + ".h5";
            fileName = new File(this.outDirS, fileName).getAbsolutePath();
            int[] selectIndex = new int[actualSize];
            for (int j = 0; j < actualSize; ++j) {
                selectIndex[j] = actualStart + j;
            }
            tbt.writeDistFile(fileName, selectIndex);
            System.out.println("Completed " + String.valueOf((double)(i + 1) / (double)fileNum));
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-TBT", true);
            this.engine.add("-s", "--chunk-size", true);
            this.engine.add("-o", "--output-dir", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.tbtHDF5 = this.engine.getString("-i");
        if (this.engine.getBoolean("-s")) {
            this.chunkSize = Integer.valueOf(this.engine.getString("-s"));
        } else {
            System.out.println("Default chunkSize is " + String.valueOf(this.chunkSize));
            this.printUsage();
        }
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.outDirS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

